/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.test.property.immutable;

import com.extollit.linalg.immutable.IntAxisAlignedBox;
import com.extollit.linalg.immutable.Vec3i;
import com.extollit.test.property.IGenerator;
import java.util.Random;

public class Generators {

    public static final class Vec3iGen
    implements IGenerator<Vec3i> {
        private final Vec3i mp;
        private final int range;

        public Vec3iGen(Vec3i mp, int range) {
            this.mp = mp;
            this.range = range;
        }

        @Override
        public Vec3i next(Random random) {
            int dr = this.range - this.range / 2;
            int dx = random.nextInt(dr);
            int dy = random.nextInt(dr);
            int dz = random.nextInt(dr);
            return this.mp.plusOf(new Vec3i(dx, dy, dz));
        }
    }

    public static final class IntAxisAlignedBoxGen
    implements IGenerator<IntAxisAlignedBox> {
        private final Vec3iGen ming;
        private final Vec3iGen maxg;

        public IntAxisAlignedBoxGen(Vec3i mp, int range) {
            int halfRange = range / 2;
            this.ming = new Vec3iGen(mp.subOf(halfRange), halfRange);
            this.maxg = new Vec3iGen(mp.plusOf(halfRange), halfRange);
        }

        @Override
        public IntAxisAlignedBox next(Random random) {
            return new IntAxisAlignedBox(this.ming.next(random), this.maxg.next(random));
        }
    }
}

