/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractNode;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import com.extollit.tree.binary.TreeNodeIterator;
import java.util.NoSuchElementException;

abstract class AbstractTreeNodeIterator<T, Node extends AbstractNode<T, Node>>
implements TreeNodeIterator<T, Node> {
    protected final IBinaryTree<T, Node> tree;
    protected Node node;
    protected Node node0;

    public AbstractTreeNodeIterator(IBinaryTree<T, Node> tree) {
        this.node = (AbstractNode)tree.root();
        this.tree = tree;
    }

    protected abstract Node findNext();

    @Override
    public boolean hasNext() {
        return this.node != null;
    }

    private void moveNext() {
        this.node0 = this.node;
        this.node = this.findNext();
    }

    @Override
    public Node next() {
        if (this.first()) {
            this.node = this.findNext();
        }
        Node current = this.node;
        this.moveNext();
        if (current == null) {
            throw new NoSuchElementException();
        }
        return current;
    }

    @Override
    public void remove() {
        if (this.node0 == null) {
            throw new NoSuchElementException();
        }
        this.tree.remove((ITreeNode<T, ?>)this.node0);
    }

    @Override
    public Node pruneWith(T data) {
        if (this.node0 == null) {
            throw new NoSuchElementException();
        }
        AbstractNode newNode = (AbstractNode)this.tree.createLeaf(data);
        if (this.node0 == this.tree.root()) {
            this.tree.root(newNode);
        } else {
            ((AbstractNode)this.node0).replaceWith((AbstractNode)newNode);
        }
        return this.node0;
    }

    @Override
    public T changeTo(T data) {
        if (this.node0 == null) {
            throw new NoSuchElementException();
        }
        Object data0 = ((AbstractNode)this.node0).data;
        ((AbstractNode)this.node0).data = data;
        return data0;
    }

    protected abstract boolean first();

    protected static enum Arm {
        left,
        top,
        right;

    }
}

