/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractBinaryTree;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import com.extollit.tree.binary.Node;
import java.util.Comparator;

public class CartesianTree<T>
extends AbstractBinaryTree<T, Node<T>>
implements IBinaryTree<T, Node<T>> {
    private final Comparator<T> comparator;
    private Node<T> previous;

    public CartesianTree(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void insert(T data) {
        Node lesser;
        for (lesser = this.previous; lesser != null && this.comparator.compare(lesser.data(), data) >= 0; lesser = (Node)lesser.parent()) {
        }
        this.previous = this.insertAfter(data, lesser);
    }

    public void subjugate(T data) {
        if (this.root == null) {
            this.insert(data);
        } else {
            this.previous = this.insertAfter(data, this.previous);
        }
    }

    public void append(T data) {
        if (this.root == null) {
            this.insert(data);
        } else {
            this.insertAfter(data, this.previous);
        }
    }

    public void uppend(T data) {
        if (this.root == null) {
            this.insert(data);
        } else {
            this.insertUp(data, this.previous);
        }
    }

    public void attach(CartesianTree<T> subTree) {
        this.attach((Node)subTree.root);
    }

    private void attach(Node<T> node) {
        if (this.root == null) {
            this.root = node;
            this.previous = null;
            node.remove();
        } else {
            if (this.previous.right() != null) {
                throw new IllegalStateException();
            }
            this.previous.childRight(node);
        }
    }

    private Node<T> insertAfter(T data, Node<T> previous) {
        Node<T> newNode;
        if (previous == null) {
            newNode = this.root = new Node<T>(data, (Node)this.root, null);
        } else {
            newNode = previous.createChild((Object)data);
            newNode.childLeft(previous.right());
            previous.childRight(newNode);
        }
        return newNode;
    }

    private Node<T> insertUp(T data, Node<T> proceeding) {
        Node<T> newNode;
        if (proceeding == null) {
            newNode = this.root = new Node<T>(data, (Node)this.root, null);
        } else {
            Node up = (Node)proceeding.parent();
            if (up == null) {
                this.root = new Node<T>(data, proceeding, null);
                newNode = this.root;
            } else {
                newNode = up.createChild((Object)data);
                proceeding.replaceWith(newNode);
                newNode.childLeft(proceeding);
            }
        }
        return newNode;
    }

    public ITreeNode<T, ? extends ITreeNode<T, ?>> previous() {
        return this.previous;
    }

    @Override
    public Node<T> createLeaf(T data) {
        return new Node<T>(data);
    }
}

