/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tuple;

public class Triple<A, B, C> {
    public final A first;
    public final B second;
    public final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public Sealed<A, B, C> sealed() {
        return new Sealed<A, B, C>(this.first, this.second, this.third);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        if (!this.first.equals(triple.first)) {
            return false;
        }
        if (!this.second.equals(triple.second)) {
            return false;
        }
        return this.third.equals(triple.third);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        result = 31 * result + this.third.hashCode();
        return result;
    }

    public String toString() {
        return '(' + this.first.toString() + ',' + this.second.toString() + ',' + this.third.toString() + ')';
    }

    public static class Sealed<A, B, C> {
        public final A first;
        public final B second;
        public final C third;

        public Sealed(A first, B second, C third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public static <A, B, C> Sealed<A, B, C> of(A first, B second, C third) {
            return new Sealed<A, B, C>(first, second, third);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sealed triple = (Sealed)o;
            if (!this.first.equals(triple.first)) {
                return false;
            }
            if (!this.second.equals(triple.second)) {
                return false;
            }
            return this.third.equals(triple.third);
        }

        public int hashCode() {
            int result = this.first.hashCode();
            result = 31 * result + this.second.hashCode();
            result = 31 * result + this.third.hashCode();
            return result;
        }

        public String toString() {
            return '(' + this.first.toString() + ',' + this.second.toString() + ',' + this.third.toString() + ')';
        }
    }
}

