/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.entries;

import com.typewritermc.core.utils.point.Position;
import com.typewritermc.roadnetwork.entries.PathStream;
import com.typewritermc.roadnetwork.entries.PathStreamDisplay;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/typewritermc/roadnetwork/entries/LinePathStream;", "Lcom/typewritermc/roadnetwork/entries/PathStream;", "displays", "", "Lcom/typewritermc/roadnetwork/entries/PathStreamDisplay;", "path", "Lcom/typewritermc/core/utils/point/Position;", "speed", "", "<init>", "(Ljava/util/List;Ljava/util/List;D)V", "getPath", "()Ljava/util/List;", "getSpeed", "()D", "totalDuration", "getTotalDuration", "percentage", "getPercentage", "index", "", "getIndex", "()I", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/core/utils/point/Position;", "forwardPath", "shouldContinue", "", "RoadNetworkExtension"})
@SourceDebugExtension(value={"SMAP\nLinePathStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinePathStream.kt\ncom/typewritermc/roadnetwork/entries/LinePathStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class LinePathStream
extends PathStream {
    @NotNull
    private final List<Position> path;
    private final double speed;
    private final double totalDuration;

    public LinePathStream(@NotNull List<? extends PathStreamDisplay> displays, @NotNull List<Position> path, double speed) {
        Intrinsics.checkNotNullParameter(displays, (String)"displays");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        super(displays);
        this.path = path;
        this.speed = speed;
        if (!(!((Collection)this.path).isEmpty())) {
            boolean $i$a$-require-LinePathStream$42 = false;
            String $i$a$-require-LinePathStream$42 = "Path must not be empty";
            throw new IllegalArgumentException($i$a$-require-LinePathStream$42.toString());
        }
        if (!(this.getStartTime() >= 0L)) {
            boolean $i$a$-require-LinePathStream$52 = false;
            String $i$a$-require-LinePathStream$52 = "Start time must not be negative";
            throw new IllegalArgumentException($i$a$-require-LinePathStream$52.toString());
        }
        if (!(this.speed > 0.0)) {
            boolean bl = false;
            String string = "Speed must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.totalDuration = (double)this.path.size() / this.speed * (double)1000L;
    }

    @NotNull
    public final List<Position> getPath() {
        return this.path;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final double getTotalDuration() {
        return this.totalDuration;
    }

    public final double getPercentage() {
        long diff = System.currentTimeMillis() - this.getStartTime();
        return (double)diff / this.totalDuration;
    }

    public final int getIndex() {
        return RangesKt.coerceIn((int)((int)((double)this.path.size() * this.getPercentage())), (int)0, (int)(this.path.size() - 1));
    }

    @NotNull
    public final Position getCurrentPosition() {
        return this.path.get(this.getIndex());
    }

    @Override
    @NotNull
    public Position forwardPath() {
        return this.getCurrentPosition();
    }

    @Override
    public boolean shouldContinue() {
        return (double)System.currentTimeMillis() < (double)this.getStartTime() + this.totalDuration;
    }
}

