/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.gps;

import com.typewritermc.core.utils.point.Position;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/roadnetwork/gps/GPSEdge;", "", "start", "Lcom/typewritermc/core/utils/point/Position;", "end", "weight", "", "length", "<init>", "(Lcom/typewritermc/core/utils/point/Position;Lcom/typewritermc/core/utils/point/Position;DD)V", "getStart", "()Lcom/typewritermc/core/utils/point/Position;", "getEnd", "getWeight", "()D", "getLength", "isFastTravel", "", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "RoadNetworkExtension"})
public final class GPSEdge {
    @NotNull
    private final Position start;
    @NotNull
    private final Position end;
    private final double weight;
    private final double length;

    public GPSEdge(@NotNull Position start, @NotNull Position end, double weight, double length) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.weight = weight;
        this.length = length;
    }

    @NotNull
    public final Position getStart() {
        return this.start;
    }

    @NotNull
    public final Position getEnd() {
        return this.end;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final double getLength() {
        return this.length;
    }

    public final boolean isFastTravel() {
        return this.weight == 0.0;
    }

    @NotNull
    public final Position component1() {
        return this.start;
    }

    @NotNull
    public final Position component2() {
        return this.end;
    }

    public final double component3() {
        return this.weight;
    }

    public final double component4() {
        return this.length;
    }

    @NotNull
    public final GPSEdge copy(@NotNull Position start, @NotNull Position end, double weight, double length) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new GPSEdge(start, end, weight, length);
    }

    public static /* synthetic */ GPSEdge copy$default(GPSEdge gPSEdge, Position position, Position position2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            position = gPSEdge.start;
        }
        if ((n & 2) != 0) {
            position2 = gPSEdge.end;
        }
        if ((n & 4) != 0) {
            d = gPSEdge.weight;
        }
        if ((n & 8) != 0) {
            d2 = gPSEdge.length;
        }
        return gPSEdge.copy(position, position2, d, d2);
    }

    @NotNull
    public String toString() {
        return "GPSEdge(start=" + this.start + ", end=" + this.end + ", weight=" + this.weight + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + Double.hashCode(this.weight);
        result = result * 31 + Double.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GPSEdge)) {
            return false;
        }
        GPSEdge gPSEdge = (GPSEdge)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)gPSEdge.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)gPSEdge.end)) {
            return false;
        }
        if (Double.compare(this.weight, gPSEdge.weight) != 0) {
            return false;
        }
        return Double.compare(this.length, gPSEdge.length) == 0;
    }
}

