/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingIterator<T>
implements Iterator<T> {
    private final Iterable<T> iterable;
    private Iterator<T> delegate;
    private Iterator<T> delegate0;
    private boolean available;

    public RingIterator(Iterable<T> iterable) {
        this.iterable = iterable;
        this.reset();
    }

    public void reset() {
        this.delegate0 = null;
        this.delegate = this.iterable.iterator();
        this.available = this.delegate.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (!this.delegate.hasNext()) {
            this.delegate = this.iterable.iterator();
            this.available = this.delegate.hasNext();
            return this.available;
        }
        return this.available;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.delegate.next();
            return t;
        }
        finally {
            this.delegate0 = this.delegate;
        }
    }

    @Override
    public void remove() {
        if (this.delegate0 == null) {
            throw new IllegalStateException();
        }
        this.delegate0.remove();
    }
}

