/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.FilterIterable;
import com.extollit.collect.FlattenIterable;
import com.extollit.linalg.immutable.IntAxisAlignedBox;
import com.extollit.linalg.immutable.Vec3i;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SparseSpatialMap<T>
implements Map<Vec3i, T> {
    private static final float INNER_LOAD_FACTOR = 0.75f;
    private static final float OUTER_LOAD_FACTOR = 0.9f;
    private final int order;
    private final int mask;
    private int size;
    private Vec3i key0;
    private Map<GreaterCoarseKey, T> inner0;
    private final Map<LesserCoarseKey, Map<GreaterCoarseKey, T>> space;

    public SparseSpatialMap(int order) {
        this.order = order;
        this.mask = (2 << order) - 1;
        this.space = new HashMap<LesserCoarseKey, Map<GreaterCoarseKey, T>>(1 << this.order >> 2, 0.9f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Vec3i coords) {
        Map<GreaterCoarseKey, T> inner = this.acquireInner(coords);
        if (inner != null) {
            GreaterCoarseKey greaterKey = this.greaterKey(coords);
            return inner.containsKey(greaterKey);
        }
        return false;
    }

    @Override
    public boolean containsKey(Object coords) {
        return this.containsKey((Vec3i)coords);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        for (Map<GreaterCoarseKey, T> inner : this.space.values()) {
            if (!inner.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public T get(Vec3i coords) {
        Map<GreaterCoarseKey, T> inner = this.acquireInner(coords);
        if (inner != null) {
            GreaterCoarseKey greaterKey = this.greaterKey(coords);
            return inner.get(greaterKey);
        }
        return null;
    }

    @Override
    public T get(Object coords) {
        return this.get((Vec3i)coords);
    }

    @Override
    public T put(Vec3i coords, T value) {
        T value0;
        if (value == null || coords == null) {
            throw new NullPointerException();
        }
        this.key0 = coords;
        LesserCoarseKey lesserKey = this.lesserKey(this.key0);
        this.inner0 = this.space.get(lesserKey);
        Map<GreaterCoarseKey, T> inner = this.inner0;
        if (inner == null) {
            this.inner0 = new HashMap<GreaterCoarseKey, T>(this.order << 2, 0.75f);
            inner = this.inner0;
            this.space.put(lesserKey, this.inner0);
        }
        if ((value0 = inner.put(this.greaterKey(coords), value)) == null) {
            ++this.size;
        }
        return value0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(Vec3i coords) {
        Map<GreaterCoarseKey, T> inner;
        if (coords == null) {
            throw new NullPointerException();
        }
        LesserCoarseKey lesserKey = this.lesserKey(coords);
        if (coords.equals(this.key0)) {
            inner = this.inner0;
        } else {
            this.key0 = coords;
            this.inner0 = this.space.get(lesserKey);
            inner = this.inner0;
        }
        if (inner != null) {
            try {
                GreaterCoarseKey greaterKey = this.greaterKey(coords);
                T value0 = inner.remove(greaterKey);
                if (value0 != null) {
                    --this.size;
                }
                T t = value0;
                return t;
            }
            finally {
                if (inner.isEmpty()) {
                    this.space.remove(lesserKey);
                    this.key0 = null;
                    this.inner0 = null;
                }
            }
        }
        return null;
    }

    @Override
    public T remove(Object key) {
        return this.remove((Vec3i)key);
    }

    @Override
    public void putAll(Map<? extends Vec3i, ? extends T> m) {
        for (Map.Entry<Vec3i, T> entry2 : m.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public void clear() {
        this.space.clear();
        this.size = 0;
        this.inner0 = null;
        this.key0 = null;
    }

    public Iterable<T> cullOutside(IntAxisAlignedBox bounds) {
        return this.cullOutside(bounds.min, bounds.max);
    }

    public Iterable<T> cullOutside(Vec3i boundsMin, Vec3i boundsMax) {
        LesserCoarseKey min = this.lesserKey(boundsMin);
        LesserCoarseKey max = this.lesserKey(boundsMax);
        int size0 = this.size;
        LinkedList<Collection<T>> cullees = new LinkedList<Collection<T>>();
        Iterator<Map.Entry<LesserCoarseKey, Map<GreaterCoarseKey, T>>> i = this.space.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<LesserCoarseKey, Map<GreaterCoarseKey, T>> entry2 = i.next();
            LesserCoarseKey key = entry2.getKey();
            Map<GreaterCoarseKey, T> subMap = entry2.getValue();
            if (key.x >= min.x && key.y >= min.y && key.z >= min.z && key.x <= max.x && key.y <= max.y && key.z <= max.z) continue;
            i.remove();
            cullees.add(subMap.values());
            this.size -= subMap.size();
        }
        if (size0 != this.size) {
            this.inner0 = null;
            this.key0 = null;
        }
        return new FlattenIterable(cullees);
    }

    @Override
    public Set<Vec3i> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<T> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<Vec3i, T>> entrySet() {
        return new EntrySet();
    }

    private LesserCoarseKey lesserKey(Vec3i coords) {
        return new LesserCoarseKey(coords.x >> this.order, coords.y >> this.order, coords.z >> this.order);
    }

    private GreaterCoarseKey greaterKey(Vec3i coords) {
        return new GreaterCoarseKey(coords.x & this.mask, coords.y & this.mask, coords.z & this.mask);
    }

    private Vec3i coords(LesserCoarseKey lesserKey, GreaterCoarseKey greaterKey) {
        return new Vec3i(lesserKey.x << this.order & ~this.mask | greaterKey.x, lesserKey.y << this.order & ~this.mask | greaterKey.y, lesserKey.z << this.order & ~this.mask | greaterKey.z);
    }

    private Map<GreaterCoarseKey, T> acquireInner(Vec3i coords) {
        if (coords.equals(this.key0)) {
            return this.inner0;
        }
        this.key0 = coords;
        LesserCoarseKey lesserKey = this.lesserKey(this.key0);
        this.inner0 = this.space.get(lesserKey);
        return this.inner0;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Vec3i, T>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Vec3i, T>> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return SparseSpatialMap.this.size;
        }

        private final class Iter
        extends AbstractIterator<Map.Entry<Vec3i, T>> {
            private Iter() {
            }

            @Override
            protected final Map.Entry<Vec3i, T> map(Vec3i key, T value) {
                return new AbstractMap.SimpleEntry(key, value);
            }
        }
    }

    private final class ValueCollection
    extends AbstractCollection<T> {
        private ValueCollection() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return SparseSpatialMap.this.size;
        }

        private final class Iter
        extends AbstractIterator<T> {
            private Iter() {
            }

            @Override
            protected final T map(Vec3i key, T value) {
                return value;
            }
        }
    }

    private final class KeySet
    extends AbstractSet<Vec3i> {
        private KeySet() {
        }

        @Override
        public Iterator<Vec3i> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return SparseSpatialMap.this.size;
        }

        private final class Iter
        extends AbstractIterator<Vec3i> {
            private Iter() {
            }

            @Override
            protected final Vec3i map(Vec3i key, T value) {
                return key;
            }
        }
    }

    private abstract class AbstractIterator<V>
    extends FilterIterable.Iter<V>
    implements Iterator<V> {
        private Iterator<Map.Entry<LesserCoarseKey, Map<GreaterCoarseKey, T>>> oi;
        private Iterator<Map.Entry<GreaterCoarseKey, T>> ii;
        private LesserCoarseKey lesserKey;

        public AbstractIterator() {
            this.oi = SparseSpatialMap.this.space.entrySet().iterator();
        }

        @Override
        protected V findNext() {
            Map.Entry<Object, Object> entry2;
            Iterator oi = this.oi;
            Iterator<Map.Entry<GreaterCoarseKey, Object>> ii = this.ii;
            while (ii == null || !ii.hasNext()) {
                if (oi.hasNext()) {
                    entry2 = oi.next();
                    this.lesserKey = (LesserCoarseKey)entry2.getKey();
                    this.ii = ((Map)entry2.getValue()).entrySet().iterator();
                    ii = this.ii;
                    continue;
                }
                return null;
            }
            entry2 = ii.next();
            Vec3i coords = SparseSpatialMap.this.coords(this.lesserKey, (GreaterCoarseKey)entry2.getKey());
            return this.map(coords, entry2.getValue());
        }

        protected abstract V map(Vec3i var1, T var2);
    }

    private static final class LesserCoarseKey {
        public final int x;
        public final int y;
        public final int z;
        private final int hashCode;

        private LesserCoarseKey(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            int result = 1;
            result = 31 * result + z;
            result = 31 * result + y;
            this.hashCode = result = 31 * result + x;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LesserCoarseKey lesserCoarseKey = (LesserCoarseKey)o;
            return this.x == lesserCoarseKey.x && this.y == lesserCoarseKey.y && this.z == lesserCoarseKey.z;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }

    private static final class GreaterCoarseKey {
        public final byte x;
        public final byte y;
        public final byte z;
        private final int hashCode;

        private GreaterCoarseKey(int x, int y, int z) {
            this.x = (byte)(x & 0xFF);
            this.y = (byte)(y & 0xFF);
            this.z = (byte)(z & 0xFF);
            int result = 1;
            result = 31 * result + z;
            result = 31 * result + y;
            this.hashCode = result = 31 * result + x;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GreaterCoarseKey greaterCoarseKey = (GreaterCoarseKey)o;
            return this.x == greaterCoarseKey.x && this.y == greaterCoarseKey.y && this.z == greaterCoarseKey.z;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

