/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect.cache;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractPurgeThread<O>
extends Thread {
    private static final int MAX_SLEEP_TIME = 1000;
    private static final int MIN_SLEEP_TIME = 1;
    private final List<WeakReference<O>> objects = new LinkedList<WeakReference<O>>();
    private volatile boolean running = true;
    private ListIterator<WeakReference<O>> iterator;
    private WeakReference<O> current;

    public AbstractPurgeThread(String name) {
        super(name);
        this.setPriority(2);
        this.setDaemon(true);
        this.iterator = this.objects.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int offset = 0;
        try {
            while (this.running) {
                AbstractPurgeThread abstractPurgeThread;
                try {
                    Object object;
                    abstractPurgeThread = this;
                    // MONITORENTER : abstractPurgeThread
                    int size = this.objects.size();
                    // MONITOREXIT : abstractPurgeThread
                    Thread.sleep(size == 0 ? 1000L : (long)Math.max(1, 1000 / size));
                    AbstractPurgeThread abstractPurgeThread2 = this;
                    // MONITORENTER : abstractPurgeThread2
                    ListIterator<WeakReference<O>> i = this.iterator;
                    WeakReference weakCache = this.current;
                    if (weakCache == null) {
                        if (!i.hasNext()) {
                            this.iterator = this.objects.listIterator();
                            i = this.iterator;
                        }
                        if (!i.hasNext()) {
                            // MONITOREXIT : abstractPurgeThread2
                            continue;
                        }
                        weakCache = this.current = (WeakReference)i.next();
                    }
                    if ((object = weakCache.get()) == null) {
                        i.remove();
                        this.current = null;
                    }
                    // MONITOREXIT : abstractPurgeThread2
                    if (object == null || (offset = this.cull(offset, object)) != 0) continue;
                    this.current = null;
                }
                catch (InterruptedException e) {
                    abstractPurgeThread = this;
                    // MONITORENTER : abstractPurgeThread
                    if (!this.running) {
                        // MONITOREXIT : abstractPurgeThread
                        return;
                    }
                    // MONITOREXIT : abstractPurgeThread
                }
            }
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected abstract int cull(int var1, O var2);

    public synchronized void quit() {
        this.running = false;
        this.interrupt();
        try {
            this.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void register(O object) {
        int index0 = this.iterator.nextIndex();
        this.objects.add(new WeakReference<O>(object));
        this.iterator = index0 >= this.objects.size() ? this.objects.listIterator() : this.objects.listIterator(index0);
    }
}

