/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.IColumnarSpace;
import com.extollit.gaming.ai.path.model.IOcclusionProvider;
import com.extollit.gaming.ai.path.model.OcclusionField;

public class AreaOcclusionProvider
implements IOcclusionProvider {
    private final IColumnarSpace[][] columnarSpaces;
    private final int cx0;
    private final int cz0;
    private final int cxN;
    private final int czN;

    public AreaOcclusionProvider(IColumnarSpace[][] columnarSpaces, int cx0, int cz0) {
        this.columnarSpaces = columnarSpaces;
        this.cx0 = cx0;
        this.cz0 = cz0;
        this.cxN = columnarSpaces[0].length + cx0 - 1;
        this.czN = columnarSpaces.length + cz0 - 1;
    }

    @Override
    public byte elementAt(int x, int y, int z) {
        int cxx;
        int czz;
        IColumnarSpace columnarSpace;
        IColumnarSpace[][] columnarSpaces = this.columnarSpaces;
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx >= this.cx0 && cx <= this.cxN && cz >= this.cz0 && cz <= this.czN && cy >= 0 && cy < 16 && (columnarSpace = columnarSpaces[czz = cz - this.cz0][cxx = cx - this.cx0]) != null) {
            OcclusionField field = columnarSpace.occlusionFields().occlusionFieldAt(cx, cy, cz);
            if (!field.areaInitFull()) {
                this.areaInit(field, x, y, z);
            }
            return field.elementAt(x & 0xF, y & 0xF, z & 0xF);
        }
        return 0;
    }

    private void areaInit(OcclusionField field, int x, int y, int z) {
        IColumnarSpace southColumnarSpace;
        IColumnarSpace[][] columnarSpaces = this.columnarSpaces;
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        int cxN = columnarSpaces[0].length - 1;
        int czN = columnarSpaces.length - 1;
        int czz = cz - this.cz0;
        int cxx = cx - this.cx0;
        int xx = x & 0xF;
        int yy = y & 0xF;
        int zz = z & 0xF;
        IColumnarSpace centerColumnarSpace = columnarSpaces[czz][cxx];
        if (xx == 0 && zz == 0 && !field.areaInitAt(OcclusionField.AreaInit.northWest) && cxx > 0 && czz > 0) {
            IColumnarSpace westColumnarSpace = columnarSpaces[czz - 1][cxx];
            IColumnarSpace northColumnarSpace = columnarSpaces[czz][cxx - 1];
            if (northColumnarSpace != null && westColumnarSpace != null) {
                field.areaInitNorthWest(northColumnarSpace.occlusionFields().occlusionFieldAt(cx - 1, cy, cz), westColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy, cz - 1));
            }
        } else if (xx == 15 && zz == 0 && !field.areaInitAt(OcclusionField.AreaInit.northEast) && cxx < cxN && czz > 0) {
            IColumnarSpace westColumnarSpace = columnarSpaces[czz - 1][cxx];
            IColumnarSpace eastColumnarSpace = columnarSpaces[czz][cxx + 1];
            if (eastColumnarSpace != null && westColumnarSpace != null) {
                field.areaInitNorthEast(eastColumnarSpace.occlusionFields().occlusionFieldAt(cx + 1, cy, cz), westColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy, cz - 1));
            }
        } else if (xx == 0 && zz == 15 && !field.areaInitAt(OcclusionField.AreaInit.southWest) && cxx > 0 && czz < czN) {
            IColumnarSpace northColumnarSpace = columnarSpaces[czz][cxx - 1];
            IColumnarSpace southColumnarSpace2 = columnarSpaces[czz + 1][cxx];
            if (northColumnarSpace != null && southColumnarSpace2 != null) {
                field.areaInitSouthWest(northColumnarSpace.occlusionFields().occlusionFieldAt(cx - 1, cy, cz), southColumnarSpace2.occlusionFields().occlusionFieldAt(cx, cy, cz + 1));
            }
        } else if (xx == 15 && zz == 15 && !field.areaInitAt(OcclusionField.AreaInit.southEast) && cxx < cxN && czz < czN) {
            IColumnarSpace eastColumnarSpace = columnarSpaces[czz][cxx + 1];
            IColumnarSpace southColumnarSpace3 = columnarSpaces[czz + 1][cxx];
            if (eastColumnarSpace != null && southColumnarSpace3 != null) {
                field.areaInitSouthEast(eastColumnarSpace.occlusionFields().occlusionFieldAt(cx + 1, cy, cz), southColumnarSpace3.occlusionFields().occlusionFieldAt(cx, cy, cz + 1));
            }
        } else if (xx == 0 && !field.areaInitAt(OcclusionField.AreaInit.west) && cxx > 0) {
            IColumnarSpace northColumnarSpace = columnarSpaces[czz][cxx - 1];
            if (northColumnarSpace != null) {
                field.areaInitWest(northColumnarSpace.occlusionFields().occlusionFieldAt(cx - 1, cy, cz));
            }
        } else if (xx == 15 && !field.areaInitAt(OcclusionField.AreaInit.east) && cxx < cxN) {
            IColumnarSpace eastColumnarSpace = columnarSpaces[czz][cxx + 1];
            if (eastColumnarSpace != null) {
                field.areaInitEast(eastColumnarSpace.occlusionFields().occlusionFieldAt(cx + 1, cy, cz));
            }
        } else if (zz == 0 && !field.areaInitAt(OcclusionField.AreaInit.north) && czz > 0) {
            IColumnarSpace westColumnarSpace = columnarSpaces[czz - 1][cxx];
            if (westColumnarSpace != null) {
                field.areaInitNorth(westColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy, cz - 1));
            }
        } else if (zz == 15 && !field.areaInitAt(OcclusionField.AreaInit.south) && czz < czN && (southColumnarSpace = columnarSpaces[czz + 1][cxx]) != null) {
            field.areaInitSouth(southColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy, cz + 1));
        }
        if (yy == 15 && !field.areaInitAt(OcclusionField.AreaInit.up)) {
            field.areaInitUp(centerColumnarSpace, cy, cy < 15 ? centerColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy + 1, cz) : null);
        } else if (yy == 0 && !field.areaInitAt(OcclusionField.AreaInit.down)) {
            field.areaInitDown(centerColumnarSpace, cy, cy > 0 ? centerColumnarSpace.occlusionFields().occlusionFieldAt(cx, cy - 1, cz) : null);
        }
    }

    @Override
    public String visualizeAt(int y) {
        return OcclusionField.visualizeAt(this, y, this.cx0 << 4, this.cz0 << 4, this.cxN + 1 << 4, this.czN + 1 << 4);
    }
}

