/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.IGraphNodeFilter;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INode;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IOcclusionProvider;
import com.extollit.gaming.ai.path.model.IOcclusionProviderFactory;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.gaming.ai.path.model.SortedPointQueue;
import com.extollit.gaming.ai.path.model.SparseSpatialMap;
import com.extollit.gaming.ai.path.persistence.internal.IdentityMapper;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import com.extollit.gaming.ai.path.persistence.internal.Vec3iReaderWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public final class NodeMap {
    private final SparseSpatialMap<Node> it = new SparseSpatialMap();
    private final IInstanceSpace instanceSpace;
    private final IOcclusionProviderFactory occlusionProviderFactory;
    private INodeCalculator calculator;
    private IGraphNodeFilter filter;
    private IOcclusionProvider occlusionProvider;
    private int cx0;
    private int cxN;
    private int cz0;
    private int czN;

    public NodeMap(IInstanceSpace instanceSpace, IOcclusionProviderFactory occlusionProviderFactory) {
        this(instanceSpace, null, occlusionProviderFactory);
    }

    public NodeMap(IInstanceSpace instanceSpace, INodeCalculator calculator, IOcclusionProviderFactory occlusionProviderFactory) {
        this.calculator = calculator;
        this.instanceSpace = instanceSpace;
        this.occlusionProviderFactory = occlusionProviderFactory;
    }

    public void filter(IGraphNodeFilter filter) {
        this.filter = filter;
        this.clear();
    }

    public IGraphNodeFilter filter() {
        return this.filter;
    }

    public void calculator(INodeCalculator calculator) {
        this.calculator = calculator;
        this.clear();
    }

    public final void reset(SortedPointQueue queue) {
        for (Node p : this.it.values()) {
            p.rollback();
        }
        queue.clear();
    }

    public final void cullBranchAt(Coords coords, SortedPointQueue queue) {
        this.cullBranchAt(coords.x, coords.y, coords.z, queue);
    }

    public final void cullBranchAt(int x, int y, int z, SortedPointQueue queue) {
        Node node = this.it.get(x, y, z);
        if (node == null) {
            return;
        }
        Node parent = node.up();
        queue.cullBranch(node);
        if (parent != null && !parent.assigned()) {
            parent.visited(false);
            queue.add(parent);
        }
        this.it.remove(x, y, z);
    }

    public final void reset() {
        this.clear();
        this.occlusionProvider = null;
    }

    public final void clear() {
        this.it.clear();
    }

    public boolean needsOcclusionProvider() {
        return this.occlusionProvider == null;
    }

    public byte flagsAt(int x, int y, int z) {
        return this.occlusionProvider.elementAt(x, y, z);
    }

    public void updateFieldWindow(int x0, int z0, int xN, int zN, boolean cull) {
        boolean windowTest;
        int cx0 = x0 >> 4;
        int cz0 = z0 >> 4;
        int cxN = xN >> 4;
        int czN = zN >> 4;
        IOcclusionProvider aop = this.occlusionProvider;
        if (cull) {
            windowTest = cx0 != this.cx0 || cz0 != this.cz0 || cxN != this.cxN || czN != this.czN;
        } else {
            boolean bl = windowTest = cx0 < this.cx0 || cz0 < this.cz0 || cxN > this.cxN || czN > this.czN;
        }
        if (aop == null || windowTest) {
            this.occlusionProvider = this.occlusionProviderFactory.fromInstanceSpace(this.instanceSpace, cx0, cz0, cxN, czN);
            this.cx0 = cx0;
            this.cz0 = cz0;
            this.cxN = cxN;
            this.czN = czN;
            if (cull) {
                this.cullOutside(x0, z0, xN, zN);
            }
        }
    }

    public Collection<Node> all() {
        return this.it.values();
    }

    public final void cullOutside(int x0, int z0, int xN, int zN) {
        for (Node p : this.it.cullOutside(x0, Integer.MIN_VALUE, z0, xN, Integer.MAX_VALUE, zN)) {
            p.rollback();
        }
    }

    public final Node cachedPointAt(int x, int y, int z) {
        Node point = this.it.get(x, y, z);
        if (point == null) {
            point = this.passibleNodeNear(x, y, z, null);
            Coords key = point.key;
            if (key.x != x || key.y != y || key.z != z) {
                point = new Node(x, y, z, Passibility.impassible, false);
            }
            this.it.put(x, y, z, point);
        }
        return point;
    }

    public Node cachedPassiblePointNear(int x, int y, int z) {
        return this.cachedPassiblePointNear(x, y, z, null);
    }

    public final Node cachedPassiblePointNear(int x, int y, int z, Coords origin) {
        SparseSpatialMap<Node> nodeMap = this.it;
        Node point0 = nodeMap.get(x, y, z);
        Node point = point0;
        if (point == null) {
            point = this.passibleNodeNear(x, y, z, origin);
        } else if (point.volatile_()) {
            point = this.passibleNodeNear(x, y, z, origin);
            if (point.key.equals(point0.key)) {
                point0.passibility(point.passibility());
                point0.volatile_(point.volatile_());
                point = point0;
            } else {
                point0.isolate();
            }
        }
        Coords key = point.key;
        if (key.x != x || key.y != y || key.z != z) {
            Node existing = nodeMap.get(key.x, key.y, key.z);
            if (existing == null) {
                nodeMap.put(key.x, key.y, key.z, point);
            } else {
                point = existing;
            }
        }
        if (point != point0) {
            nodeMap.put(x, y, z, point);
        }
        return point;
    }

    private Node passibleNodeNear(int x, int y, int z, Coords origin) {
        Passibility newPassibility;
        Node node = this.calculator.passibleNodeNear(x, y, z, origin, new FlagSampler(this.occlusionProvider));
        IGraphNodeFilter filter = this.filter;
        if (filter != null && (newPassibility = filter.mapPassibility(node)) != null) {
            node.passibility(newPassibility);
        }
        return node;
    }

    public boolean remove(int x, int y, int z) {
        Node existing = this.it.remove(x, y, z);
        if (existing != null) {
            existing.rollback();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.it.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMap nodeMap = (NodeMap)o;
        return this.it.equals(nodeMap.it);
    }

    public int hashCode() {
        return this.it.hashCode();
    }

    public void writeTo(ObjectOutput out, IdentityMapper<Node, Node.ReaderWriter> nodeIdentityMap) throws IOException {
        out.writeInt(this.cx0);
        out.writeInt(this.cz0);
        out.writeInt(this.cxN);
        out.writeInt(this.czN);
        SparseSpatialMap<Node> it = this.it;
        nodeIdentityMap.initialize(Node.ReaderWriter.INSTANCE, it.values(), out);
        nodeIdentityMap.writeWith(new MapReaderWriter(), it.keySet(), out);
    }

    public void readFrom(ObjectInput in, IdentityMapper<Node, Node.ReaderWriter> nodeIdentityMap) throws IOException {
        this.cx0 = in.readInt();
        this.cz0 = in.readInt();
        this.cxN = in.readInt();
        this.czN = in.readInt();
        Iterable<Node> nodes = nodeIdentityMap.readAll(in);
        nodeIdentityMap.readLinks(Node.ReaderWriter.INSTANCE, nodes, in);
        nodeIdentityMap.readWith(new MapReaderWriter(), in);
    }

    private final class MapReaderWriter
    extends Vec3iReaderWriter
    implements LinkableReader<Coords, Node>,
    LinkableWriter<Coords, Node> {
        private MapReaderWriter() {
        }

        @Override
        public void readLinkages(Coords object, ReferableObjectInput<Node> in) throws IOException {
            NodeMap.this.it.put(object.x, object.y, object.z, (INode)in.readRef());
        }

        @Override
        public void writeLinkages(Coords object, ReferableObjectOutput<Node> out) throws IOException {
            out.writeRef((Node)NodeMap.this.it.get(object.x, object.y, object.z));
        }
    }
}

