/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.gaming.ai.path.model.TreeTransitional;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

public final class SortedPointQueue
implements LinkableReader<SortedPointQueue, Node>,
LinkableWriter<SortedPointQueue, Node> {
    private static final float CULL_THRESHOLD = 0.1f;
    private final ArrayList<Node> list = new ArrayList(8);

    boolean fastAdd(Node point) {
        if (!point.index(this.list.size())) {
            return false;
        }
        this.list.add(point);
        this.sortBack(point.index());
        return true;
    }

    public final void clear() {
        for (Node point : this.list) {
            point.unassign();
        }
        this.list.clear();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Node trimFrom(Node source) {
        if (source.orphaned()) {
            return source;
        }
        Node root0 = source.root();
        Coords root0Key = root0.key;
        Coords sourceKey = source.key;
        int ddX = sourceKey.x - root0Key.x;
        int ddY = sourceKey.y - root0Key.y;
        int ddZ = sourceKey.z - root0Key.z;
        ArrayList<Node> list = this.list;
        byte length0 = source.length();
        Stack<Node> path = new Stack<Node>();
        TreeTransitional treeTransitional = new TreeTransitional(source);
        ListIterator i = list.listIterator();
        while (i.hasNext()) {
            Node head;
            Node point = head = (Node)i.next();
            while (!point.orphaned()) {
                point = point.up();
                path.push(point);
            }
            if (point == source) {
                int length;
                while (!path.isEmpty()) {
                    point = (Node)path.pop();
                    length = point.length() - length0;
                    point.length(length);
                }
                length = head.length() - length0;
                head.length(length);
                head.index(i.previousIndex());
                continue;
            }
            Node root = path.isEmpty() ? head : (Node)path.pop();
            if (head == point || SortedPointQueue.dotProductBetween(ddX, ddY, ddZ, head, point) <= 0) {
                head.dirty(true);
                while (!path.isEmpty()) {
                    ((Node)path.pop()).dirty(true);
                }
                treeTransitional.queue(head, root);
                head.index(i.previousIndex());
                continue;
            }
            if (!path.isEmpty()) {
                Node branch = (Node)path.pop();
                branch.dirty(true);
                treeTransitional.queue(branch, root);
            }
            i.remove();
            path.clear();
            head.unassign();
            head.visited(false);
        }
        treeTransitional.finish(this);
        return root0;
    }

    private static int dotProductBetween(int ddX, int ddY, int ddZ, Node head, Node target) {
        Coords headKey = head.key;
        Coords pointKey = target.key;
        int dx = headKey.x - pointKey.x;
        int dy = headKey.y - pointKey.y;
        int dz = headKey.z - pointKey.z;
        return dx * ddX + dy * ddY + dz * ddZ;
    }

    void cullBranch(Node ancestor) {
        ArrayList<Node> list = this.list;
        Stack<Node> stack = new Stack<Node>();
        ListIterator i = list.listIterator();
        LinkedList<Node> culled = new LinkedList<Node>();
        while (i.hasNext()) {
            Node head;
            Node point;
            for (point = head = (Node)i.next(); !point.orphaned() && point != ancestor; point = point.up()) {
                stack.push(point);
            }
            if (point != ancestor) {
                head.index(i.previousIndex());
            } else {
                i.remove();
                head.unassign();
                culled.add(head);
                culled.addAll(stack);
            }
            stack.clear();
        }
        for (Node node : culled) {
            node.reset();
            node.visited(false);
        }
    }

    public List<Node> view() {
        return Collections.unmodifiableList(this.list);
    }

    public Node top() {
        return this.list.get(0);
    }

    public Node dequeue() {
        Node point;
        ArrayList<Node> list = this.list;
        if (list.size() == 1) {
            point = list.remove(0);
        } else {
            point = list.set(0, list.remove(list.size() - 1));
            this.sortForward(0);
        }
        point.unassign();
        return point;
    }

    public boolean nextContains(Node ancestor) {
        return this.list.get(0).contains(ancestor);
    }

    private void sortBack(int index) {
        ArrayList<Node> list = this.list;
        Node originalPoint = list.get(index);
        byte distanceRemaining = originalPoint.journey();
        Passibility originalPassibility = originalPoint.passibility();
        while (index > 0) {
            int i = index - 1 >> 1;
            Node point = list.get(i);
            Passibility passibility = point.passibility();
            if (distanceRemaining >= point.journey() && originalPassibility == passibility || originalPassibility.worseThan(passibility)) break;
            list.set(index, point);
            point.index(index);
            index = i;
        }
        list.set(index, originalPoint);
        originalPoint.index(index);
    }

    private void sortForward(int index) {
        ArrayList<Node> list = this.list;
        Node originalPoint = list.get(index);
        byte distanceRemaining = originalPoint.journey();
        Passibility originalPassibility = originalPoint.passibility();
        while (true) {
            Passibility passibilityBeta;
            byte by;
            Node pointBeta;
            int i = 1 + (index << 1);
            int j = i + 1;
            if (i >= list.size()) break;
            Node pointAlpha = list.get(i);
            byte distAlpha = pointAlpha.journey();
            Passibility passibilityAlpha = pointAlpha.passibility();
            if (j >= list.size()) {
                pointBeta = null;
                by = Integer.MIN_VALUE;
                passibilityBeta = Passibility.passible;
            } else {
                pointBeta = list.get(j);
                by = pointBeta.journey();
                passibilityBeta = pointBeta.passibility();
            }
            if (distAlpha < by && passibilityAlpha == passibilityBeta || passibilityAlpha.betterThan(passibilityBeta)) {
                if (distAlpha >= distanceRemaining && passibilityAlpha == originalPassibility || passibilityAlpha.worseThan(originalPassibility)) break;
                list.set(index, pointAlpha);
                pointAlpha.index(index);
                index = i;
                continue;
            }
            if (pointBeta == null || by >= distanceRemaining && passibilityAlpha == originalPassibility || passibilityBeta.worseThan(originalPassibility)) break;
            list.set(index, pointBeta);
            pointBeta.index(index);
            index = j;
        }
        list.set(index, originalPoint);
        originalPoint.index(index);
    }

    public boolean appendTo(Node point, Node parent, Coords targetPoint) {
        return this.appendTo(point, parent, (int)Math.sqrt(Node.squareDelta(point, targetPoint)));
    }

    public boolean appendTo(Node point, Node parent, int remaining) {
        int squareDelta = Node.squareDelta(parent, point);
        byte length = point.length();
        if (!point.assigned() || parent.length() + squareDelta < length * length && !point.passibility().betterThan(parent.passibility())) {
            byte distance0 = point.journey();
            if (point.appendTo(parent, (int)Math.sqrt(squareDelta), remaining)) {
                return this.resort(point, distance0);
            }
            point.orphan();
        }
        return false;
    }

    public boolean addLength(Node point, int diff) {
        byte journey0 = point.journey();
        point.addLength(diff);
        return this.resort(point, journey0);
    }

    private boolean resort(Node point, byte journey0) {
        byte journey = point.journey();
        if (point.assigned()) {
            if (journey < journey0) {
                this.sortBack(point.index());
            } else {
                this.sortForward(point.index());
            }
            return true;
        }
        this.add(point);
        return false;
    }

    public void add(Node point) {
        if (point.assigned()) {
            throw new IllegalStateException("Point is already assigned");
        }
        if (this.fastAdd(point)) {
            return;
        }
        ArrayList<Node> list = this.list;
        int size = this.size();
        ListIterator<Node> i = list.listIterator(size);
        for (int amount = (int)Math.ceil((float)size * 0.1f); amount > 0 && i.hasPrevious(); --amount) {
            i.previous().unassign();
            i.remove();
        }
        this.fastAdd(point);
    }

    public int size() {
        return this.list.size();
    }

    public final Set<Node> roots() {
        HashSet<Node> roots = new HashSet<Node>(1);
        for (Node node : this.list) {
            Node root = node.root();
            if (roots.contains(root)) continue;
            roots.add(root);
        }
        return roots;
    }

    public String toString() {
        return this.list.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedPointQueue that = (SortedPointQueue)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void readLinkages(SortedPointQueue object, ReferableObjectInput<Node> in) throws IOException {
        ArrayList<Node> list = object.list;
        int count = in.readInt();
        while (count-- > 0) {
            list.add(in.readRef());
        }
    }

    @Override
    public void writeLinkages(SortedPointQueue object, ReferableObjectOutput<Node> out) throws IOException {
        ArrayList<Node> list = object.list;
        out.writeInt(list.size());
        for (Node node : list) {
            out.writeRef(node);
        }
    }
}

