/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg;

import com.extollit.linalg.immutable.Vec3i;
import com.extollit.linalg.mutable.Vec3d;
import java.util.Iterator;

public class DiscreteRayStepper
implements Iterator<Result> {
    public final com.extollit.linalg.immutable.Vec3d origin;
    public final com.extollit.linalg.immutable.Vec3d direction;
    private final Vec3i target;
    private final Vec3i delta;
    private final com.extollit.linalg.immutable.Vec3d incrementor;
    private final com.extollit.linalg.mutable.Vec3i cell;
    private final Vec3d walker;
    private final Vec3d dist = new Vec3d(0.0, 0.0, 0.0);
    private byte mx;
    private byte my;
    private byte mz;
    private double ldist;
    private double off;

    public DiscreteRayStepper(com.extollit.linalg.immutable.Vec3d origin, com.extollit.linalg.immutable.Vec3d target) {
        this(origin, target.subOf(origin).normalized(), target);
    }

    public DiscreteRayStepper(com.extollit.linalg.immutable.Vec3d origin, com.extollit.linalg.immutable.Vec3d direction, com.extollit.linalg.immutable.Vec3d target) {
        this.origin = origin;
        this.cell = new com.extollit.linalg.mutable.Vec3i((int)Math.floor(origin.x), (int)Math.floor(origin.y), (int)Math.floor(origin.z));
        this.target = new Vec3i((int)Math.floor(target.x), (int)Math.floor(target.y), (int)Math.floor(target.z));
        this.direction = direction;
        this.incrementor = new com.extollit.linalg.immutable.Vec3d(Math.abs(direction.x), Math.abs(direction.y), Math.abs(direction.z));
        this.delta = new Vec3i(direction.x < 0.0 ? -1 : 1, direction.y < 0.0 ? -1 : 1, direction.z < 0.0 ? -1 : 1);
        this.mx = (byte)((this.delta.x + 1 >> 1) - 1);
        this.my = (byte)((this.delta.y + 1 >> 1) - 1);
        this.mz = (byte)((this.delta.z + 1 >> 1) - 1);
        this.walker = new Vec3d(origin);
        this.walker.x -= Math.floor(origin.x);
        this.walker.y -= Math.floor(origin.y);
        this.walker.z -= Math.floor(origin.z);
        if (this.delta.x < 0) {
            this.walker.x = -this.walker.x + 1.0;
        }
        if (this.delta.y < 0) {
            this.walker.y = -this.walker.y + 1.0;
        }
        if (this.delta.z < 0) {
            this.walker.z = -this.walker.z + 1.0;
        }
    }

    @Override
    public Result next() {
        Vec3d dist = this.dist;
        Vec3d walker = this.walker;
        com.extollit.linalg.immutable.Vec3d incrementor = this.incrementor;
        com.extollit.linalg.mutable.Vec3i cell = this.cell;
        Vec3i delta = this.delta;
        dist.x = 1.0;
        dist.y = 1.0;
        dist.z = 1.0;
        dist.sub(walker);
        dist.x /= incrementor.x;
        dist.y /= incrementor.y;
        dist.z /= incrementor.z;
        while (walker.x < 1.0 && walker.y < 1.0 && walker.z < 1.0) {
            this.ldist += 1.0;
            walker.add(incrementor);
        }
        if (walker.x >= 1.0 && dist.x <= dist.y && dist.x <= dist.z) {
            cell.x += delta.x;
            walker.x -= 1.0;
            this.off = walker.x / incrementor.x;
        } else if (walker.y >= 1.0 && dist.y <= dist.x && dist.y <= dist.z) {
            cell.y += delta.y;
            walker.y -= 1.0;
            this.off = walker.y / incrementor.y;
        } else {
            cell.z += delta.z;
            walker.z -= 1.0;
            this.off = walker.z / incrementor.z;
        }
        return new Result(new Vec3i(cell), this.ldist);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        com.extollit.linalg.immutable.Vec3d direction = this.direction;
        com.extollit.linalg.mutable.Vec3i cell = this.cell;
        Vec3i target = this.target;
        Vec3i delta = this.delta;
        return (direction.x != 0.0 || direction.y != 0.0 || direction.z != 0.0) && (cell.x - target.x) * delta.x <= 0 && (cell.y - target.y) * delta.y <= 0 && (cell.z - target.z) * delta.z <= 0;
    }

    public final class Result {
        public final Vec3i cell;
        private double ldist;

        protected Result(Vec3i cell, double ldist) {
            this.cell = cell;
            this.ldist = ldist;
        }

        public com.extollit.linalg.immutable.Vec3d offset() {
            com.extollit.linalg.immutable.Vec3d d = DiscreteRayStepper.this.direction;
            Vec3d p = new Vec3d(d);
            p.mul(this.ldist);
            double atx = this.partialRatio(p.x, d.x);
            double aty = this.partialRatio(p.y, d.y);
            double atz = this.partialRatio(p.z, d.z);
            double t = atx < aty ? (atz < atx ? atz : atx) : (aty < atz ? aty : atz);
            p.sub(d.x * t, d.y * t, d.z * t);
            return new com.extollit.linalg.immutable.Vec3d(p);
        }

        protected double partialRatio(double c, double t) {
            return Math.abs(t == 0.0 ? 2.0 : (c - (double)((int)c)) / t);
        }
    }
}

