/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.mutable;

import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.mutable.Vec3d;
import com.extollit.linalg.mutable.Vec3i;
import java.text.MessageFormat;

public final class Vec2d
implements ISpatialRegion {
    public double x;
    public double y;

    public Vec2d(Vec2d copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Vec2d(com.extollit.linalg.immutable.Vec2d copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2d vec3d = (Vec2d)o;
        if (Double.compare(vec3d.x, this.x) != 0) {
            return false;
        }
        return Double.compare(vec3d.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return MessageFormat.format("<{0},{1}>", this.x, this.y);
    }

    public final void sub(Vec2d other) {
        this.sub(other.x, other.y);
    }

    public final void sub(double x, double y) {
        this.x -= x;
        this.y -= y;
    }

    public final void add(Vec2d other) {
        this.add(other.x, other.y);
    }

    public final void add(com.extollit.linalg.immutable.Vec2d other) {
        this.add(other.x, other.y);
    }

    public final void add(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final double dot(Vec2d other) {
        return this.x * other.x + this.y * other.y;
    }

    public final void mul(double x, double y) {
        this.x *= x;
        this.y *= y;
    }

    public final void mul(Vec3i other) {
        this.x *= (double)other.x;
        this.y *= (double)other.y;
    }

    public final void mul(double f) {
        this.x *= f;
        this.y *= f;
    }

    public final double mg2() {
        return this.x * this.x + this.y * this.y;
    }

    public final double magnitude() {
        return Math.sqrt(this.mg2());
    }

    public final void proj(Vec2d other) {
        this.mul(this.dot(other) / this.mg2());
    }

    public final Vec2d projcp(Vec2d other) {
        double f = this.dot(other) / this.mg2();
        return new Vec2d(this.x * f, this.y * f);
    }

    public final void sq() {
        this.x *= this.x;
        this.y *= this.y;
    }

    public final void normalize() {
        double length = this.magnitude();
        this.x /= length;
        this.y /= length;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.x == x && this.y == y;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.x == (double)x && this.y == (double)y;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public final void accept(ISpatialRegion.Visitor visitor) {
        visitor.visit(this);
    }
}

