/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.num;

import java.text.MessageFormat;

public class PrecisionType {
    public static final PrecisionType INTEGER = new PrecisionType(0);
    public final double epsilon;
    public final double epsq;
    private final String fmt;

    public PrecisionType(int precision) {
        this.epsilon = this.epsq = Math.pow(10.0, -precision);
        StringBuilder sbfmt = new StringBuilder("{0,number,#.");
        while (precision-- > 0) {
            sbfmt.append('#');
        }
        sbfmt.append('}');
        this.fmt = sbfmt.toString();
    }

    public double round(double value) {
        return (double)Math.round(value / this.epsilon) * this.epsilon;
    }

    public double roundOff(int places, double value) {
        double offset = Math.pow(10.0, places);
        return this.round(value / offset) * offset;
    }

    public double ceil(double value) {
        return Math.ceil(value / this.epsilon) * this.epsilon;
    }

    public double floor(double value) {
        return Math.floor(value / this.epsilon) * this.epsilon;
    }

    public boolean equal(double left, double right) {
        boolean ulp0;
        double absA = Math.abs(left);
        double absB = Math.abs(right);
        double diff = Math.abs(left - right);
        boolean bl = ulp0 = diff <= this.epsilon;
        if (left == right || left == 0.0 || right == 0.0 || ulp0) {
            return ulp0;
        }
        return diff / Math.min(absA + absB, Double.MAX_VALUE) <= this.epsilon;
    }

    public boolean nonZero(double value) {
        return value * value > this.epsq;
    }

    public String toString(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return "+\u221e";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-\u221e";
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        return MessageFormat.format(this.fmt, value);
    }
}

