/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tuple;

import com.extollit.tuple.Pair;
import com.extollit.tuple.PairContract;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class SymmetricPair<T>
extends Pair<T, T>
implements PairContract<T> {
    public SymmetricPair(T lesser, T greater) {
        super(lesser, greater);
    }

    public static <T> SymmetricPair<T> combination(T one, T two) {
        if (one == two || one.hashCode() < two.hashCode()) {
            return new SymmetricPair<T>(one, two);
        }
        return new SymmetricPair<T>(two, one);
    }

    public static <T> SymmetricPair<T> ordered(T first, T second) {
        return new SymmetricPair<T>(first, second);
    }

    public Sealed<T> sealed() {
        return new Sealed(this.left, this.right);
    }

    private static <T> T noneOf(T left, T right, T test) {
        if (test.equals(left)) {
            return right;
        }
        if (test.equals(right)) {
            return left;
        }
        return null;
    }

    private static <T> T allOf(T left, T right, T test) {
        if (test.equals(left)) {
            return left;
        }
        if (test.equals(right)) {
            return right;
        }
        return null;
    }

    @Override
    public T noneOf(T test) {
        return (T)SymmetricPair.noneOf(this.left, this.right, test);
    }

    @Override
    public T allOf(T test) {
        return (T)SymmetricPair.allOf(this.left, this.right, test);
    }

    @Override
    public Set<T> toSet() {
        return new SetView<Object>(this.left, this.right);
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorView<Object>(this.left, this.right);
    }

    @Override
    public boolean contains(T test) {
        return test.equals(this.left) || test.equals(this.right);
    }

    protected static final class IteratorView<T>
    implements Iterator<T> {
        private final T left;
        private final T right;
        private T current;

        public IteratorView(T left, T right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.right;
        }

        @Override
        public T next() {
            if (this.current == null) {
                this.current = this.left;
            } else if (this.current == this.left) {
                this.current = this.right;
            } else {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SetView<T>
    extends AbstractCollection<T>
    implements Set<T> {
        private final T left;
        private final T right;

        public SetView(T left, T right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object o) {
            return this.left == o || this.right == o || o != null && (o.equals(this.left) || o.equals(this.right));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Set) {
                Set otherSet = (Set)obj;
                return otherSet.size() == 2 && otherSet.contains(this.left) && otherSet.contains(this.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorView<T>(this.left, this.right);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.left, this.right};
        }
    }

    public static class Sealed<T>
    extends Pair.Sealed<T, T>
    implements PairContract<T> {
        public Sealed(T lesser, T greater) {
            super(lesser, greater);
        }

        public static <T> Sealed<T> combination(T one, T two) {
            if (one == two || one.hashCode() < two.hashCode()) {
                return new Sealed<T>(one, two);
            }
            return new Sealed<T>(two, one);
        }

        public static <T> Sealed<T> ordered(T first, T second) {
            return new Sealed<T>(first, second);
        }

        @Override
        public T noneOf(T test) {
            return (T)SymmetricPair.noneOf(this.left, this.right, test);
        }

        @Override
        public T allOf(T test) {
            return (T)SymmetricPair.allOf(this.left, this.right, test);
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorView<Object>(this.left, this.right);
        }

        @Override
        public Set<T> toSet() {
            return new SetView<Object>(this.left, this.right);
        }

        @Override
        public boolean contains(T test) {
            return test.equals(this.left) || test.equals(this.right);
        }
    }
}

