/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.content;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.engine.paper.content.ContentComponent;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.roadnetwork.RoadNetworkEntryKt;
import com.typewritermc.roadnetwork.RoadNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/roadnetwork/content/NegativeNodePulseComponent;", "Lcom/typewritermc/engine/paper/content/ContentComponent;", "negativeNodes", "Lkotlin/Function0;", "", "Lcom/typewritermc/roadnetwork/RoadNode;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "cycle", "", "showingNodes", "Lcom/typewritermc/roadnetwork/content/NegativeNodePulseComponent$Pulse;", "initialize", "", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tick", "easeOutBack", "", "dispose", "Companion", "Pulse", "RoadNetworkExtension"})
@SourceDebugExtension(value={"SMAP\nRoadNetworkContentMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/roadnetwork/content/NegativeNodePulseComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,382:1\n774#2:383\n865#2,2:384\n1563#2:386\n1634#2,3:387\n1869#2,2:390\n*S KotlinDebug\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/roadnetwork/content/NegativeNodePulseComponent\n*L\n351#1:383\n351#1:384,2\n355#1:386\n355#1:387,3\n359#1:390,2\n*E\n"})
public final class NegativeNodePulseComponent
implements ContentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<List<RoadNode>> negativeNodes;
    private int cycle;
    @NotNull
    private List<Pulse> showingNodes;
    private static final int PULSE_DURATION = 30;

    public NegativeNodePulseComponent(@NotNull Function0<? extends List<RoadNode>> negativeNodes) {
        Intrinsics.checkNotNullParameter(negativeNodes, (String)"negativeNodes");
        this.negativeNodes = negativeNodes;
        this.showingNodes = CollectionsKt.emptyList();
    }

    @Nullable
    public Object initialize(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object tick(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        if (this.cycle == 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            RoadNode it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = (Iterable)this.negativeNodes.invoke();
            NegativeNodePulseComponent negativeNodePulseComponent = this;
            boolean $i$f$filter = false;
            void var5_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RoadNode)element$iv$iv;
                boolean bl = false;
                Double d = PositionKt.distanceSqrt((Point)((Point)it.getPosition()), (Point)((Point)PointKt.getPosition((Player)player)));
                boolean bl2 = (d != null ? d : Double.MAX_VALUE) < RoadNetworkEntryKt.getRoadNetworkMaxDistance() * RoadNetworkEntryKt.getRoadNetworkMaxDistance();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (RoadNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pulse(it.getPosition(), it.getRadius()));
            }
            negativeNodePulseComponent.showingNodes = (List)destination$iv$iv;
        }
        double percentage = this.easeOutBack((double)this.cycle / (double)30);
        Iterable $this$forEach$iv = this.showingNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pulse pulse = (Pulse)element$iv;
            boolean bl = false;
            double radius = percentage * (pulse.getRadius() - 0.2);
            Point point = (Point)pulse.getPosition();
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
            PointKt.particleSphere((Point)point, (Player)player, (double)radius, (Color)color, (int)8, (int)5);
        }
        int n = this.cycle;
        this.cycle = n + 1;
        if (this.cycle > 30) {
            this.cycle = 0;
        }
        return Unit.INSTANCE;
    }

    private final double easeOutBack(double $this$easeOutBack) {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return 1.0 + c3 * Math.pow($this$easeOutBack - 1.0, 3.0) + c1 * Math.pow($this$easeOutBack - 1.0, 2.0);
    }

    @Nullable
    public Object dispose(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/typewritermc/roadnetwork/content/NegativeNodePulseComponent$Companion;", "", "<init>", "()V", "PULSE_DURATION", "", "RoadNetworkExtension"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/roadnetwork/content/NegativeNodePulseComponent$Pulse;", "", "position", "Lcom/typewritermc/core/utils/point/Position;", "radius", "", "<init>", "(Lcom/typewritermc/core/utils/point/Position;D)V", "getPosition", "()Lcom/typewritermc/core/utils/point/Position;", "getRadius", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "RoadNetworkExtension"})
    public static final class Pulse {
        @NotNull
        private final Position position;
        private final double radius;

        public Pulse(@NotNull Position position, double radius) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.position = position;
            this.radius = radius;
        }

        @NotNull
        public final Position getPosition() {
            return this.position;
        }

        public final double getRadius() {
            return this.radius;
        }

        @NotNull
        public final Position component1() {
            return this.position;
        }

        public final double component2() {
            return this.radius;
        }

        @NotNull
        public final Pulse copy(@NotNull Position position, double radius) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new Pulse(position, radius);
        }

        public static /* synthetic */ Pulse copy$default(Pulse pulse, Position position, double d, int n, Object object) {
            if ((n & 1) != 0) {
                position = pulse.position;
            }
            if ((n & 2) != 0) {
                d = pulse.radius;
            }
            return pulse.copy(position, d);
        }

        @NotNull
        public String toString() {
            return "Pulse(position=" + this.position + ", radius=" + this.radius + ")";
        }

        public int hashCode() {
            int result = this.position.hashCode();
            result = result * 31 + Double.hashCode(this.radius);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pulse)) {
                return false;
            }
            Pulse pulse = (Pulse)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)pulse.position)) {
                return false;
            }
            return Double.compare(this.radius, pulse.radius) == 0;
        }
    }
}

