/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J#\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/typewritermc/core/serialization/GsonContextImpl;", "Lcom/google/gson/JsonSerializationContext;", "Lcom/google/gson/JsonDeserializationContext;", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lcom/google/gson/Gson;)V", "serialize", "Lcom/google/gson/JsonElement;", "src", "", "typeOfSrc", "Ljava/lang/reflect/Type;", "deserialize", "R", "json", "typeOfT", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "engine-core"})
final class GsonContextImpl
implements JsonSerializationContext,
JsonDeserializationContext {
    @NotNull
    private final Gson gson;

    public GsonContextImpl(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.gson = gson;
    }

    @NotNull
    public JsonElement serialize(@NotNull Object src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        JsonElement jsonElement = this.gson.toJsonTree(src);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"toJsonTree(...)");
        return jsonElement;
    }

    @NotNull
    public JsonElement serialize(@NotNull Object src, @NotNull Type typeOfSrc) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        JsonElement jsonElement = this.gson.toJsonTree(src, typeOfSrc);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"toJsonTree(...)");
        return jsonElement;
    }

    public <R> R deserialize(@NotNull JsonElement json, @NotNull Type typeOfT) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        return (R)this.gson.fromJson(json, typeOfT);
    }
}

