/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.typewritermc.core.serialization.DataSerializer;
import com.typewritermc.core.serialization.GsonContextImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u00028\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/core/serialization/TypeAdapterDataSerializer;", "T", "", "Lcom/google/gson/TypeAdapter;", "serializer", "Lcom/typewritermc/core/serialization/DataSerializer;", "gson", "Lcom/google/gson/Gson;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "<init>", "(Lcom/typewritermc/core/serialization/DataSerializer;Lcom/google/gson/Gson;Lcom/google/gson/reflect/TypeToken;)V", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;", "engine-core"})
final class TypeAdapterDataSerializer<T>
extends TypeAdapter<T> {
    @NotNull
    private final DataSerializer<T> serializer;
    @NotNull
    private final Gson gson;
    @NotNull
    private final TypeToken<T> typeToken;

    public TypeAdapterDataSerializer(@NotNull DataSerializer<T> serializer, @NotNull Gson gson, @NotNull TypeToken<T> typeToken) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Intrinsics.checkNotNullParameter(typeToken, (String)"typeToken");
        this.serializer = serializer;
        this.gson = gson;
        this.typeToken = typeToken;
    }

    public void write(@NotNull JsonWriter out, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        JsonElement tree = this.serializer.serialize(value, this.typeToken.getType(), new GsonContextImpl(this.gson));
        Streams.write((JsonElement)tree, (JsonWriter)out);
    }

    @NotNull
    public T read(@Nullable JsonReader in) {
        JsonElement element = Streams.parse((JsonReader)in);
        Object object = this.serializer.deserialize(element, this.typeToken.getType(), new GsonContextImpl(this.gson));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
        return (T)object;
    }
}

