/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.Coordinate;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.PointKt;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.RotatableKt;
import com.typewritermc.core.utils.point.World;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\u0000\u001a\u0002H\u0001\"\u0018\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0002H\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\u0010\u0005\u001a9\u0010\u0006\u001a\u0002H\u0001\"\u0018\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0002H\u00012\u0006\u0010\u0007\u001a\u0002H\u00012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a)\u0010\u000b\u001a\u00020\f\"\u0018\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0002H\u0001\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"lookAt", "RP", "Lcom/typewritermc/core/utils/point/Point;", "Lcom/typewritermc/core/utils/point/Rotatable;", "point", "(Lcom/typewritermc/core/utils/point/Point;Lcom/typewritermc/core/utils/point/Point;)Lcom/typewritermc/core/utils/point/Point;", "lerp", "to", "amount", "", "(Lcom/typewritermc/core/utils/point/Point;Lcom/typewritermc/core/utils/point/Point;D)Lcom/typewritermc/core/utils/point/Point;", "toCoordinate", "Lcom/typewritermc/core/utils/point/Coordinate;", "(Lcom/typewritermc/core/utils/point/Point;)Lcom/typewritermc/core/utils/point/Coordinate;", "toPosition", "Lcom/typewritermc/core/utils/point/Position;", "world", "Lcom/typewritermc/core/utils/point/World;", "engine-core"})
public final class CoordinateKt {
    @NotNull
    public static final <RP extends Point<RP> & Rotatable<RP>> RP lookAt(@NotNull RP $this$lookAt, @NotNull Point<?> point) {
        Intrinsics.checkNotNullParameter($this$lookAt, (String)"<this>");
        Intrinsics.checkNotNullParameter(point, (String)"point");
        double x = point.getX() - $this$lookAt.getX();
        double y = point.getY() - $this$lookAt.getY();
        double z = point.getZ() - $this$lookAt.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(x, z));
        float pitch = (float)Math.toDegrees(Math.atan2(y, Math.sqrt(PointKt.squared(x) + PointKt.squared(z))));
        return (RP)((Point)((Rotatable<RP>)$this$lookAt).withRotation(yaw, pitch));
    }

    @NotNull
    public static final <RP extends Point<RP> & Rotatable<RP>> RP lerp(@NotNull RP $this$lerp, @NotNull RP to, double amount) {
        Intrinsics.checkNotNullParameter($this$lerp, (String)"<this>");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        double percent = RangesKt.coerceIn((double)amount, (double)0.0, (double)1.0);
        double x = $this$lerp.getX() + (to.getX() - $this$lerp.getX()) * percent;
        double y = $this$lerp.getY() + (to.getY() - $this$lerp.getY()) * percent;
        double z = $this$lerp.getZ() + (to.getZ() - $this$lerp.getZ()) * percent;
        double yaw = (double)((Rotatable<RP>)$this$lerp).getYaw() + (double)(RotatableKt.correctYaw(((Rotatable<RP>)$this$lerp).getYaw(), ((Rotatable<RP>)to).getYaw()) - ((Rotatable<RP>)$this$lerp).getYaw()) * percent;
        double pitch = (double)((Rotatable<RP>)$this$lerp).getPitch() + (double)(((Rotatable<RP>)to).getPitch() - ((Rotatable<RP>)$this$lerp).getPitch()) * percent;
        return (RP)((Point)((Rotatable)$this$lerp.withX(x).withY(y).withZ(z)).withRotation((float)yaw, (float)pitch));
    }

    @NotNull
    public static final <RP extends Point<RP> & Rotatable<RP>> Coordinate toCoordinate(@NotNull RP $this$toCoordinate) {
        Intrinsics.checkNotNullParameter($this$toCoordinate, (String)"<this>");
        return new Coordinate($this$toCoordinate.getX(), $this$toCoordinate.getY(), $this$toCoordinate.getZ(), ((Rotatable<RP>)$this$toCoordinate).getYaw(), ((Rotatable<RP>)$this$toCoordinate).getPitch());
    }

    @NotNull
    public static final Position toPosition(@NotNull Coordinate $this$toPosition, @NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)$this$toPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new Position(world, $this$toPosition.getX(), $this$toPosition.getY(), $this$toPosition.getZ(), $this$toPosition.getYaw(), $this$toPosition.getPitch());
    }
}

