/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.World;
import com.typewritermc.core.utils.point.WorldHolder;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u00014BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010 \u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\"\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0006\u0010#\u001a\u00020\u0000J\u0006\u0010$\u001a\u00020\u0000J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\u000bH\u00c6\u0003J\t\u00100\u001a\u00020\u000bH\u00c6\u0003JE\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u00065"}, d2={"Lcom/typewritermc/core/utils/point/Position;", "Lcom/typewritermc/core/utils/point/Point;", "Lcom/typewritermc/core/utils/point/Rotatable;", "Lcom/typewritermc/core/utils/point/WorldHolder;", "world", "Lcom/typewritermc/core/utils/point/World;", "x", "", "y", "z", "yaw", "", "pitch", "<init>", "(Lcom/typewritermc/core/utils/point/World;DDDFF)V", "getWorld", "()Lcom/typewritermc/core/utils/point/World;", "getX", "()D", "getY", "getZ", "getYaw", "()F", "getPitch", "withX", "withY", "withZ", "withYaw", "withPitch", "withRotation", "withWorld", "add", "sub", "mul", "div", "mid", "center", "equals", "", "other", "", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "toString", "", "Companion", "engine-core"})
public final class Position
implements Point<Position>,
Rotatable<Position>,
WorldHolder<Position> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    @NotNull
    private static final Position ORIGIN = new Position(new World(""), 0.0, 0.0, 0.0, 0.0f, 0.0f);

    public Position(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public /* synthetic */ Position(World world, double d, double d2, double d3, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            f = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f2 = 0.0f;
        }
        this(world, d, d2, d3, f, f2);
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    @NotNull
    public Position withX(double x) {
        return Position.copy$default(this, null, x, 0.0, 0.0, 0.0f, 0.0f, 61, null);
    }

    @Override
    @NotNull
    public Position withY(double y) {
        return Position.copy$default(this, null, 0.0, y, 0.0, 0.0f, 0.0f, 59, null);
    }

    @Override
    @NotNull
    public Position withZ(double z) {
        return Position.copy$default(this, null, 0.0, 0.0, z, 0.0f, 0.0f, 55, null);
    }

    @Override
    @NotNull
    public Position withYaw(float yaw) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, yaw, 0.0f, 47, null);
    }

    @Override
    @NotNull
    public Position withPitch(float pitch) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, 0.0f, pitch, 31, null);
    }

    @Override
    @NotNull
    public Position withRotation(float yaw, float pitch) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, yaw, pitch, 15, null);
    }

    @Override
    @NotNull
    public Position withWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return Position.copy$default(this, world, 0.0, 0.0, 0.0, 0.0f, 0.0f, 62, null);
    }

    @Override
    @NotNull
    public Position add(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() + x, this.getY() + y, this.getZ() + z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position sub(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() - x, this.getY() - y, this.getZ() - z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position mul(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() * x, this.getY() * y, this.getZ() * z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position div(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() / x, this.getY() / y, this.getZ() / z, 0.0f, 0.0f, 49, null);
    }

    @NotNull
    public final Position mid() {
        return (Position)PositionKt.toBlockPosition(this).add(0.5, 0.0, 0.5).rotate(this.getYaw(), this.getPitch());
    }

    @NotNull
    public final Position center() {
        return (Position)PositionKt.toBlockPosition(this).add(0.5, 0.5, 0.5).rotate(this.getYaw(), this.getPitch());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Point) {
            if (!(((Point)other).getX() == this.getX())) {
                return false;
            }
            if (!(((Point)other).getY() == this.getY())) {
                return false;
            }
            if (!(((Point)other).getZ() == this.getZ())) {
                return false;
            }
        }
        if (other instanceof Rotatable) {
            if (!(((Rotatable)other).getYaw() == this.getYaw())) {
                return false;
            }
            if (!(((Rotatable)other).getPitch() == this.getPitch())) {
                return false;
            }
        }
        return !(other instanceof WorldHolder) || Intrinsics.areEqual((Object)((WorldHolder)other).getWorld(), (Object)this.getWorld());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()), this.getWorld()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final World component1() {
        return this.world;
    }

    public final double component2() {
        return this.x;
    }

    public final double component3() {
        return this.y;
    }

    public final double component4() {
        return this.z;
    }

    public final float component5() {
        return this.yaw;
    }

    public final float component6() {
        return this.pitch;
    }

    @NotNull
    public final Position copy(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new Position(world, x, y, z, yaw, pitch);
    }

    public static /* synthetic */ Position copy$default(Position position, World world, double d, double d2, double d3, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            world = position.world;
        }
        if ((n & 2) != 0) {
            d = position.x;
        }
        if ((n & 4) != 0) {
            d2 = position.y;
        }
        if ((n & 8) != 0) {
            d3 = position.z;
        }
        if ((n & 0x10) != 0) {
            f = position.yaw;
        }
        if ((n & 0x20) != 0) {
            f2 = position.pitch;
        }
        return position.copy(world, d, d2, d3, f, f2);
    }

    @NotNull
    public String toString() {
        return "Position(world=" + this.world + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
    }

    @Override
    public int getBlockX() {
        return Point.super.getBlockX();
    }

    @Override
    public int getBlockY() {
        return Point.super.getBlockY();
    }

    @Override
    public int getBlockZ() {
        return Point.super.getBlockZ();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position withX(@NotNull DoubleUnaryOperator operator) {
        return (Position)Point.super.withX(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position withY(@NotNull DoubleUnaryOperator operator) {
        return (Position)Point.super.withY(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position withZ(@NotNull DoubleUnaryOperator operator) {
        return (Position)Point.super.withZ(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position add(@NotNull Point<?> point) {
        return (Position)Point.super.add(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position add(double value) {
        return (Position)Point.super.add(value);
    }

    @Override
    @NotNull
    public Position plus(@NotNull Point<?> point) {
        return (Position)Point.super.plus(point);
    }

    @Override
    @NotNull
    public Position plus(double value) {
        return (Position)Point.super.plus(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position sub(@NotNull Point<?> point) {
        return (Position)Point.super.sub(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position sub(double value) {
        return (Position)Point.super.sub(value);
    }

    @Override
    @NotNull
    public Position minus(@NotNull Point<?> point) {
        return (Position)Point.super.minus(point);
    }

    @Override
    @NotNull
    public Position minus(double value) {
        return (Position)Point.super.minus(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position mul(@NotNull Point<?> point) {
        return (Position)Point.super.mul(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position mul(double value) {
        return (Position)Point.super.mul(value);
    }

    @Override
    @NotNull
    public Position times(@NotNull Point<?> point) {
        return (Position)Point.super.times(point);
    }

    @Override
    @NotNull
    public Position times(double value) {
        return (Position)Point.super.times(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position div(@NotNull Point<?> point) {
        return (Position)Point.super.div(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Position div(double value) {
        return (Position)Point.super.div(value);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(double x, double y, double z) {
        return Point.super.distanceSquared(x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(@NotNull Point<?> point) {
        return Point.super.distanceSquared(point);
    }

    @Override
    @Contract(pure=true)
    public double distance(double x, double y, double z) {
        return Point.super.distance(x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distance(@NotNull Point<?> point) {
        return Point.super.distance(point);
    }

    @Override
    public boolean samePoint(double x, double y, double z) {
        return Point.super.samePoint(x, y, z);
    }

    @Override
    public boolean samePoint(@NotNull Point<?> point) {
        return Point.super.samePoint(point);
    }

    @Override
    public boolean isZero() {
        return Point.super.isZero();
    }

    @Override
    public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return Point.super.sameBlock(blockX, blockY, blockZ);
    }

    @Override
    public boolean sameBlock(@NotNull Point<?> point) {
        return Point.super.sameBlock(point);
    }

    @Override
    public boolean isInRange(double x, double y, double z, double range) {
        return Point.super.isInRange(x, y, z, range);
    }

    @Override
    @NotNull
    public Position rotateYaw(float angle) {
        return (Position)Rotatable.super.rotateYaw(angle);
    }

    @Override
    @NotNull
    public Position rotatePitch(float angle) {
        return (Position)Rotatable.super.rotatePitch(angle);
    }

    @Override
    @NotNull
    public Position rotate(float yaw, float pitch) {
        return (Position)Rotatable.super.rotate(yaw, pitch);
    }

    @Override
    @NotNull
    public Position resetRotation() {
        return (Position)Rotatable.super.resetRotation();
    }

    @Override
    @NotNull
    public Vector directionVector() {
        return Rotatable.super.directionVector();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/core/utils/point/Position$Companion;", "", "<init>", "()V", "ORIGIN", "Lcom/typewritermc/core/utils/point/Position;", "getORIGIN", "()Lcom/typewritermc/core/utils/point/Position;", "engine-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Position getORIGIN() {
            return ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

