/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.components;

import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.content.components.NodeDisplayBuilder;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.PointKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.display.ItemDisplayMeta;
import me.tofaa.entitylib.meta.other.InteractionMeta;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/engine/paper/content/components/NodeDisplay;", "", "<init>", "()V", "itemDisplay", "Lme/tofaa/entitylib/wrapper/WrapperEntity;", "interaction", "onInteract", "Lkotlin/Function0;", "", "entityId", "", "getEntityId", "()I", "apply", "builder", "Lcom/typewritermc/engine/paper/content/components/NodeDisplayBuilder;", "position", "Lcom/typewritermc/core/utils/point/Position;", "show", "player", "Lorg/bukkit/entity/Player;", "interact", "dispose", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nNodesComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodesComponent.kt\ncom/typewritermc/engine/paper/content/components/NodeDisplay\n+ 2 PlayerPackets.kt\ncom/typewritermc/engine/paper/extensions/packetevents/PlayerPacketsKt\n*L\n1#1,161:1\n48#2,11:162\n48#2,11:173\n*S KotlinDebug\n*F\n+ 1 NodesComponent.kt\ncom/typewritermc/engine/paper/content/components/NodeDisplay\n*L\n117#1:162,11\n124#1:173,11\n*E\n"})
final class NodeDisplay {
    @NotNull
    private final WrapperEntity itemDisplay = new WrapperEntity(EntityTypes.ITEM_DISPLAY);
    @NotNull
    private final WrapperEntity interaction = new WrapperEntity(EntityTypes.INTERACTION);
    @NotNull
    private Function0<Unit> onInteract = NodeDisplay::onInteract$lambda$0;

    public final int getEntityId() {
        return this.interaction.getEntityId();
    }

    public final void apply(@NotNull NodeDisplayBuilder builder, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        WrapperEntity $this$meta_u24default$iv = this.itemDisplay;
        boolean preventNotification$iv = false;
        boolean $i$f$meta = false;
        EntityMeta entityMeta = $this$meta_u24default$iv.getEntityMeta();
        Intrinsics.checkNotNullExpressionValue((Object)entityMeta, (String)"getEntityMeta(...)");
        EntityMeta meta$iv = entityMeta;
        if (meta$iv instanceof ItemDisplayMeta) {
            meta$iv.setNotifyAboutChanges(false);
            ItemDisplayMeta $this$apply_u24lambda_u241 = (ItemDisplayMeta)meta$iv;
            boolean bl = false;
            $this$apply_u24lambda_u241.setItem(PlayerPacketsKt.toPacketItem(builder.getItem()));
            $this$apply_u24lambda_u241.setGlowing(builder.getGlow() != null);
            TextColor textColor = builder.getGlow();
            $this$apply_u24lambda_u241.setGlowColorOverride(textColor != null ? textColor.value() : -1);
            $this$apply_u24lambda_u241.setScale(builder.getScale());
            $this$apply_u24lambda_u241.setPositionRotationInterpolationDuration(30);
            meta$iv.setNotifyAboutChanges(true);
        }
        $this$meta_u24default$iv = this.interaction;
        preventNotification$iv = false;
        $i$f$meta = false;
        EntityMeta entityMeta2 = $this$meta_u24default$iv.getEntityMeta();
        Intrinsics.checkNotNullExpressionValue((Object)entityMeta2, (String)"getEntityMeta(...)");
        meta$iv = entityMeta2;
        if (meta$iv instanceof InteractionMeta) {
            meta$iv.setNotifyAboutChanges(false);
            InteractionMeta $this$apply_u24lambda_u242 = (InteractionMeta)meta$iv;
            boolean bl = false;
            $this$apply_u24lambda_u242.setWidth(Math.max(builder.getScale().x, builder.getScale().z));
            $this$apply_u24lambda_u242.setHeight(builder.getScale().y);
            meta$iv.setNotifyAboutChanges(true);
        }
        this.onInteract = builder.getInteraction();
        if (this.itemDisplay.isSpawned()) {
            this.itemDisplay.teleport(PointKt.toPacketLocation((Point)position));
        }
        if (!(!this.interaction.isSpawned() || this.interaction.getLocation().getX() == position.getX() && this.interaction.getLocation().getY() == position.getY() - (double)(builder.getScale().y / (float)2) && this.interaction.getLocation().getZ() == position.getZ())) {
            this.interaction.teleport(PointKt.toPacketLocation(position.withY(arg_0 -> NodeDisplay.apply$lambda$3(builder, arg_0))));
        }
    }

    public final void show(@NotNull Player player, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.itemDisplay.addViewer(player.getUniqueId());
        this.itemDisplay.spawn(PointKt.toPacketLocation((Point)position));
        this.interaction.addViewer(player.getUniqueId());
        this.interaction.spawn(PointKt.toPacketLocation((Point)position));
    }

    public final void interact() {
        this.onInteract.invoke();
    }

    public final void dispose() {
        this.itemDisplay.despawn();
        this.itemDisplay.remove();
        this.interaction.despawn();
        this.interaction.remove();
    }

    private static final Unit onInteract$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final double apply$lambda$3(NodeDisplayBuilder $builder, double it) {
        return it - (double)($builder.getScale().y / (float)2);
    }
}

