/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.components;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/typewritermc/engine/paper/content/components/ScrollVelocity;", "", "minimum", "", "<init>", "(I)V", "lastUpdate", "Ljava/time/Instant;", "velocity", "acceleration", "direction", "Lcom/typewritermc/engine/paper/content/components/ScrollVelocity$VelocityDirection;", "swapDirection", "", "target", "move", "forward", "backward", "VelocityDirection", "engine-paper"})
final class ScrollVelocity {
    private final int minimum;
    @NotNull
    private Instant lastUpdate;
    private int velocity;
    private int acceleration;
    @NotNull
    private VelocityDirection direction;

    public ScrollVelocity(int minimum) {
        this.minimum = minimum;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastUpdate = instant;
        this.velocity = this.minimum;
        this.direction = VelocityDirection.FORWARD;
    }

    public /* synthetic */ ScrollVelocity(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    private final void swapDirection(VelocityDirection target) {
        if (this.direction == target) {
            return;
        }
        this.direction = target;
        this.velocity /= 2;
        this.acceleration = 0;
    }

    private final void move() {
        Duration duration = Duration.between(this.lastUpdate, Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        Duration duration2 = duration;
        long diff = kotlin.time.Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastUpdate = instant;
        if (kotlin.time.Duration.compareTo-LRDsOJo((long)diff, (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            this.velocity = this.minimum;
            this.acceleration = 0;
        }
        ++this.acceleration;
        this.velocity += this.acceleration / 5 * 5;
    }

    public final int forward() {
        this.swapDirection(VelocityDirection.FORWARD);
        this.move();
        return this.velocity;
    }

    public final int backward() {
        this.swapDirection(VelocityDirection.BACKWARD);
        this.move();
        return this.velocity;
    }

    public ScrollVelocity() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/typewritermc/engine/paper/content/components/ScrollVelocity$VelocityDirection;", "", "<init>", "(Ljava/lang/String;I)V", "FORWARD", "BACKWARD", "engine-paper"})
    private static final class VelocityDirection
    extends Enum<VelocityDirection> {
        public static final /* enum */ VelocityDirection FORWARD = new VelocityDirection();
        public static final /* enum */ VelocityDirection BACKWARD = new VelocityDirection();
        private static final /* synthetic */ VelocityDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VelocityDirection[] values() {
            return (VelocityDirection[])$VALUES.clone();
        }

        public static VelocityDirection valueOf(String value) {
            return Enum.valueOf(VelocityDirection.class, value);
        }

        @NotNull
        public static EnumEntries<VelocityDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = velocityDirectionArray = new VelocityDirection[]{VelocityDirection.FORWARD, VelocityDirection.BACKWARD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

