/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.modes;

import com.google.gson.Gson;
import com.typewritermc.engine.paper.content.modes.Frame;
import com.typewritermc.engine.paper.content.modes.Streamer;
import com.typewritermc.engine.paper.content.modes.TapeKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0015*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\u0015B\u001d\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006J\u001c\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0013j\b\u0012\u0004\u0012\u00028\u0000`\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/engine/paper/content/modes/Recorder;", "F", "Lcom/typewritermc/engine/paper/content/modes/Frame;", "", "tape", "", "", "<init>", "(Ljava/util/Map;)V", "record", "", "frame", "value", "(ILcom/typewritermc/engine/paper/content/modes/Frame;)V", "get", "(I)Lcom/typewritermc/engine/paper/content/modes/Frame;", "resetFramesAfter", "startFrame", "buildAndOptimize", "", "Lcom/typewritermc/engine/paper/content/modes/Tape;", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nTape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tape.kt\ncom/typewritermc/engine/paper/content/modes/Recorder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n536#2:141\n521#2,6:142\n1#3:148\n*S KotlinDebug\n*F\n+ 1 Tape.kt\ncom/typewritermc/engine/paper/content/modes/Recorder\n*L\n73#1:141\n73#1:142,6\n*E\n"})
public final class Recorder<F extends Frame<F>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, F> tape;

    public Recorder(@NotNull Map<Integer, F> tape) {
        Intrinsics.checkNotNullParameter(tape, (String)"tape");
        this.tape = tape;
    }

    public /* synthetic */ Recorder(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        this(map2);
    }

    public final void record(int frame, @NotNull F value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.tape.put(frame, value);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final F get(int frame) {
        Object v0;
        void $this$filterTo$iv$iv;
        Map<Integer, F> $this$filter$iv = this.tape;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            if (!(((Number)it.getKey()).intValue() <= frame)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv.entrySet();
        iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object e = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = e;
            } else {
                Map.Entry it = (Map.Entry)e;
                boolean bl = false;
                int n = ((Number)it.getKey()).intValue();
                do {
                    Object e2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)e2;
                    $i$a$-maxByOrNull-Recorder$get$2 = false;
                    int n2 = ((Number)it2.getKey()).intValue();
                    if (n >= n2) continue;
                    e = e2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry2 = v0;
        return (F)(entry2 != null ? (Frame)entry2.getValue() : null);
    }

    public final void resetFramesAfter(int startFrame) {
        CollectionsKt.retainAll((Iterable)this.tape.keySet(), arg_0 -> Recorder.resetFramesAfter$lambda$2(startFrame, arg_0));
    }

    @NotNull
    public final Map<Integer, F> buildAndOptimize() {
        List frames = CollectionsKt.sorted((Iterable)this.tape.keySet());
        Map optimized = new LinkedHashMap();
        int n = ((Collection)frames).size();
        for (int i = 0; i < n; ++i) {
            int frame = ((Number)frames.get(i)).intValue();
            F f = this.tape.get(frame);
            Intrinsics.checkNotNull(f);
            Frame currentValue = (Frame)f;
            Integer previous = (Integer)CollectionsKt.getOrNull((List)frames, (int)(i - 1));
            if (previous == null) {
                optimized.put(frame, currentValue);
                continue;
            }
            F f2 = this.tape.get(previous);
            Intrinsics.checkNotNull(f2);
            Frame previousValue = (Frame)f2;
            Frame optimizedValue = currentValue.optimize(previousValue);
            if (optimizedValue.isEmpty()) continue;
            optimized.put(frame, optimizedValue);
        }
        return optimized;
    }

    private static final boolean resetFramesAfter$lambda$2(int $startFrame, int it) {
        return it < $startFrame;
    }

    public Recorder() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u000e\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/engine/paper/content/modes/Recorder$Companion;", "", "<init>", "()V", "create", "Lcom/typewritermc/engine/paper/content/modes/Recorder;", "F", "Lcom/typewritermc/engine/paper/content/modes/Frame;", "gson", "Lcom/google/gson/Gson;", "klass", "Lkotlin/reflect/KClass;", "data", "", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <F extends Frame<F>> Recorder<F> create(@NotNull Gson gson, @NotNull KClass<F> klass, @NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map<Integer, F> map2 = TapeKt.parseTape(gson, klass, data);
            Map flatten = new LinkedHashMap();
            List frames = CollectionsKt.sorted((Iterable)map2.keySet());
            Streamer<F> streamer = new Streamer<F>(map2);
            Iterator iterator2 = frames.iterator();
            while (iterator2.hasNext()) {
                int frame = ((Number)iterator2.next()).intValue();
                flatten.put(frame, streamer.frame(frame));
            }
            return new Recorder(flatten);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

