/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.modes;

import com.typewritermc.engine.paper.content.modes.Frame;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B%\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R$\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/typewritermc/engine/paper/content/modes/Streamer;", "F", "Lcom/typewritermc/engine/paper/content/modes/Frame;", "", "tape", "", "", "Lcom/typewritermc/engine/paper/content/modes/Tape;", "<init>", "(Ljava/util/Map;)V", "keys", "", "currentFrame", "currentValue", "Lcom/typewritermc/engine/paper/content/modes/Frame;", "frame", "(I)Lcom/typewritermc/engine/paper/content/modes/Frame;", "()Lcom/typewritermc/engine/paper/content/modes/Frame;", "get", "resetPlayer", "", "forwardUntil", "engine-paper"})
public final class Streamer<F extends Frame<F>> {
    @NotNull
    private final Map<Integer, F> tape;
    @NotNull
    private final List<Integer> keys;
    private int currentFrame;
    @NotNull
    private F currentValue;

    public Streamer(@NotNull Map<Integer, ? extends F> tape) {
        boolean bl;
        Intrinsics.checkNotNullParameter(tape, (String)"tape");
        this.tape = tape;
        this.keys = CollectionsKt.sorted((Iterable)this.tape.keySet());
        this.currentFrame = ((Number)CollectionsKt.first(this.keys)).intValue();
        F f = this.tape.get(this.currentFrame);
        Intrinsics.checkNotNull(f);
        this.currentValue = (Frame)f;
        boolean bl2 = bl = !this.tape.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final F frame(int frame) {
        if (frame < this.currentFrame) {
            this.resetPlayer();
        }
        this.forwardUntil(frame);
        return this.currentValue;
    }

    @NotNull
    public final F currentFrame() {
        return this.currentValue;
    }

    @NotNull
    public final F get(int frame) {
        return this.frame(frame);
    }

    private final void resetPlayer() {
        this.currentFrame = ((Number)CollectionsKt.first(this.keys)).intValue();
        F f = this.tape.get(this.currentFrame);
        Intrinsics.checkNotNull(f);
        this.currentValue = (Frame)f;
    }

    private final void forwardUntil(int frame) {
        while (this.currentFrame < frame) {
            int n = this.currentFrame;
            this.currentFrame = n + 1;
            Frame nextFrame = (Frame)this.tape.get(this.currentFrame);
            this.currentValue = nextFrame == null ? this.currentValue.clean() : this.currentValue.merge((Frame)nextFrame);
        }
    }
}

