/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.dialogue;

import com.typewritermc.core.interaction.ContextModifier;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.TriggerEntry;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lirand.api.extensions.events.ListenerExtensionsKt;
import lirand.api.extensions.server.PluginExtensionsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u0006\u0010,\u001a\u00020\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010(\u00a8\u0006-"}, d2={"Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "DE", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "Lcom/typewritermc/core/interaction/ContextModifier;", "Lorg/bukkit/event/Listener;", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/interaction/InteractionContext;Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getEntry", "()Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "value", "Lcom/typewritermc/engine/paper/entry/dialogue/MessengerState;", "state", "getState", "()Lcom/typewritermc/engine/paper/entry/dialogue/MessengerState;", "setState", "(Lcom/typewritermc/engine/paper/entry/dialogue/MessengerState;)V", "animationComplete", "", "getAnimationComplete", "()Z", "setAnimationComplete", "(Z)V", "init", "", "tick", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "dispose", "end", "eventTriggers", "", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "getEventTriggers", "()Ljava/util/List;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "getModifiers", "completeOrFinish", "engine-paper"})
public class DialogueMessenger<DE extends DialogueEntry>
extends ContextModifier
implements Listener {
    @NotNull
    private final Player player;
    @NotNull
    private final DE entry;
    @NotNull
    private MessengerState state;
    private boolean animationComplete;

    public DialogueMessenger(@NotNull Player player, @NotNull InteractionContext context, @NotNull DE entry2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        super(context);
        this.player = player;
        this.entry = entry2;
        this.state = MessengerState.RUNNING;
        this.animationComplete = true;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final DE getEntry() {
        return this.entry;
    }

    @NotNull
    public MessengerState getState() {
        return this.state;
    }

    protected void setState(@NotNull MessengerState messengerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)messengerState), (String)"<set-?>");
        this.state = messengerState;
    }

    public boolean getAnimationComplete() {
        return this.animationComplete;
    }

    public void setAnimationComplete(boolean bl) {
        this.animationComplete = bl;
    }

    public void init() {
        Listener[] listenerArray = new Listener[]{this};
        PluginExtensionsKt.registerEvents((Plugin)TypewriterPaperPluginKt.getPlugin(), listenerArray);
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public void dispose() {
        ListenerExtensionsKt.unregister(this);
    }

    public void end() {
        this.setState(MessengerState.FINISHED);
        ChatHistory.resendMessages$default(ChatHistoryHandlerKt.getChatHistory(this.player), this.player, false, 2, null);
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        return ((TriggerEntry)this.entry).getEventTriggers();
    }

    @NotNull
    public List<Modifier> getModifiers() {
        return ((TriggerableEntry)this.entry).getModifiers();
    }

    public final void completeOrFinish() {
        if (this.getAnimationComplete()) {
            this.setState(MessengerState.FINISHED);
        } else {
            this.setAnimationComplete(true);
        }
    }
}

