/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.dialogue;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKeyHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/typewritermc/engine/paper/entry/dialogue/JumpHandler;", "Lcom/typewritermc/engine/paper/entry/dialogue/ConfirmationKeyHandler;", "player", "Lorg/bukkit/entity/Player;", "block", "Lkotlin/Function0;", "", "<init>", "(Lorg/bukkit/entity/Player;Lkotlin/jvm/functions/Function0;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getBlock", "()Lkotlin/jvm/functions/Function0;", "key", "Lorg/bukkit/NamespacedKey;", "initialize", "onJump", "event", "Lcom/destroystokyo/paper/event/player/PlayerJumpEvent;", "dispose", "engine-paper"})
public final class JumpHandler
implements ConfirmationKeyHandler {
    @NotNull
    private final Player player;
    @NotNull
    private final Function0<Unit> block;
    @NotNull
    private final NamespacedKey key;

    public JumpHandler(@NotNull Player player, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.player = player;
        this.block = block;
        this.key = new NamespacedKey((Plugin)TypewriterPaperPluginKt.getPlugin(), "jump_confirmation");
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public Function0<Unit> getBlock() {
        return this.block;
    }

    @Override
    public void initialize() {
        block0: {
            ConfirmationKeyHandler.super.initialize();
            AttributeInstance attributeInstance = this.getPlayer().getAttribute(Attribute.JUMP_STRENGTH);
            if (attributeInstance == null) break block0;
            AttributeInstance attribute = attributeInstance;
            boolean bl = false;
            attribute.removeModifier((Key)this.key);
            attribute.addModifier(new AttributeModifier(this.key, -0.999, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onJump(@NotNull PlayerJumpEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        this.getBlock().invoke();
    }

    @Override
    public void dispose() {
        block0: {
            ConfirmationKeyHandler.super.dispose();
            AttributeInstance attributeInstance = this.getPlayer().getAttribute(Attribute.JUMP_STRENGTH);
            if (attributeInstance == null) break block0;
            attributeInstance.removeModifier((Key)this.key);
        }
    }
}

