/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.ActivityManager;
import com.typewritermc.engine.paper.entry.entity.AudienceEntityDisplay;
import com.typewritermc.engine.paper.entry.entity.DisplayEntity;
import com.typewritermc.engine.paper.entry.entity.DisplayEntityKt;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.EntityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SharedAudienceEntityDisplayKt;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.PropertySupplier;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003Bc\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001c\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010.\u001a\u00020)H\u0016J\u0018\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000fH\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\u001dH\u0016J\u0010\u00103\u001a\u00020#2\u0006\u00100\u001a\u00020\u001dH\u0016J/\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u0002062\u0006\u00100\u001a\u00020\u001d2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H508H\u0016\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020%2\u0006\u00100\u001a\u00020\u001dH\u0016J\u0010\u0010;\u001a\u00020%2\u0006\u00100\u001a\u00020\u001dH\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u001dH\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020!0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020#0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/IndividualAudienceEntityDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "Lcom/typewritermc/engine/paper/entry/entity/AudienceEntityDisplay;", "instanceEntryRef", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityInstanceEntry;", "creator", "Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityCreator", "Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;", "suppliers", "", "Lkotlin/Pair;", "Lcom/typewritermc/engine/paper/entry/entries/PropertySupplier;", "", "spawnPosition", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "Lcom/typewritermc/core/utils/point/Position;", "showRange", "", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;Ljava/util/List;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "getInstanceEntryRef", "()Lcom/typewritermc/core/entries/Ref;", "getCreator", "()Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;", "Lcom/typewritermc/engine/paper/entry/entity/IndividualActivityContext;", "entities", "Lcom/typewritermc/engine/paper/entry/entity/DisplayEntity;", "lastStates", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "", "onPlayerFilterAdded", "tick", "onPlayerFilterRemoved", "onPlayerRemove", "dispose", "playerSeesEntity", "playerId", "entityId", "position", "entityState", "property", "P", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "type", "Lkotlin/reflect/KClass;", "(Ljava/util/UUID;Lkotlin/reflect/KClass;)Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "canView", "isSpawnedIn", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nIndividualAudienceEntityDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndividualAudienceEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/IndividualAudienceEntityDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,111:1\n1869#2,2:112\n1869#2,2:120\n1869#2,2:122\n1869#2,2:124\n216#3:114\n217#3:119\n1#4:115\n1#4:118\n72#5,2:116\n*S KotlinDebug\n*F\n+ 1 IndividualAudienceEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/IndividualAudienceEntityDisplay\n*L\n57#1:112,2\n66#1:120,2\n82#1:122,2\n84#1:124,2\n59#1:114\n59#1:119\n63#1:118\n63#1:116,2\n*E\n"})
public final class IndividualAudienceEntityDisplay
extends AudienceFilter
implements TickableDisplay,
AudienceEntityDisplay {
    @NotNull
    private final Ref<? extends EntityInstanceEntry> instanceEntryRef;
    @NotNull
    private final EntityCreator creator;
    @NotNull
    private final ActivityCreator activityCreator;
    @NotNull
    private final List<Pair<PropertySupplier<?>, Integer>> suppliers;
    @NotNull
    private final Var<Position> spawnPosition;
    @NotNull
    private final Var<Double> showRange;
    @NotNull
    private final ConcurrentHashMap<UUID, ActivityManager<? super IndividualActivityContext>> activityManagers;
    @NotNull
    private final ConcurrentHashMap<UUID, DisplayEntity> entities;
    @NotNull
    private final ConcurrentHashMap<UUID, EntityState> lastStates;

    public IndividualAudienceEntityDisplay(@NotNull Ref<? extends EntityInstanceEntry> instanceEntryRef, @NotNull EntityCreator creator, @NotNull ActivityCreator activityCreator, @NotNull List<? extends Pair<? extends PropertySupplier<?>, Integer>> suppliers, @NotNull Var<Position> spawnPosition, @NotNull Var<Double> showRange) {
        Intrinsics.checkNotNullParameter(instanceEntryRef, (String)"instanceEntryRef");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)activityCreator, (String)"activityCreator");
        Intrinsics.checkNotNullParameter(suppliers, (String)"suppliers");
        Intrinsics.checkNotNullParameter(spawnPosition, (String)"spawnPosition");
        Intrinsics.checkNotNullParameter(showRange, (String)"showRange");
        super(instanceEntryRef);
        this.instanceEntryRef = instanceEntryRef;
        this.creator = creator;
        this.activityCreator = activityCreator;
        this.suppliers = suppliers;
        this.spawnPosition = spawnPosition;
        this.showRange = showRange;
        this.activityManagers = new ConcurrentHashMap();
        this.entities = new ConcurrentHashMap();
        this.lastStates = new ConcurrentHashMap();
    }

    public /* synthetic */ IndividualAudienceEntityDisplay(Ref ref2, EntityCreator entityCreator, ActivityCreator activityCreator, List list, Var var, Var var2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            var2 = new ConstVar<Double>(SharedAudienceEntityDisplayKt.getEntityShowRange());
        }
        this(ref2, entityCreator, activityCreator, list, var, var2);
    }

    @Override
    @NotNull
    public Ref<? extends EntityInstanceEntry> getInstanceEntryRef() {
        return this.instanceEntryRef;
    }

    @Override
    @NotNull
    public EntityCreator getCreator() {
        return this.creator;
    }

    @Override
    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(player.getUniqueId());
        if (activityManager == null) {
            return false;
        }
        ActivityManager<? super IndividualActivityContext> activityManager2 = activityManager;
        PositionProperty npcPosition = activityManager2.getPosition();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Double d = npcPosition.distanceSqrt(location);
        if (d == null) {
            return false;
        }
        double distance = d;
        double showRange = ((Number)Var.get$default(this.showRange, player, null, 2, null)).doubleValue();
        return distance <= showRange * showRange;
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.activityManagers.computeIfAbsent(player.getUniqueId(), arg_0 -> IndividualAudienceEntityDisplay.onPlayerAdd$lambda$1(arg_0 -> IndividualAudienceEntityDisplay.onPlayerAdd$lambda$0(this, player, arg_0), arg_0));
        super.onPlayerAdd(player);
    }

    @Override
    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerFilterAdded(player);
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(player.getUniqueId());
        if (activityManager == null) {
            return;
        }
        ActivityManager<? super IndividualActivityContext> activityManager2 = activityManager;
        this.entities.computeIfAbsent(player.getUniqueId(), arg_0 -> IndividualAudienceEntityDisplay.onPlayerFilterAdded$lambda$3(arg_0 -> IndividualAudienceEntityDisplay.onPlayerFilterAdded$lambda$2(player, this, activityManager2, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        boolean bl;
        Object it;
        Object $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            it = (Player)t;
            bl = false;
            this.refresh((Player)it);
        }
        $this$forEach$iv = this.activityManagers;
        $i$f$forEach = false;
        for (Map.Entry entry2 : $this$forEach$iv.entrySet()) {
            Player player;
            Object object;
            boolean isViewing;
            ActivityManager manager;
            block9: {
                void $this$getOrPut$iv;
                Object object2;
                UUID pid;
                block8: {
                    it = entry2;
                    bl = false;
                    pid = (UUID)it.getKey();
                    manager = (ActivityManager)it.getValue();
                    if (ServerExtensionsKt.getServer().getPlayer(pid) == null) continue;
                    isViewing = this.contains(pid);
                    object = this.entities.get(pid);
                    if (object == null || (object = ((DisplayEntity)object).getState()) == null) break block8;
                    Object it2 = object2 = object;
                    boolean bl2 = false;
                    ((Map)this.lastStates).put(pid, it2);
                    object = object2;
                    if (object != null) break block9;
                }
                object2 = this.lastStates;
                UUID key$iv = pid;
                boolean $i$f$getOrPut = false;
                Object object3 = $this$getOrPut$iv.get(key$iv);
                if (object3 == null) {
                    boolean bl2 = false;
                    EntityState default$iv = new EntityState(0.0, 0.0f, 3, null);
                    boolean bl3 = false;
                    object3 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object3 == null) {
                        object3 = default$iv;
                    }
                }
                object = (EntityState)object3;
            }
            Object entityState = object;
            Ref<? extends EntityInstanceEntry> ref2 = this.getInstanceEntryRef();
            Intrinsics.checkNotNull((Object)entityState);
            manager.tick((ActivityContext)new IndividualActivityContext(ref2, player, isViewing, (EntityState)entityState));
        }
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            it = (DisplayEntity)object;
            bl = false;
            ((DisplayEntity)it).tick();
        }
    }

    @Override
    public void onPlayerFilterRemoved(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            super.onPlayerFilterRemoved(player);
            DisplayEntity displayEntity = this.entities.remove(player.getUniqueId());
            if (displayEntity == null) break block0;
            displayEntity.dispose();
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.remove(player.getUniqueId());
        if (activityManager != null) {
            activityManager.dispose((IndividualActivityContext)((ActivityContext)new IndividualActivityContext(this.getInstanceEntryRef(), player, false, null, 12, null)));
        }
        this.lastStates.remove(player.getUniqueId());
    }

    @Override
    public void dispose() {
        super.dispose();
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayEntity it = (DisplayEntity)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.entities.clear();
        Set<Map.Entry<UUID, ActivityManager<? super IndividualActivityContext>>> set = this.activityManagers.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            Ref<? extends EntityInstanceEntry> ref2;
            Map.Entry entry2 = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry2);
            Object k = entry2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            UUID playerId = (UUID)k;
            Object v = entry2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            if (ServerExtensionsKt.getServer().getPlayer(playerId) == null) {
                this.getInstanceEntryRef();
                continue;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 12;
            EntityState entityState = null;
            boolean bl2 = false;
            ActivityManager activityManager = (ActivityManager)v;
            activityManager.dispose((ActivityContext)new IndividualActivityContext(ref2, player, bl2, entityState, n, defaultConstructorMarker));
        }
        this.activityManagers.clear();
        this.lastStates.clear();
    }

    @Override
    public boolean playerSeesEntity(@NotNull UUID playerId, int entityId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.contains(entityId) : false;
    }

    @Override
    @Nullable
    public Position position(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(playerId);
        return activityManager != null && (activityManager = activityManager.getPosition()) != null ? ((PositionProperty)((Object)activityManager)).toPosition() : null;
    }

    @Override
    @NotNull
    public EntityState entityState(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Object object = this.entities.get(playerId);
        if ((object == null || (object = ((DisplayEntity)object).getState()) == null) && (object = this.lastStates.get(playerId)) == null) {
            object = new EntityState(0.0, 0.0f, 3, null);
        }
        return object;
    }

    @Override
    @Nullable
    public <P extends EntityProperty> P property(@NotNull UUID playerId, @NotNull KClass<P> type) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return (P)(displayEntity != null ? displayEntity.property(type) : null);
    }

    @Override
    public boolean canView(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.canConsider(playerId);
    }

    @Override
    public boolean isSpawnedIn(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.entities.get(playerId) != null;
    }

    @Override
    public int entityId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.getEntityId() : 0;
    }

    @Override
    @Nullable
    public EntityDefinitionEntry getDefinition() {
        return AudienceEntityDisplay.super.getDefinition();
    }

    private static final ActivityManager onPlayerAdd$lambda$0(IndividualAudienceEntityDisplay this$0, Player $player, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IndividualActivityContext context = new IndividualActivityContext(this$0.getInstanceEntryRef(), $player, false, null, 12, null);
        EntityActivity<ActivityContext> activity = this$0.activityCreator.create(context, PositionPropertyKt.toProperty((Position)Var.get$default(this$0.spawnPosition, $player, null, 2, null)));
        ActivityManager<ActivityContext> activityManager = new ActivityManager<ActivityContext>(activity);
        activityManager.initialize(context);
        return activityManager;
    }

    private static final ActivityManager onPlayerAdd$lambda$1(Function1 $tmp0, Object p0) {
        return (ActivityManager)$tmp0.invoke(p0);
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$2(Player $player, IndividualAudienceEntityDisplay this$0, ActivityManager $activityManager, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DisplayEntity($player, this$0.getCreator(), $activityManager, DisplayEntityKt.toCollectors(this$0.suppliers));
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$3(Function1 $tmp0, Object p0) {
        return (DisplayEntity)$tmp0.invoke(p0);
    }
}

