/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.World;
import com.typewritermc.core.utils.point.WorldHolder;
import com.typewritermc.engine.paper.entry.entity.SinglePropertyCollectorSupplier;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.utils.PointKt;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.bukkit.Location;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 82\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u00018B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010$\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010%\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010&\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010'\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0006\u0010(\u001a\u00020)J\u0013\u0010*\u001a\u00020+2\b\u0010\u001a\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\bH\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\fH\u00c6\u0003J\t\u00104\u001a\u00020\fH\u00c6\u0003JE\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\r\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u00069"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "Lcom/typewritermc/core/utils/point/Point;", "Lcom/typewritermc/core/utils/point/Rotatable;", "Lcom/typewritermc/core/utils/point/WorldHolder;", "world", "Lcom/typewritermc/core/utils/point/World;", "x", "", "y", "z", "yaw", "", "pitch", "<init>", "(Lcom/typewritermc/core/utils/point/World;DDDFF)V", "getWorld", "()Lcom/typewritermc/core/utils/point/World;", "getX", "()D", "getY", "getZ", "getYaw", "()F", "getPitch", "distanceSqrt", "other", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)Ljava/lang/Double;", "withX", "withY", "withZ", "withYaw", "withPitch", "withRotation", "withWorld", "add", "sub", "mul", "div", "toPosition", "Lcom/typewritermc/core/utils/point/Position;", "equals", "", "", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "toString", "", "Companion", "engine-paper"})
public final class PositionProperty
implements EntityProperty,
Point<PositionProperty>,
Rotatable<PositionProperty>,
WorldHolder<PositionProperty> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    @NotNull
    private static final PositionProperty ORIGIN = new PositionProperty(new World(""), 0.0, 0.0, 0.0, 0.0f, 0.0f);

    public PositionProperty(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Nullable
    public final Double distanceSqrt(@NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.getWorld().getIdentifier(), (Object)other.getWorld().getUID().toString())) {
            return null;
        }
        return PositionKt.distanceSqrt((Point)this, (Point)PointKt.toPosition(other));
    }

    @Override
    @NotNull
    public PositionProperty withX(double x) {
        return PositionProperty.copy$default(this, null, x, 0.0, 0.0, 0.0f, 0.0f, 61, null);
    }

    @Override
    @NotNull
    public PositionProperty withY(double y) {
        return PositionProperty.copy$default(this, null, 0.0, y, 0.0, 0.0f, 0.0f, 59, null);
    }

    @Override
    @NotNull
    public PositionProperty withZ(double z) {
        return PositionProperty.copy$default(this, null, 0.0, 0.0, z, 0.0f, 0.0f, 55, null);
    }

    @Override
    @NotNull
    public PositionProperty withYaw(float yaw) {
        return PositionProperty.copy$default(this, null, 0.0, 0.0, 0.0, yaw, 0.0f, 47, null);
    }

    @Override
    @NotNull
    public PositionProperty withPitch(float pitch) {
        return PositionProperty.copy$default(this, null, 0.0, 0.0, 0.0, 0.0f, pitch, 31, null);
    }

    @Override
    @NotNull
    public PositionProperty withRotation(float yaw, float pitch) {
        return PositionProperty.copy$default(this, null, 0.0, 0.0, 0.0, yaw, pitch, 15, null);
    }

    @Override
    @NotNull
    public PositionProperty withWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return PositionProperty.copy$default(this, world, 0.0, 0.0, 0.0, 0.0f, 0.0f, 62, null);
    }

    @Override
    @NotNull
    public PositionProperty add(double x, double y, double z) {
        return PositionProperty.copy$default(this, null, this.getX() + x, this.getY() + y, this.getZ() + z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public PositionProperty sub(double x, double y, double z) {
        return PositionProperty.copy$default(this, null, this.getX() - x, this.getY() - y, this.getZ() - z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public PositionProperty mul(double x, double y, double z) {
        return PositionProperty.copy$default(this, null, this.getX() * x, this.getY() * y, this.getZ() * z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public PositionProperty div(double x, double y, double z) {
        return PositionProperty.copy$default(this, null, this.getX() / x, this.getY() / y, this.getZ() / z, 0.0f, 0.0f, 49, null);
    }

    @NotNull
    public final Position toPosition() {
        return new Position(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Point) {
            if (!(((Point)other).getX() == this.getX())) {
                return false;
            }
            if (!(((Point)other).getY() == this.getY())) {
                return false;
            }
            if (!(((Point)other).getZ() == this.getZ())) {
                return false;
            }
        }
        if (other instanceof Rotatable) {
            if (!(((Rotatable)other).getYaw() == this.getYaw())) {
                return false;
            }
            if (!(((Rotatable)other).getPitch() == this.getPitch())) {
                return false;
            }
        }
        return !(other instanceof WorldHolder) || Intrinsics.areEqual((Object)((WorldHolder)other).getWorld(), (Object)this.getWorld());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()), this.getWorld()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final World component1() {
        return this.world;
    }

    public final double component2() {
        return this.x;
    }

    public final double component3() {
        return this.y;
    }

    public final double component4() {
        return this.z;
    }

    public final float component5() {
        return this.yaw;
    }

    public final float component6() {
        return this.pitch;
    }

    @NotNull
    public final PositionProperty copy(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new PositionProperty(world, x, y, z, yaw, pitch);
    }

    public static /* synthetic */ PositionProperty copy$default(PositionProperty positionProperty, World world, double d, double d2, double d3, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            world = positionProperty.world;
        }
        if ((n & 2) != 0) {
            d = positionProperty.x;
        }
        if ((n & 4) != 0) {
            d2 = positionProperty.y;
        }
        if ((n & 8) != 0) {
            d3 = positionProperty.z;
        }
        if ((n & 0x10) != 0) {
            f = positionProperty.yaw;
        }
        if ((n & 0x20) != 0) {
            f2 = positionProperty.pitch;
        }
        return positionProperty.copy(world, d, d2, d3, f, f2);
    }

    @NotNull
    public String toString() {
        return "PositionProperty(world=" + this.world + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty withX(@NotNull DoubleUnaryOperator operator) {
        return (PositionProperty)Point.super.withX(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty withY(@NotNull DoubleUnaryOperator operator) {
        return (PositionProperty)Point.super.withY(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty withZ(@NotNull DoubleUnaryOperator operator) {
        return (PositionProperty)Point.super.withZ(operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty add(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.add(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty add(double value) {
        return (PositionProperty)Point.super.add(value);
    }

    @Override
    @NotNull
    public PositionProperty plus(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.plus(point);
    }

    @Override
    @NotNull
    public PositionProperty plus(double value) {
        return (PositionProperty)Point.super.plus(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty sub(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.sub(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty sub(double value) {
        return (PositionProperty)Point.super.sub(value);
    }

    @Override
    @NotNull
    public PositionProperty minus(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.minus(point);
    }

    @Override
    @NotNull
    public PositionProperty minus(double value) {
        return (PositionProperty)Point.super.minus(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty mul(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.mul(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty mul(double value) {
        return (PositionProperty)Point.super.mul(value);
    }

    @Override
    @NotNull
    public PositionProperty times(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.times(point);
    }

    @Override
    @NotNull
    public PositionProperty times(double value) {
        return (PositionProperty)Point.super.times(value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty div(@NotNull Point<?> point) {
        return (PositionProperty)Point.super.div(point);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PositionProperty div(double value) {
        return (PositionProperty)Point.super.div(value);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(double x, double y, double z) {
        return Point.super.distanceSquared(x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(@NotNull Point<?> point) {
        return Point.super.distanceSquared(point);
    }

    @Override
    @Contract(pure=true)
    public double distance(double x, double y, double z) {
        return Point.super.distance(x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distance(@NotNull Point<?> point) {
        return Point.super.distance(point);
    }

    @Override
    public boolean samePoint(double x, double y, double z) {
        return Point.super.samePoint(x, y, z);
    }

    @Override
    public boolean samePoint(@NotNull Point<?> point) {
        return Point.super.samePoint(point);
    }

    @Override
    public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return Point.super.sameBlock(blockX, blockY, blockZ);
    }

    @Override
    public boolean sameBlock(@NotNull Point<?> point) {
        return Point.super.sameBlock(point);
    }

    @Override
    public boolean isInRange(double x, double y, double z, double range) {
        return Point.super.isInRange(x, y, z, range);
    }

    @Override
    public int getBlockX() {
        return Point.super.getBlockX();
    }

    @Override
    public int getBlockY() {
        return Point.super.getBlockY();
    }

    @Override
    public int getBlockZ() {
        return Point.super.getBlockZ();
    }

    @Override
    public boolean isZero() {
        return Point.super.isZero();
    }

    @Override
    @NotNull
    public PositionProperty rotateYaw(float angle) {
        return (PositionProperty)Rotatable.super.rotateYaw(angle);
    }

    @Override
    @NotNull
    public PositionProperty rotatePitch(float angle) {
        return (PositionProperty)Rotatable.super.rotatePitch(angle);
    }

    @Override
    @NotNull
    public PositionProperty rotate(float yaw, float pitch) {
        return (PositionProperty)Rotatable.super.rotate(yaw, pitch);
    }

    @Override
    @NotNull
    public PositionProperty resetRotation() {
        return (PositionProperty)Rotatable.super.resetRotation();
    }

    @Override
    @NotNull
    public Vector directionVector() {
        return Rotatable.super.directionVector();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/PositionProperty$Companion;", "Lcom/typewritermc/engine/paper/entry/entity/SinglePropertyCollectorSupplier;", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "()V", "ORIGIN", "getORIGIN", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "engine-paper"})
    public static final class Companion
    extends SinglePropertyCollectorSupplier<PositionProperty> {
        private Companion() {
            super(Reflection.getOrCreateKotlinClass(PositionProperty.class), null, 2, null);
        }

        @NotNull
        public final PositionProperty getORIGIN() {
            return ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

