/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.ActivityManager;
import com.typewritermc.engine.paper.entry.entity.AudienceEntityDisplay;
import com.typewritermc.engine.paper.entry.entity.DisplayEntity;
import com.typewritermc.engine.paper.entry.entity.DisplayEntityKt;
import com.typewritermc.engine.paper.entry.entity.EntityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entity.SharedAudienceEntityDisplayKt;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.PropertySupplier;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B]\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001c\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020)H\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u000fH\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00112\u0006\u0010/\u001a\u00020 H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u0010/\u001a\u00020 H\u0016J/\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u0002052\u0006\u0010/\u001a\u00020 2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407H\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020%2\u0006\u0010/\u001a\u00020 H\u0016J\u0010\u0010:\u001a\u00020%2\u0006\u0010/\u001a\u00020 H\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020 H\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/SharedAudienceEntityDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "Lcom/typewritermc/engine/paper/entry/entity/AudienceEntityDisplay;", "instanceEntryRef", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityInstanceEntry;", "creator", "Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityCreators", "Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;", "suppliers", "", "Lkotlin/Pair;", "Lcom/typewritermc/engine/paper/entry/entries/PropertySupplier;", "", "spawnPosition", "Lcom/typewritermc/core/utils/point/Position;", "showRange", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;Ljava/util/List;Lcom/typewritermc/core/utils/point/Position;Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "getInstanceEntryRef", "()Lcom/typewritermc/core/entries/Ref;", "getCreator", "()Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityManager", "Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;", "Lcom/typewritermc/engine/paper/entry/entity/SharedActivityContext;", "entities", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/entry/entity/DisplayEntity;", "lastState", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "initialize", "", "onPlayerFilterAdded", "tick", "onPlayerFilterRemoved", "dispose", "playerSeesEntity", "playerId", "entityId", "position", "entityState", "property", "P", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "type", "Lkotlin/reflect/KClass;", "(Ljava/util/UUID;Lkotlin/reflect/KClass;)Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "canView", "isSpawnedIn", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSharedAudienceEntityDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedAudienceEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/SharedAudienceEntityDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1869#2,2:97\n1869#2,2:100\n1869#2,2:102\n1#3:99\n*S KotlinDebug\n*F\n+ 1 SharedAudienceEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/SharedAudienceEntityDisplay\n*L\n56#1:97,2\n64#1:100,2\n75#1:102,2\n*E\n"})
public final class SharedAudienceEntityDisplay
extends AudienceFilter
implements TickableDisplay,
AudienceEntityDisplay {
    @NotNull
    private final Ref<? extends EntityInstanceEntry> instanceEntryRef;
    @NotNull
    private final EntityCreator creator;
    @NotNull
    private final ActivityCreator activityCreators;
    @NotNull
    private final List<Pair<PropertySupplier<?>, Integer>> suppliers;
    @NotNull
    private final Position spawnPosition;
    @NotNull
    private final Var<Double> showRange;
    @Nullable
    private ActivityManager<SharedActivityContext> activityManager;
    @NotNull
    private final ConcurrentHashMap<UUID, DisplayEntity> entities;
    @NotNull
    private EntityState lastState;

    public SharedAudienceEntityDisplay(@NotNull Ref<? extends EntityInstanceEntry> instanceEntryRef, @NotNull EntityCreator creator, @NotNull ActivityCreator activityCreators, @NotNull List<? extends Pair<? extends PropertySupplier<?>, Integer>> suppliers, @NotNull Position spawnPosition, @NotNull Var<Double> showRange) {
        Intrinsics.checkNotNullParameter(instanceEntryRef, (String)"instanceEntryRef");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)activityCreators, (String)"activityCreators");
        Intrinsics.checkNotNullParameter(suppliers, (String)"suppliers");
        Intrinsics.checkNotNullParameter((Object)spawnPosition, (String)"spawnPosition");
        Intrinsics.checkNotNullParameter(showRange, (String)"showRange");
        super(instanceEntryRef);
        this.instanceEntryRef = instanceEntryRef;
        this.creator = creator;
        this.activityCreators = activityCreators;
        this.suppliers = suppliers;
        this.spawnPosition = spawnPosition;
        this.showRange = showRange;
        this.entities = new ConcurrentHashMap();
        this.lastState = new EntityState(0.0, 0.0f, 3, null);
    }

    public /* synthetic */ SharedAudienceEntityDisplay(Ref ref2, EntityCreator entityCreator, ActivityCreator activityCreator, List list, Position position, Var var, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            var = new ConstVar<Double>(SharedAudienceEntityDisplayKt.getEntityShowRange());
        }
        this(ref2, entityCreator, activityCreator, list, position, var);
    }

    @Override
    @NotNull
    public Ref<? extends EntityInstanceEntry> getInstanceEntryRef() {
        return this.instanceEntryRef;
    }

    @Override
    @NotNull
    public EntityCreator getCreator() {
        return this.creator;
    }

    @Override
    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager == null || (activityManager = activityManager.getPosition()) == null) {
            return false;
        }
        ActivityManager<SharedActivityContext> npcLocation = activityManager;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Double d = ((PositionProperty)((Object)npcLocation)).distanceSqrt(location);
        if (d == null) {
            return false;
        }
        double distance = d;
        double showRange = ((Number)Var.get$default(this.showRange, player, null, 2, null)).doubleValue();
        return distance <= showRange * showRange;
    }

    @Override
    public void initialize() {
        block0: {
            super.initialize();
            SharedActivityContext context = new SharedActivityContext(this.getInstanceEntryRef(), this.getPlayers(), null, 4, null);
            ActivityManager<SharedActivityContext> activityManager = this.activityManager = new ActivityManager<ActivityContext>(this.activityCreators.create(context, PositionPropertyKt.toProperty(this.spawnPosition)));
            if (activityManager == null) break block0;
            activityManager.initialize((SharedActivityContext)((ActivityContext)context));
        }
    }

    @Override
    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerFilterAdded(player);
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager == null) {
            return;
        }
        ActivityManager<SharedActivityContext> activityManager2 = activityManager;
        this.entities.computeIfAbsent(player.getUniqueId(), arg_0 -> SharedAudienceEntityDisplay.onPlayerFilterAdded$lambda$1(arg_0 -> SharedAudienceEntityDisplay.onPlayerFilterAdded$lambda$0(player, this, activityManager2, arg_0), arg_0));
        activityManager2.addedViewer(new SharedActivityContext(this.getInstanceEntryRef(), this.getPlayers(), null, 4, null), player);
    }

    @Override
    public void tick() {
        EntityState entityState;
        Object it;
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Player)element$iv;
            boolean bl = false;
            this.refresh((Player)it);
        }
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Object object = (DisplayEntity)CollectionsKt.firstOrNull((Iterable)collection);
        if (object != null && (object = ((DisplayEntity)object).getState()) != null) {
            Object it2 = it = object;
            boolean bl = false;
            this.lastState = it2;
            entityState = it;
        } else {
            entityState = this.lastState;
        }
        EntityState entityState2 = entityState;
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager != null) {
            activityManager.tick((SharedActivityContext)((ActivityContext)new SharedActivityContext(this.getInstanceEntryRef(), this.getPlayers(), entityState2)));
        }
        Collection<DisplayEntity> collection2 = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$forEach$iv2 = collection2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            DisplayEntity it3 = (DisplayEntity)element$iv;
            boolean bl = false;
            it3.tick();
        }
    }

    @Override
    public void onPlayerFilterRemoved(@NotNull Player player) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ActivityManager<SharedActivityContext> activityManager = this.activityManager;
            if (activityManager != null) {
                activityManager.removedViewer(new SharedActivityContext(this.getInstanceEntryRef(), this.getPlayers(), null, 4, null), player);
            }
            super.onPlayerFilterRemoved(player);
            DisplayEntity displayEntity = this.entities.remove(player.getUniqueId());
            if (displayEntity == null) break block1;
            displayEntity.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayEntity it = (DisplayEntity)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.entities.clear();
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager != null) {
            activityManager.dispose((SharedActivityContext)((ActivityContext)new SharedActivityContext(this.getInstanceEntryRef(), this.getPlayers(), null, 4, null)));
        }
        this.activityManager = null;
        this.lastState = new EntityState(0.0, 0.0f, 3, null);
    }

    @Override
    public boolean playerSeesEntity(@NotNull UUID playerId, int entityId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.contains(entityId) : false;
    }

    @Override
    @Nullable
    public Position position(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        return activityManager != null && (activityManager = activityManager.getPosition()) != null ? ((PositionProperty)((Object)activityManager)).toPosition() : null;
    }

    @Override
    @NotNull
    public EntityState entityState(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Object object = this.entities.get(playerId);
        if (object == null || (object = ((DisplayEntity)object).getState()) == null) {
            object = this.lastState;
        }
        return object;
    }

    @Override
    @Nullable
    public <P extends EntityProperty> P property(@NotNull UUID playerId, @NotNull KClass<P> type) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return (P)(displayEntity != null ? displayEntity.property(type) : null);
    }

    @Override
    public boolean canView(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.canConsider(playerId);
    }

    @Override
    public boolean isSpawnedIn(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.entities.get(playerId) != null;
    }

    @Override
    public int entityId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.getEntityId() : 0;
    }

    @Override
    @Nullable
    public EntityDefinitionEntry getDefinition() {
        return AudienceEntityDisplay.super.getDefinition();
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$0(Player $player, SharedAudienceEntityDisplay this$0, ActivityManager $activityManager, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DisplayEntity($player, this$0.getCreator(), $activityManager, DisplayEntityKt.toCollectors(this$0.suppliers));
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$1(Function1 $tmp0, Object p0) {
        return (DisplayEntity)$tmp0.invoke(p0);
    }
}

