/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.google.common.collect.Sets;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplayState;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lirand.api.extensions.events.ListenerExtensionsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rH&J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rH&J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\nH\u0096\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "value", "", "isActive", "()Z", "playerIds", "", "Ljava/util/UUID;", "players", "", "Lorg/bukkit/entity/Player;", "getPlayers", "()Ljava/util/List;", "displayState", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplayState;", "player", "initialize", "", "dispose", "addPlayer", "removePlayer", "onPlayerAdd", "onPlayerRemove", "contains", "uuid", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1617#2,9:195\n1869#2:204\n1870#2:206\n1626#2:207\n1869#2,2:208\n1#3:205\n*S KotlinDebug\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceDisplay\n*L\n72#1:195,9\n72#1:204\n72#1:206\n72#1:207\n88#1:208,2\n72#1:205\n*E\n"})
public abstract class AudienceDisplay
implements Listener {
    private boolean isActive;
    @NotNull
    private final Set<UUID> playerIds;

    public AudienceDisplay() {
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet(...)");
        this.playerIds = set;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Player> getPlayers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.playerIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (ServerExtensionsKt.getServer().getPlayer(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public AudienceDisplayState displayState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.playerIds.contains(player.getUniqueId())) {
            return AudienceDisplayState.IN_AUDIENCE;
        }
        return AudienceDisplayState.NOT_CONSIDERED;
    }

    public void initialize() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        ServerExtensionsKt.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)TypewriterPaperPluginKt.getPlugin());
    }

    public void dispose() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        Iterable $this$forEach$iv = this.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.removePlayer(it);
        }
        ListenerExtensionsKt.unregister(this);
    }

    public final void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.playerIds.isEmpty()) {
            this.initialize();
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        if (!this.playerIds.add(uUID)) {
            return;
        }
        this.onPlayerAdd(player);
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.playerIds.remove(player.getUniqueId())) {
            return;
        }
        this.onPlayerRemove(player);
        if (this.playerIds.isEmpty()) {
            this.dispose();
        }
    }

    public abstract void onPlayerAdd(@NotNull Player var1);

    public abstract void onPlayerRemove(@NotNull Player var1);

    public boolean contains(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.playerIds.contains(player.getUniqueId());
    }

    public boolean contains(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.playerIds.contains(uuid);
    }
}

