/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.google.common.collect.Sets;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.AudienceManager;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplayState;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.Invertible;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.java.KoinJavaComponent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH&J\u0012\u0010\u0017\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\bJ\n\u0010\u0019\u001a\u00020\b*\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bJ\u0011\u0010!\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0096\u0002J\u0011\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bH\u0096\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "<init>", "(Lcom/typewritermc/core/entries/Ref;)V", "inverted", "", "filteredPlayers", "", "Ljava/util/UUID;", "players", "", "Lorg/bukkit/entity/Player;", "getPlayers", "()Ljava/util/List;", "consideredPlayers", "getConsideredPlayers", "displayState", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplayState;", "player", "filter", "updateFilter", "isFiltered", "refresh", "onPlayerAdd", "", "onPlayerRemove", "onPlayerFilterAdded", "onPlayerFilterRemoved", "canConsider", "uuid", "contains", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1617#2,9:195\n1869#2:204\n1870#2:206\n1626#2:207\n1#3:205\n*S KotlinDebug\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceFilter\n*L\n122#1:195,9\n122#1:204\n122#1:206\n122#1:207\n122#1:205\n*E\n"})
public abstract class AudienceFilter
extends AudienceDisplay {
    @NotNull
    private final Ref<? extends AudienceFilterEntry> ref;
    private final boolean inverted;
    @NotNull
    private final Set<UUID> filteredPlayers;

    public AudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref2) {
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        this.ref = ref2;
        AudienceFilterEntry audienceFilterEntry = this.ref.get();
        Invertible invertible = audienceFilterEntry instanceof Invertible ? (Invertible)((Object)audienceFilterEntry) : null;
        this.inverted = invertible != null ? invertible.getInverted() : false;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet(...)");
        this.filteredPlayers = set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Player> getPlayers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.filteredPlayers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (ServerExtensionsKt.getServer().getPlayer(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<Player> getConsideredPlayers() {
        return super.getPlayers();
    }

    @Override
    @NotNull
    public AudienceDisplayState displayState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.contains(player)) {
            return AudienceDisplayState.IN_AUDIENCE;
        }
        if (this.canConsider(player)) {
            return AudienceDisplayState.BLOCKED;
        }
        return AudienceDisplayState.NOT_CONSIDERED;
    }

    public abstract boolean filter(@NotNull Player var1);

    public final boolean updateFilter(@NotNull Player $this$updateFilter, boolean isFiltered) {
        boolean allow;
        Intrinsics.checkNotNullParameter((Object)$this$updateFilter, (String)"<this>");
        boolean bl = allow = !this.inverted == isFiltered && this.canConsider($this$updateFilter);
        if (allow) {
            UUID uUID = $this$updateFilter.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            if (this.filteredPlayers.add(uUID)) {
                this.onPlayerFilterAdded($this$updateFilter);
                ((AudienceManager)KoinJavaComponent.get$default(AudienceManager.class, null, null, 6, null)).addPlayerToChildren($this$updateFilter, this.ref);
            }
        } else if (this.filteredPlayers.remove($this$updateFilter.getUniqueId())) {
            this.onPlayerFilterRemoved($this$updateFilter);
            ((AudienceManager)KoinJavaComponent.get$default(AudienceManager.class, null, null, 6, null)).removePlayerFromChildren($this$updateFilter, this.ref);
        }
        return allow;
    }

    public final boolean refresh(@NotNull Player $this$refresh) {
        Intrinsics.checkNotNullParameter((Object)$this$refresh, (String)"<this>");
        return this.updateFilter($this$refresh, this.filter($this$refresh));
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.refresh(player);
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.updateFilter(player, false);
    }

    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public void onPlayerFilterRemoved(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public final boolean canConsider(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return super.contains(player);
    }

    public final boolean canConsider(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return super.contains(uuid);
    }

    @Override
    public boolean contains(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return this.contains(uUID);
    }

    @Override
    public boolean contains(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.filteredPlayers.contains(uuid);
    }
}

