/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.github.retrooper.packetevents.protocol.score.ScoreFormat;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerResetScore;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.AudienceManagerKt;
import com.typewritermc.engine.paper.entry.audience.PlayerSingleDisplay;
import com.typewritermc.engine.paper.entry.audience.SingleFilter;
import com.typewritermc.engine.paper.entry.entries.LinesEntry;
import com.typewritermc.engine.paper.entry.entries.SidebarEntry;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay;", "Lcom/typewritermc/engine/paper/entry/audience/PlayerSingleDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/SidebarEntry;", "player", "Lorg/bukkit/entity/Player;", "displayKClass", "Lkotlin/reflect/KClass;", "Lcom/typewritermc/engine/paper/entry/audience/SingleFilter;", "current", "Lcom/typewritermc/core/entries/Ref;", "<init>", "(Lorg/bukkit/entity/Player;Lkotlin/reflect/KClass;Lcom/typewritermc/core/entries/Ref;)V", "lines", "", "Lcom/typewritermc/engine/paper/entry/entries/LinesEntry;", "lastTitle", "", "lastLines", "Lnet/kyori/adventure/text/Component;", "initialize", "", "setup", "tick", "dispose", "createSidebar", "title", "disposeSidebar", "refreshSidebar", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSidebarEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SidebarEntry.kt\ncom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n1068#2:179\n1617#2,9:180\n1869#2:189\n1870#2:191\n1626#2:192\n1#3:190\n*S KotlinDebug\n*F\n+ 1 SidebarEntry.kt\ncom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay\n*L\n93#1:176\n93#1:177,2\n94#1:179\n95#1:180,9\n95#1:189\n95#1:191\n95#1:192\n95#1:190\n*E\n"})
final class PlayerSidebarDisplay
extends PlayerSingleDisplay<SidebarEntry> {
    @NotNull
    private List<Ref<LinesEntry>> lines;
    @NotNull
    private String lastTitle;
    @NotNull
    private List<? extends Component> lastLines;

    public PlayerSidebarDisplay(@NotNull Player player, @NotNull KClass<? extends SingleFilter<SidebarEntry, ?>> displayKClass, @NotNull Ref<SidebarEntry> current) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(displayKClass, (String)"displayKClass");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        super(player, displayKClass, current);
        this.lines = CollectionsKt.emptyList();
        this.lastTitle = "";
        this.lastLines = CollectionsKt.emptyList();
    }

    @Override
    public void initialize() {
        super.initialize();
        SidebarEntry sidebarEntry = (SidebarEntry)this.getRef().get();
        if (sidebarEntry == null) {
            return;
        }
        SidebarEntry sidebar = sidebarEntry;
        String title = sidebar.display(this.getPlayer());
        this.createSidebar(title);
    }

    @Override
    public void setup() {
        super.setup();
        this.lines = AudienceManagerKt.descendants(this.getRef(), Reflection.getOrCreateKotlinClass(LinesEntry.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        super.tick();
        SidebarEntry sidebarEntry = (SidebarEntry)this.getRef().get();
        if (sidebarEntry == null) {
            return;
        }
        SidebarEntry sidebar = sidebarEntry;
        String title = sidebar.display(this.getPlayer());
        Iterable iterable = this.lines;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ref it = (Ref)element$iv$iv;
            boolean bl = false;
            if (!AudienceManagerKt.inAudience(this.getPlayer(), it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Ref it = (Ref)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(LibraryKt.getPriority(it));
                it = (Ref)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(LibraryKt.getPriority(it)));
            }
        });
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ref it = (Ref)element$iv$iv;
            boolean bl2 = false;
            LinesEntry linesEntry = (LinesEntry)it.get();
            if ((linesEntry != null ? linesEntry.lines(this.getPlayer()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List<Component> lines = MiniMessagesKt.splitComponents(PlaceholderExpansionKt.parsePlaceholders(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), this.getPlayer()), new TagResolver[0]);
        if (!Intrinsics.areEqual(lines, this.lastLines) || !Intrinsics.areEqual((Object)title, (Object)this.lastTitle)) {
            this.refreshSidebar(title, lines);
            this.lastTitle = title;
            this.lastLines = lines;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeSidebar();
        this.lines = CollectionsKt.emptyList();
        this.lastTitle = "";
        this.lastLines = CollectionsKt.emptyList();
    }

    private final void createSidebar(String title) {
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE, MiniMessagesKt.asMini(title), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore()), this.getPlayer());
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerDisplayScoreboard(1, "typewriter"), this.getPlayer());
    }

    private final void disposeSidebar() {
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, (Component)Component.empty(), null, null), this.getPlayer());
    }

    private final void refreshSidebar(String title, List<? extends Component> lines) {
        WrapperPlayServerScoreboardObjective packet = new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE, MiniMessagesKt.asMini(title), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore());
        PlayerPacketsKt.sendPacketTo((PacketWrapper)packet, this.getPlayer());
        WrapperPlayServerDisplayScoreboard displayPacket = new WrapperPlayServerDisplayScoreboard(1, "typewriter");
        PlayerPacketsKt.sendPacketTo((PacketWrapper)displayPacket, this.getPlayer());
        for (IndexedValue indexedValue : CollectionsKt.take((Iterable)CollectionsKt.withIndex((Iterable)lines), (int)15)) {
            int index = indexedValue.component1();
            Component line = (Component)indexedValue.component2();
            Component lastLine = (Component)CollectionsKt.getOrNull(this.lastLines, (int)index);
            if (Intrinsics.areEqual((Object)lastLine, (Object)line)) continue;
            PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerUpdateScore("typewriter_line_" + index, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, "typewriter", 15 - index, line, (ScoreFormat)ScoreFormat.blankScore()), this.getPlayer());
        }
        if (lines.size() < this.lastLines.size()) {
            int n = this.lastLines.size();
            for (int i = lines.size(); i < n; ++i) {
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerResetScore("typewriter_line_" + i, "typewriter"), this.getPlayer());
            }
        }
    }
}

