/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.modrinth;

import com.typewritermc.engine.paper.extensions.modrinth.VersionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lcom/typewritermc/engine/paper/extensions/modrinth/SemanticVersion;", "", "major", "", "minor", "patch", "type", "Lcom/typewritermc/engine/paper/extensions/modrinth/VersionType;", "buildNumber", "<init>", "(IIILcom/typewritermc/engine/paper/extensions/modrinth/VersionType;I)V", "getMajor", "()I", "getMinor", "getPatch", "getType", "()Lcom/typewritermc/engine/paper/extensions/modrinth/VersionType;", "getBuildNumber", "compareTo", "other", "toString", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "hashCode", "Companion", "engine-paper"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final VersionType type;
    private final int buildNumber;

    public SemanticVersion(int major, int minor, int patch, @NotNull VersionType type, int buildNumber) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.type = type;
        this.buildNumber = buildNumber;
    }

    public /* synthetic */ SemanticVersion(int n, int n2, int n3, VersionType versionType, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            versionType = VersionType.RELEASE;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, versionType, n4);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final VersionType getType() {
        return this.type;
    }

    public final int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        if (this.type != other.type) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> 1;
                case 2 -> -1;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return this.buildNumber - other.buildNumber;
    }

    @NotNull
    public String toString() {
        if (this.type == VersionType.RELEASE) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor + "." + this.patch + "-" + this.type.getSuffix() + "-" + this.buildNumber;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final VersionType component4() {
        return this.type;
    }

    public final int component5() {
        return this.buildNumber;
    }

    @NotNull
    public final SemanticVersion copy(int major, int minor, int patch, @NotNull VersionType type, int buildNumber) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new SemanticVersion(major, minor, patch, type, buildNumber);
    }

    public static /* synthetic */ SemanticVersion copy$default(SemanticVersion semanticVersion, int n, int n2, int n3, VersionType versionType, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = semanticVersion.major;
        }
        if ((n5 & 2) != 0) {
            n2 = semanticVersion.minor;
        }
        if ((n5 & 4) != 0) {
            n3 = semanticVersion.patch;
        }
        if ((n5 & 8) != 0) {
            versionType = semanticVersion.type;
        }
        if ((n5 & 0x10) != 0) {
            n4 = semanticVersion.buildNumber;
        }
        return semanticVersion.copy(n, n2, n3, versionType, n4);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Integer.hashCode(this.buildNumber);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion semanticVersion = (SemanticVersion)other;
        if (this.major != semanticVersion.major) {
            return false;
        }
        if (this.minor != semanticVersion.minor) {
            return false;
        }
        if (this.patch != semanticVersion.patch) {
            return false;
        }
        if (this.type != semanticVersion.type) {
            return false;
        }
        return this.buildNumber == semanticVersion.buildNumber;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/engine/paper/extensions/modrinth/SemanticVersion$Companion;", "", "<init>", "()V", "fromString", "Lcom/typewritermc/engine/paper/extensions/modrinth/SemanticVersion;", "version", "", "engine-paper"})
    @SourceDebugExtension(value={"SMAP\nModrinth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Modrinth.kt\ncom/typewritermc/engine/paper/extensions/modrinth/SemanticVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1563#2:230\n1634#2,3:231\n*S KotlinDebug\n*F\n+ 1 Modrinth.kt\ncom/typewritermc/engine/paper/extensions/modrinth/SemanticVersion$Companion\n*L\n175#1:230\n175#1:231,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SemanticVersion fromString(@NotNull String version) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            String[] stringArray = new String[]{"-"};
            List versionParts = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String versionPart = (String)versionParts.get(0);
            Object object = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)versionPart, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 3) {
                throw new IllegalArgumentException("Invalid version format: " + version);
            }
            Iterable $this$map$iv = parts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Integer.parseInt((String)it));
            }
            object = (List)destination$iv$iv;
            int major = ((Number)object.get(0)).intValue();
            int minor = ((Number)object.get(1)).intValue();
            int patch = ((Number)object.get(2)).intValue();
            if (versionParts.size() == 1) {
                return new SemanticVersion(major, minor, patch, null, 0, 24, null);
            }
            VersionType type = Intrinsics.areEqual((Object)((String)versionParts.get(1)), (Object)"dev") ? VersionType.DEVELOPMENT : VersionType.RELEASE;
            int buildNumber = versionParts.size() == 3 ? Integer.parseInt((String)versionParts.get(2)) : 0;
            return new SemanticVersion(major, minor, patch, type, buildNumber);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VersionType.values().length];
            try {
                nArray[VersionType.RELEASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionType.DEVELOPMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

