/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.facts;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.interaction.SessionTracker;
import com.typewritermc.engine.paper.entry.entries.ReadableFactEntry;
import com.typewritermc.engine.paper.facts.FactData;
import com.typewritermc.engine.paper.facts.FactListener;
import com.typewritermc.engine.paper.facts.FactListenerSubscription;
import com.typewritermc.engine.paper.facts.FactTrackerKt;
import com.typewritermc.engine.paper.facts.FactUpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0014\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\bJ&\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J7\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u001b2\u001b\u0010\u001c\u001a\u0017\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000f0\u001dj\u0002` \u00a2\u0006\u0002\b\u001fJ\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/typewritermc/engine/paper/facts/FactTracker;", "Lcom/typewritermc/core/interaction/SessionTracker;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "factCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "", "listeners", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/facts/FactListener;", "setup", "", "tick", "teardown", "refresh", "refreshFact", "ref", "notifyListeners", "oldValue", "newValue", "addListener", "Lcom/typewritermc/engine/paper/facts/FactListenerSubscription;", "facts", "", "listener", "Lkotlin/Function1;", "Lcom/typewritermc/engine/paper/facts/FactUpdateContext;", "Lkotlin/ExtensionFunctionType;", "Lcom/typewritermc/engine/paper/facts/FactUpdateEvent;", "removeListener", "subscription", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nFactTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FactTracker.kt\ncom/typewritermc/engine/paper/facts/FactTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1869#2,2:136\n774#2:138\n865#2,2:139\n1869#2,2:141\n2746#2,3:143\n*S KotlinDebug\n*F\n+ 1 FactTracker.kt\ncom/typewritermc/engine/paper/facts/FactTracker\n*L\n36#1:136,2\n53#1:138\n53#1:139,2\n54#1:141,2\n81#1:143,3\n*E\n"})
public final class FactTracker
implements SessionTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final ConcurrentHashMap<Ref<ReadableFactEntry>, Integer> factCache;
    @NotNull
    private final ConcurrentHashMap<UUID, FactListener> listeners;

    public FactTracker(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.factCache = new ConcurrentHashMap();
        this.listeners = new ConcurrentHashMap();
    }

    @Override
    public void setup() {
    }

    @Override
    public void tick() {
        this.refresh();
    }

    @Override
    public void teardown() {
        this.listeners.clear();
        this.factCache.clear();
    }

    private final void refresh() {
        Set set = this.factCache.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ref it = (Ref)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.refreshFact(it);
        }
    }

    public final void refreshFact(@NotNull Ref<ReadableFactEntry> ref2) {
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        Integer n = this.factCache.get(ref2);
        if (n == null) {
            return;
        }
        int old = n;
        ReadableFactEntry readableFactEntry = ref2.get();
        if (readableFactEntry == null) {
            return;
        }
        ReadableFactEntry fact = readableFactEntry;
        int n2 = fact.readForPlayersGroup(this.player).getValue();
        if (old != n2) {
            ((Map)this.factCache).put(ref2, n2);
            this.notifyListeners(ref2, old, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyListeners(Ref<ReadableFactEntry> ref2, int oldValue, int newValue) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection<FactListener> collection = this.listeners.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FactListener it = (FactListener)element$iv$iv;
            boolean bl = false;
            if (!it.contains(ref2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FactListener listener2 = (FactListener)element$iv;
            boolean bl = false;
            listener2.getListener().invoke((Object)new FactUpdateContext(this.player, ref2, oldValue, newValue));
        }
    }

    @NotNull
    public final FactListenerSubscription addListener(@NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function1<? super FactUpdateContext, Unit> listener2) {
        Intrinsics.checkNotNullParameter(facts2, (String)"facts");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        UUID id = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)UUID.randomUUID(), (String)"randomUUID(...)");
        } while (this.listeners.containsKey(id));
        ((Map)this.listeners).put(id, new FactListener(id, facts2, listener2));
        for (Ref<ReadableFactEntry> fact : facts2) {
            this.factCache.computeIfAbsent(fact, arg_0 -> FactTracker.addListener$lambda$4(arg_0 -> FactTracker.addListener$lambda$3(fact, this, arg_0), arg_0));
        }
        return new FactListenerSubscription(id);
    }

    public final void removeListener(@NotNull FactListenerSubscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        this.listeners.remove(subscription.getId());
        Set set = this.factCache.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        for (Ref fact : CollectionsKt.toList((Iterable)set)) {
            boolean bl;
            block4: {
                Collection<FactListener> collection = this.listeners.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$none$iv = collection;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FactListener it = (FactListener)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)fact);
                        if (!it.contains(fact)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.factCache.remove(fact);
        }
    }

    private static final Integer addListener$lambda$3(Ref $fact, FactTracker this$0, Ref it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = (ReadableFactEntry)$fact.get();
        return object != null && (object = object.readForPlayersGroup(this$0.player)) != null ? Integer.valueOf(((FactData)object).getValue()) : Integer.valueOf(0);
    }

    private static final Integer addListener$lambda$4(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final FactListenerSubscription listenForFacts(@NotNull Player player, @NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function1<? super FactUpdateContext, Unit> listener2) {
        return Companion.listenForFacts(player, facts2, listener2);
    }

    @JvmStatic
    public static final void stopListening(@NotNull Player player, @NotNull FactListenerSubscription subscription) {
        Companion.stopListening(player, subscription);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u001b\u0010\f\u001a\u0017\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0011\u00a2\u0006\u0002\b\u0010H\u0007J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/typewritermc/engine/paper/facts/FactTracker$Companion;", "", "<init>", "()V", "listenForFacts", "Lcom/typewritermc/engine/paper/facts/FactListenerSubscription;", "player", "Lorg/bukkit/entity/Player;", "facts", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "listener", "Lkotlin/Function1;", "Lcom/typewritermc/engine/paper/facts/FactUpdateContext;", "", "Lkotlin/ExtensionFunctionType;", "Lcom/typewritermc/engine/paper/facts/FactUpdateEvent;", "stopListening", "subscription", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FactListenerSubscription listenForFacts(@NotNull Player player, @NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function1<? super FactUpdateContext, Unit> listener2) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(facts2, (String)"facts");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            return FactTrackerKt.listenForFacts(player, facts2, listener2);
        }

        @JvmStatic
        public final void stopListening(@NotNull Player player, @NotNull FactListenerSubscription subscription) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
            FactTrackerKt.stopListening(player, subscription);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

