/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.facts.storage;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/typewritermc/engine/paper/facts/storage/LocalDateTimeSerializer;", "Lcom/google/gson/JsonSerializer;", "Ljava/time/LocalDateTime;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "engine-paper"})
public final class LocalDateTimeSerializer
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    @NotNull
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    private LocalDateTimeSerializer() {
    }

    @NotNull
    public JsonElement serialize(@NotNull LocalDateTime src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (JsonElement)new JsonPrimitive((Number)src.toInstant(ZoneOffset.UTC).getEpochSecond());
    }

    @NotNull
    public LocalDateTime deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(json.getAsLong(), 0, ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofEpochSecond(...)");
        return localDateTime;
    }
}

