/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.typewritermc.engine.paper.interaction.BlockingStatus;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.interaction.Message;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\bJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/typewritermc/engine/paper/interaction/ChatHistory;", "", "<init>", "()V", "messages", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/typewritermc/engine/paper/interaction/Message;", "blocking", "", "blockingState", "Lcom/typewritermc/engine/paper/interaction/BlockingStatus;", "startBlocking", "", "stopBlocking", "shouldBlockMessage", "addMessage", "message", "addMessage$engine_paper", "hasMessage", "Lnet/kyori/adventure/text/Component;", "clear", "allowedMessageThrough", "clearMessage", "", "resendMessages", "player", "Lorg/bukkit/entity/Player;", "composeDarkMessage", "composeEmptyMessage", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nChatHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1761#2,3:368\n1869#2,2:371\n1869#2,2:373\n*S KotlinDebug\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistory\n*L\n229#1:368,3\n259#1:371,2\n269#1:373,2\n*E\n"})
public final class ChatHistory {
    @NotNull
    private final ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();
    private boolean blocking;
    @NotNull
    private BlockingStatus blockingState = BlockingStatus.FullBlocking.INSTANCE;

    public final void startBlocking() {
        if (this.blocking) {
            return;
        }
        this.blockingState = new BlockingStatus.PartialBlocking(0);
        this.blocking = true;
    }

    public final void stopBlocking() {
        this.blocking = false;
    }

    public final boolean shouldBlockMessage() {
        return this.blocking;
    }

    public final void addMessage$engine_paper(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        message.onAddedToHistory(this.blocking);
        if (this.blocking) {
            this.blockingState = this.blockingState.addMessage();
        }
        this.messages.add(message);
        while (this.messages.size() > 100 && this.messages.peek().getCanDelete()) {
            this.messages.poll();
        }
    }

    public final boolean hasMessage(@NotNull Component message) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Iterable $this$any$iv = this.messages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getMessage(), (Object)message)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void clear() {
        this.messages.clear();
    }

    public final void allowedMessageThrough() {
        this.blockingState = BlockingStatus.FullBlocking.INSTANCE;
    }

    private final String clearMessage() {
        return StringsKt.repeat((CharSequence)"\n", (int)(100 - Math.min(this.messages.size(), ChatHistoryHandlerKt.access$getDarkenLimit())));
    }

    public final void resendMessages(@NotNull Player player, boolean clear) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockingStatus status = this.blockingState;
        if (status instanceof BlockingStatus.FullBlocking) {
            TextComponent textComponent = Component.text((String)this.clearMessage());
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
            Message msg = new Message.TextMessage((Component)textComponent);
            Iterator<Message> iterator2 = this.messages.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Message> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Message message = iterator3.next();
                if (message.getCanMerge()) {
                    Intrinsics.checkNotNull((Object)message);
                    msg = msg.merge(message);
                    continue;
                }
                msg.send(player);
                message.send(player);
                msg = Message.Empty.INSTANCE;
            }
            msg.send(player);
        } else if (status instanceof BlockingStatus.PartialBlocking) {
            Iterable $this$forEach$iv = CollectionsKt.takeLast((List)CollectionsKt.toList((Iterable)this.messages), (int)((BlockingStatus.PartialBlocking)status).getNewMessages());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Message it = (Message)element$iv;
                boolean bl = false;
                it.send(player);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.blockingState = new BlockingStatus.PartialBlocking(0);
    }

    public static /* synthetic */ void resendMessages$default(ChatHistory chatHistory, Player player, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        chatHistory.resendMessages(player, bl);
    }

    @NotNull
    public final Component composeDarkMessage(@NotNull Component message, boolean clear) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TextComponent msg = null;
        TextComponent textComponent = Component.text((String)"no-index");
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        msg = textComponent;
        if (clear) {
            Component component = msg.append((Component)Component.text((String)this.clearMessage()));
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
            msg = component;
        }
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)this.messages, (int)Math.max(0, this.messages.size() - ChatHistoryHandlerKt.access$getDarkenLimit())), (int)ChatHistoryHandlerKt.access$getDarkenLimit());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Message it = (Message)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)msg.append(it.getDarkenMessage()), (String)"append(...)");
        }
        Component component = msg.append((Component)Component.text((String)StringsKt.repeat((CharSequence)"\n", (int)ChatHistoryHandlerKt.access$getSpacing())));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
        msg = component;
        Component component2 = msg.append(message);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"append(...)");
        return component2;
    }

    public static /* synthetic */ Component composeDarkMessage$default(ChatHistory chatHistory, Component component, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatHistory.composeDarkMessage(component, bl);
    }

    @NotNull
    public final Component composeEmptyMessage(@NotNull Component message, boolean clear) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TextComponent textComponent = Component.text((String)"no-index");
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        TextComponent msg = textComponent;
        if (clear) {
            Component component = msg.append((Component)Component.text((String)this.clearMessage()));
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
            msg = (TextComponent)component;
        }
        Component component = msg.append(message);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
        return component;
    }

    public static /* synthetic */ Component composeEmptyMessage$default(ChatHistory chatHistory, Component component, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatHistory.composeEmptyMessage(component, bl);
    }
}

