/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_3;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisguisedChat;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.github.shynixn.mccoroutine.bukkit.MCCoroutineKt;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.Message;
import com.typewritermc.engine.paper.interaction.ResendTokenRegistry;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020!H\u0007J\u0006\u0010\"\u001a\u00020\rR\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/typewritermc/engine/paper/interaction/ChatHistoryHandler;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "resendTokenRegistry", "Lcom/typewritermc/engine/paper/interaction/ResendTokenRegistry;", "getResendTokenRegistry", "()Lcom/typewritermc/engine/paper/interaction/ResendTokenRegistry;", "resendTokenRegistry$delegate", "Lkotlin/Lazy;", "initialize", "", "histories", "", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/interaction/ChatHistory;", "onPacketSend", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "findMessage", "Lcom/typewritermc/engine/paper/interaction/Message;", "shouldSaveMessage", "", "Lnet/kyori/adventure/text/Component;", "getHistory", "pid", "player", "Lorg/bukkit/entity/Player;", "blockMessages", "unblockMessages", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "shutdown", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nChatHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistoryHandler\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,367:1\n58#2,6:368\n382#3,7:374\n*S KotlinDebug\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistoryHandler\n*L\n93#1:368,6\n171#1:374,7\n*E\n"})
public final class ChatHistoryHandler
extends PacketListenerAbstract
implements Listener,
KoinComponent {
    @NotNull
    private final Lazy resendTokenRegistry$delegate;
    @NotNull
    private final Map<UUID, ChatHistory> histories;

    public ChatHistoryHandler() {
        super(PacketListenerPriority.HIGH);
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.resendTokenRegistry$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ResendTokenRegistry>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ResendTokenRegistry invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ResendTokenRegistry.class), (Qualifier)qualifier$iv, (Function0<? extends ParametersHolder>)parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ResendTokenRegistry.class), (Qualifier)qualifier$iv, (Function0<? extends ParametersHolder>)parameters$iv);
                }
                return t;
            }
        }));
        this.histories = new LinkedHashMap();
    }

    private final ResendTokenRegistry getResendTokenRegistry() {
        Lazy lazy = this.resendTokenRegistry$delegate;
        return (ResendTokenRegistry)lazy.getValue();
    }

    public final void initialize() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
        PluginManager pluginManager = ServerExtensionsKt.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        MCCoroutineKt.registerSuspendingEvents((PluginManager)pluginManager, (Listener)this, (Plugin)((Plugin)TypewriterPaperPluginKt.getPlugin()));
    }

    public void onPacketSend(@Nullable PacketSendEvent event) {
        try {
            if (event == null) {
                return;
            }
            Message message = this.findMessage(event);
            if (message == null) {
                return;
            }
            Message message2 = message;
            Component component = message2.getMessage();
            UUID uUID = event.getUser().getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            ChatHistory history = this.getHistory(uUID);
            if (component instanceof TextComponent) {
                String string = ((TextComponent)component).content();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content(...)");
                if (StringsKt.startsWith$default((String)string, (String)"no-index", (boolean)false, (int)2, null)) {
                    history.allowedMessageThrough();
                    return;
                }
            }
            ResendTokenRegistry resendTokenRegistry = this.getResendTokenRegistry();
            UUID uUID2 = event.getUser().getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (resendTokenRegistry.consume(uUID2, component)) {
                return;
            }
            if (this.shouldSaveMessage(component)) {
                history.addMessage$engine_paper(message2);
            }
            if (history.shouldBlockMessage()) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Message findMessage(PacketSendEvent event) {
        Message message;
        PacketTypeCommon packetTypeCommon = event.getPacketType();
        if (packetTypeCommon == PacketType.Play.Server.CHAT_MESSAGE) {
            WrapperPlayServerChatMessage packet = new WrapperPlayServerChatMessage(event);
            ChatMessage chatMessage = packet.getMessage();
            ChatMessage_v1_19_3 chatMessage_v1_19_3 = chatMessage instanceof ChatMessage_v1_19_3 ? (ChatMessage_v1_19_3)chatMessage : null;
            if (chatMessage_v1_19_3 == null) {
                Component component = packet.getMessage().getChatContent();
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getChatContent(...)");
                return new Message.TextMessage(component);
            }
            ChatMessage_v1_19_3 message2 = chatMessage_v1_19_3;
            Component component = message2.getUnsignedChatContent().orElseGet(() -> ChatHistoryHandler.findMessage$lambda$0(message2));
            Intrinsics.checkNotNull((Object)component);
            message = new Message.PlayerMessage(component, packet);
        } else if (packetTypeCommon == PacketType.Play.Server.DISGUISED_CHAT) {
            WrapperPlayServerDisguisedChat packet = new WrapperPlayServerDisguisedChat(event);
            Component component = packet.getChatFormatting().getType().getChatDecoration().decorate(packet.getMessage(), packet.getChatFormatting());
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"decorate(...)");
            message = new Message.TextMessage(component);
        } else if (packetTypeCommon == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
            WrapperPlayServerSystemChatMessage packet = new WrapperPlayServerSystemChatMessage(event);
            if (packet.isOverlay()) {
                return null;
            }
            Component component = packet.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getMessage(...)");
            message = new Message.TextMessage(component);
        } else {
            message = null;
        }
        return message;
    }

    public final boolean shouldSaveMessage(@NotNull Component $this$shouldSaveMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldSaveMessage, (String)"<this>");
        return !($this$shouldSaveMessage instanceof TranslatableComponent) || !Intrinsics.areEqual((Object)((TranslatableComponent)$this$shouldSaveMessage).key(), (Object)"multiplayer.message_not_delivered");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChatHistory getHistory(@NotNull UUID pid) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        Map<UUID, ChatHistory> map2 = this.histories;
        UUID key$iv = pid;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ChatHistory answer$iv = new ChatHistory();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ChatHistory)object;
    }

    @NotNull
    public final ChatHistory getHistory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return this.getHistory(uUID);
    }

    public final void blockMessages(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getHistory(player).startBlocking();
    }

    public final void unblockMessages(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getHistory(player).stopBlocking();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.histories.remove(event.getPlayer().getUniqueId());
    }

    public final void shutdown() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final Component findMessage$lambda$0(ChatMessage_v1_19_3 $message) {
        ComponentLike[] componentLikeArray = new ComponentLike[]{$message.getChatFormatting().getName(), $message.getChatContent()};
        return (Component)Component.translatable((String)"chat.type.text", (ComponentLike[])componentLikeArray);
    }
}

