/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.loader.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.typewritermc.core.serialization.DataSerializer;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.World;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/typewritermc/engine/paper/loader/serializers/PositionSerializer;", "Lcom/typewritermc/core/serialization/DataSerializer;", "Lcom/typewritermc/core/utils/point/Position;", "<init>", "()V", "type", "Ljava/lang/reflect/Type;", "getType", "()Ljava/lang/reflect/Type;", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "engine-paper"})
public final class PositionSerializer
implements DataSerializer<Position> {
    @NotNull
    private final Type type = (Type)((Object)Position.class);

    @Override
    @NotNull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public Position deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (json instanceof JsonPrimitive && ((JsonPrimitive)json).getAsJsonPrimitive().isString()) {
            String string = ((JsonPrimitive)json).getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            String[] stringArray = new String[]{","};
            List split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() != 6) {
                throw new IllegalArgumentException("Could not parse coordinate from " + json);
            }
            World world = (World)context.deserialize((JsonElement)new JsonPrimitive((String)split.get(0)), (Type)((Object)World.class));
            double x = Double.parseDouble((String)split.get(1));
            double y = Double.parseDouble((String)split.get(2));
            double z = Double.parseDouble((String)split.get(3));
            float yaw = Float.parseFloat((String)split.get(4));
            float pitch = Float.parseFloat((String)split.get(5));
            Intrinsics.checkNotNull((Object)world);
            return new Position(world, x, y, z, yaw, pitch);
        }
        if (json instanceof JsonObject) {
            World world = (World)context.deserialize(((JsonObject)json).get("world"), (Type)((Object)World.class));
            JsonElement jsonElement = ((JsonObject)json).get("x");
            double x = jsonElement != null ? jsonElement.getAsDouble() : 0.0;
            JsonElement jsonElement2 = ((JsonObject)json).get("y");
            double y = jsonElement2 != null ? jsonElement2.getAsDouble() : 0.0;
            JsonElement jsonElement3 = ((JsonObject)json).get("z");
            double z = jsonElement3 != null ? jsonElement3.getAsDouble() : 0.0;
            JsonElement jsonElement4 = ((JsonObject)json).get("yaw");
            float yaw = jsonElement4 != null ? jsonElement4.getAsFloat() : 0.0f;
            JsonElement jsonElement5 = ((JsonObject)json).get("pitch");
            float pitch = jsonElement5 != null ? jsonElement5.getAsFloat() : 0.0f;
            Intrinsics.checkNotNull((Object)world);
            return new Position(world, x, y, z, yaw, pitch);
        }
        throw new IllegalArgumentException("Could not parse position from " + json);
    }

    @NotNull
    public JsonElement serialize(@NotNull Position src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject obj = new JsonObject();
        obj.add("world", context.serialize((Object)src.getWorld()));
        obj.addProperty("x", (Number)src.getX());
        obj.addProperty("y", (Number)src.getY());
        obj.addProperty("z", (Number)src.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(src.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(src.getPitch()));
        return (JsonElement)obj;
    }
}

