/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.loader.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.typewritermc.core.serialization.DataSerializer;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.utils.EmitterSoundSource;
import com.typewritermc.engine.paper.utils.LocationSoundSource;
import com.typewritermc.engine.paper.utils.SelfSoundSource;
import com.typewritermc.engine.paper.utils.SoundSource;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J&\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/typewritermc/engine/paper/loader/serializers/SoundSourceSerializer;", "Lcom/typewritermc/core/serialization/DataSerializer;", "Lcom/typewritermc/engine/paper/utils/SoundSource;", "<init>", "()V", "type", "Ljava/lang/reflect/Type;", "getType", "()Ljava/lang/reflect/Type;", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "engine-paper"})
public final class SoundSourceSerializer
implements DataSerializer<SoundSource> {
    @NotNull
    private final Type type = (Type)((Object)SoundSource.class);

    @Override
    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public JsonElement serialize(@Nullable SoundSource src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        SoundSource soundSource = src;
        if (soundSource instanceof SelfSoundSource) {
            obj.addProperty("type", "self");
        } else if (soundSource instanceof EmitterSoundSource) {
            obj.addProperty("type", "emitter");
            obj.addProperty("entryId", ((EmitterSoundSource)src).getEntryId());
        } else if (soundSource instanceof LocationSoundSource) {
            obj.addProperty("type", "location");
            JsonSerializationContext jsonSerializationContext = context;
            obj.add("location", jsonSerializationContext != null ? jsonSerializationContext.serialize((Object)((LocationSoundSource)src).getPosition()) : null);
        } else if (soundSource == null) {
            obj.addProperty("type", "self");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (JsonElement)obj;
    }

    @NotNull
    public SoundSource deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        Object type;
        JsonElement obj;
        Object object;
        JsonElement jsonElement = json;
        if (jsonElement == null || (jsonElement = jsonElement.getAsJsonObject()) == null) {
            jsonElement = new JsonObject();
        }
        if ((object = (obj = jsonElement).get("type")) == null || (object = object.getAsString()) == null) {
            object = "self";
        }
        return switch (type = object) {
            case "self" -> SelfSoundSource.INSTANCE;
            case "emitter" -> {
                Object v3 = obj.get("entryId");
                if (v3 == null || (v3 = v3.getAsString()) == null) {
                    v3 = "";
                }
                Object value = v3;
                yield new EmitterSoundSource((String)value);
            }
            case "location" -> {
                Object v4 = context;
                if (v4 == null || (v4 = (Position)v4.deserialize(obj.get("location"), (Type)((Object)Position.class))) == null) {
                    throw new JsonParseException("Invalid location for LocationSoundSource");
                }
                Object position = v4;
                yield new LocationSoundSource((Position)position);
            }
            default -> throw new JsonParseException("Invalid sound source type: " + (String)type);
        };
    }
}

