/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.loader.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.serialization.DataSerializer;
import com.typewritermc.core.utils.Generic;
import com.typewritermc.engine.paper.entry.entries.BackedVar;
import com.typewritermc.engine.paper.entry.entries.ComputeVar;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.MappedVar;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/typewritermc/engine/paper/loader/serializers/VarSerializer;", "Lcom/typewritermc/core/serialization/DataSerializer;", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "<init>", "()V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "engine-paper"})
public final class VarSerializer
implements DataSerializer<Var<?>> {
    @NotNull
    private final Class<?> type = Var.class;

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @NotNull
    public JsonElement serialize(@NotNull Var<?> src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Var<?> var = src;
        if (var instanceof ConstVar) {
            JsonElement jsonElement = context.serialize(((ConstVar)src).getValue());
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"serialize(...)");
            return jsonElement;
        }
        if (var instanceof BackedVar) {
            JsonObject obj = new JsonObject();
            obj.addProperty("_kind", "backed");
            obj.add("ref", context.serialize(((BackedVar)src).getRef()));
            obj.add("data", context.serialize((Object)((BackedVar)src).getData()));
            return (JsonElement)obj;
        }
        if (var instanceof MappedVar) {
            throw new IllegalStateException("Could not serialize mapped var");
        }
        if (var instanceof ComputeVar) {
            throw new IllegalStateException("Could not serialize compute var");
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Var<?> deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = typeOfT instanceof ParameterizedType ? (Type[])typeOfT : null;
        if (object == null || (object = object.getActualTypeArguments()) == null || (object = object[0]) == null) {
            throw new IllegalArgumentException("Could not find actual type for Var");
        }
        Object object2 = object;
        Object object3 = object2;
        if (object3 instanceof Class) {
            clazz = (Class)object2;
        } else {
            if (!(object3 instanceof ParameterizedType)) throw new IllegalArgumentException("Actual type for Var must be a class but was " + Reflection.getOrCreateKotlinClass(this.getType().getClass()).getQualifiedName());
            Type type = ((ParameterizedType)object2).getRawType();
            if (!(type instanceof Class)) throw new IllegalArgumentException("Actual type for Var must be a class but was " + Reflection.getOrCreateKotlinClass(type.getClass()).getQualifiedName());
            clazz = (Class)type;
        }
        Class clazz2 = clazz;
        if (!json.isJsonObject()) {
            Object object4 = context.deserialize(json, (Type)object2);
            if (object4 == null) {
                return null;
            }
            Object object5 = object4;
            return new ConstVar<Object>(object5);
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (!jsonObject.has("_kind") || !Intrinsics.areEqual((Object)jsonObject.get("_kind").getAsString(), (Object)"backed")) {
            Object object6 = context.deserialize(json, (Type)object2);
            if (object6 == null) {
                return null;
            }
            Object value = object6;
            return new ConstVar<Object>(value);
        }
        String refId = jsonObject.getAsJsonPrimitive("ref").getAsString();
        JsonElement data = jsonObject.get("data");
        Intrinsics.checkNotNull((Object)refId);
        Ref<VariableEntry> ref2 = new Ref<VariableEntry>(refId, Reflection.getOrCreateKotlinClass(VariableEntry.class), null, 4, null);
        Intrinsics.checkNotNull((Object)data);
        return new BackedVar(ref2, new Generic(data), JvmClassMappingKt.getKotlinClass((Class)clazz2));
    }
}

