/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.VectorKt;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.utils.BlockIterator;
import com.typewritermc.engine.paper.utils.BlockPhysicsKt;
import com.typewritermc.engine.paper.utils.BukkitBlockGetter;
import com.typewritermc.engine.paper.utils.PhysicsResult;
import com.typewritermc.engine.paper.utils.Shape;
import com.typewritermc.engine.paper.utils.SweepResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JE\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018JE\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bJE\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bJF\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010#\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J0\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u001fH\u0002J%\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/typewritermc/engine/paper/utils/BlockCollision;", "", "<init>", "()V", "STEP_HEIGHT", "", "handlePhysics", "Lcom/typewritermc/engine/paper/utils/PhysicsResult;", "boundingBox", "Lorg/bukkit/util/BoundingBox;", "velocity", "Lcom/typewritermc/core/utils/point/Vector;", "entityPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "getter", "Lcom/typewritermc/engine/paper/utils/BukkitBlockGetter;", "singleCollision", "", "stepPhysics", "computePhysics", "allFaces", "", "finalResult", "Lcom/typewritermc/engine/paper/utils/SweepResult;", "(Lorg/bukkit/util/BoundingBox;Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;Lcom/typewritermc/engine/paper/utils/BukkitBlockGetter;[Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/engine/paper/utils/SweepResult;)Lcom/typewritermc/engine/paper/utils/PhysicsResult;", "slowPhysics", "", "(Lorg/bukkit/util/BoundingBox;Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;Lcom/typewritermc/engine/paper/utils/BukkitBlockGetter;[Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/engine/paper/utils/SweepResult;)V", "fastPhysics", "checkBoundingBox", "blockX", "", "blockY", "blockZ", "entityVelocity", "shouldCheckLower", "computeHeight", "yVelocity", "entityY", "pos", "blockPos", "calculateFaces", "queryVector", "(Lcom/typewritermc/core/utils/point/Vector;Lorg/bukkit/util/BoundingBox;)[Lcom/typewritermc/core/utils/point/Vector;", "engine-paper"})
public final class BlockCollision {
    @NotNull
    public static final BlockCollision INSTANCE = new BlockCollision();
    private static final double STEP_HEIGHT = 0.5;

    private BlockCollision() {
    }

    @NotNull
    public final PhysicsResult handlePhysics(@NotNull BoundingBox boundingBox, @NotNull Vector velocity, @NotNull PositionProperty entityPosition, @NotNull BukkitBlockGetter getter, boolean singleCollision) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Intrinsics.checkNotNullParameter((Object)entityPosition, (String)"entityPosition");
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        return this.stepPhysics(boundingBox, velocity, entityPosition, getter, singleCollision);
    }

    private final PhysicsResult stepPhysics(BoundingBox boundingBox, Vector velocity, PositionProperty entityPosition, BukkitBlockGetter getter, boolean singleCollision) {
        SweepResult finalResult = new SweepResult(0.999999, 0.0, 0.0, 0.0, 0.0, null, null);
        boolean foundCollisionX = false;
        boolean foundCollisionY = false;
        boolean foundCollisionZ = false;
        Point[] collidedPoints = new Point[3];
        Shape[] collisionShapes = new Shape[3];
        boolean hasCollided = false;
        Vector[] allFaces = this.calculateFaces(velocity, boundingBox);
        PhysicsResult result = this.computePhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        while (result.getCollisionX() || result.getCollisionY() || result.getCollisionZ()) {
            finalResult.setNormalX(0.0);
            finalResult.setNormalY(0.0);
            finalResult.setNormalZ(0.0);
            finalResult.setCollidedHeightDiff(0.0);
            if (result.getCollisionX()) {
                foundCollisionX = true;
                collisionShapes[0] = finalResult.getCollidedShape();
                collidedPoints[0] = finalResult.getCollidedPos();
                hasCollided = true;
                if (singleCollision) {
                    break;
                }
            } else if (result.getCollisionZ()) {
                foundCollisionZ = true;
                collisionShapes[2] = finalResult.getCollidedShape();
                collidedPoints[2] = finalResult.getCollidedPos();
                hasCollided = true;
                if (singleCollision) {
                    break;
                }
            } else if (result.getCollisionY()) {
                foundCollisionY = true;
                collisionShapes[1] = finalResult.getCollidedShape();
                collidedPoints[1] = finalResult.getCollidedPos();
                hasCollided = true;
                if (singleCollision) break;
            }
            if (foundCollisionX && foundCollisionY && foundCollisionZ || result.getNewVelocity().isZero()) break;
            finalResult.setRes(0.999999);
            result = this.computePhysics(boundingBox, result.getNewVelocity(), result.getNewPosition(), getter, allFaces, finalResult);
        }
        finalResult.setRes(result.getRes().getRes());
        double newDeltaX = foundCollisionX ? 0.0 : velocity.getX();
        double newDeltaY = foundCollisionY ? 0.0 : velocity.getY();
        double newDeltaZ = foundCollisionZ ? 0.0 : velocity.getZ();
        return new PhysicsResult(result.getNewPosition(), new Vector(newDeltaX, newDeltaY, newDeltaZ), newDeltaY == 0.0 && velocity.getY() < 0.0, foundCollisionX, foundCollisionY, foundCollisionZ, velocity, collidedPoints, collisionShapes, hasCollided, finalResult);
    }

    private final PhysicsResult computePhysics(BoundingBox boundingBox, Vector velocity, PositionProperty entityPosition, BukkitBlockGetter getter, Vector[] allFaces, SweepResult finalResult) {
        boolean step;
        if (velocity.getLength() < 1.0) {
            this.fastPhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        } else {
            this.slowPhysics(boundingBox, velocity, entityPosition, getter, allFaces, finalResult);
        }
        boolean collisionX = !(finalResult.getNormalX() == 0.0);
        boolean collisionY = !(finalResult.getNormalY() == 0.0);
        boolean collisionZ = !(finalResult.getNormalZ() == 0.0);
        double deltaX = finalResult.getRes() * velocity.getX();
        double deltaY = finalResult.getRes() * velocity.getY();
        double deltaZ = finalResult.getRes() * velocity.getZ();
        if (Math.abs(deltaX) < 1.0E-6) {
            deltaX = 0.0;
        }
        if (Math.abs(deltaY) < 1.0E-6) {
            deltaY = 0.0;
        }
        if (Math.abs(deltaZ) < 1.0E-6) {
            deltaZ = 0.0;
        }
        PositionProperty finalPos = entityPosition.add(deltaX, deltaY, deltaZ);
        boolean hasHorizontalOnlyCollision = (collisionX || collisionZ) && !collisionY;
        boolean bl = step = hasHorizontalOnlyCollision && finalResult.getCollidedHeightDiff() > 0.0 && finalResult.getCollidedHeightDiff() <= 0.5;
        if (step) {
            finalPos = finalPos.add(0.0, finalResult.getCollidedHeightDiff() + 1.0E-6, 0.0);
        }
        double remainingX = collisionX ? 0.0 : velocity.getX() - deltaX;
        double remainingY = collisionY || step ? 0.0 : velocity.getY() - deltaY;
        double remainingZ = collisionZ ? 0.0 : velocity.getZ() - deltaZ;
        return new PhysicsResult(finalPos, new Vector(remainingX, remainingY, remainingZ), collisionY, collisionX, collisionY, collisionZ, Vector.Companion.getZERO(), null, null, false, finalResult);
    }

    private final void slowPhysics(BoundingBox boundingBox, Vector velocity, PositionProperty entityPosition, BukkitBlockGetter getter, Vector[] allFaces, SweepResult finalResult) {
        for (Vector point : allFaces) {
            if (point == null) continue;
            BlockIterator iterator2 = new BlockIterator(VectorKt.toVector(point.add((Point)entityPosition)), velocity, 0.0, velocity.getLength());
            for (int timer = -1; iterator2.hasNext() && timer != 0; --timer) {
                Object p = iterator2.next();
                if (!this.checkBoundingBox(p.getBlockX(), p.getBlockY(), p.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult)) continue;
                timer = 3;
            }
        }
    }

    private final void fastPhysics(BoundingBox boundingBox, Vector velocity, PositionProperty entityPosition, BukkitBlockGetter getter, Vector[] allFaces, SweepResult finalResult) {
        for (Vector point : allFaces) {
            if (point == null) continue;
            Vector pointBefore = (Vector)point.add((Point)entityPosition);
            Vector pointAfter = (Vector)((Vector)point.add((Point)entityPosition)).add((Point)velocity);
            boolean needsX = !(pointBefore.getX() == pointAfter.getX());
            boolean needsY = !(pointBefore.getY() == pointAfter.getY());
            boolean needsZ = !(pointBefore.getZ() == pointAfter.getZ());
            this.checkBoundingBox(pointBefore.getBlockX(), pointBefore.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
            if (needsX && needsY && needsZ) {
                this.checkBoundingBox(pointAfter.getBlockX(), pointAfter.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointAfter.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX && needsY) {
                this.checkBoundingBox(pointAfter.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX && needsZ) {
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsY && needsZ) {
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                this.checkBoundingBox(pointBefore.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsX) {
                this.checkBoundingBox(pointAfter.getBlockX(), pointBefore.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (needsY) {
                this.checkBoundingBox(pointBefore.getBlockX(), pointAfter.getBlockY(), pointBefore.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
                continue;
            }
            if (!needsZ) continue;
            this.checkBoundingBox(pointBefore.getBlockX(), pointBefore.getBlockY(), pointAfter.getBlockZ(), velocity, entityPosition, boundingBox, getter, finalResult);
        }
    }

    public final boolean checkBoundingBox(int blockX, int blockY, int blockZ, @NotNull Vector entityVelocity, @NotNull PositionProperty entityPosition, @NotNull BoundingBox boundingBox, @NotNull BukkitBlockGetter getter, @NotNull SweepResult finalResult) {
        boolean currentShort;
        Intrinsics.checkNotNullParameter((Object)entityVelocity, (String)"entityVelocity");
        Intrinsics.checkNotNullParameter((Object)entityPosition, (String)"entityPosition");
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        Intrinsics.checkNotNullParameter((Object)finalResult, (String)"finalResult");
        Block currentBlock = getter.getBlock(blockX, blockY, blockZ);
        Shape currentShape = BlockPhysicsKt.collisionShape(currentBlock);
        boolean currentCollidable = !currentShape.relativeEnd().isZero();
        boolean bl = currentShort = currentShape.relativeEnd().getY() < 0.5;
        if (currentShort && this.shouldCheckLower(entityVelocity, entityPosition, blockX, blockY, blockZ)) {
            Vector belowPos = new Vector(blockX, blockY - 1, blockZ);
            Block belowBlock = getter.getBlock(belowPos);
            Shape belowShape = BlockPhysicsKt.collisionShape(belowBlock);
            Vector currentPos = new Vector(blockX, blockY, blockZ);
            return belowShape.relativeEnd().getY() > 1.0 ? belowShape.intersectBoxSwept(entityPosition, entityVelocity, belowPos, boundingBox, finalResult) || currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, currentPos, boundingBox, finalResult) : currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, currentPos, boundingBox, finalResult);
        }
        if (currentCollidable && currentShape.intersectBoxSwept(entityPosition, entityVelocity, new Vector(blockX, blockY, blockZ), boundingBox, finalResult)) {
            Vector belowPos;
            Block belowBlock;
            Shape belowShape;
            if (currentShort && (belowShape = BlockPhysicsKt.collisionShape(belowBlock = getter.getBlock(belowPos = new Vector(blockX, blockY - 1, blockZ)))).relativeEnd().getY() > 1.0) {
                belowShape.intersectBoxSwept(entityPosition, entityVelocity, belowPos, boundingBox, finalResult);
            }
            return true;
        }
        return false;
    }

    private final boolean shouldCheckLower(Vector entityVelocity, PositionProperty entityPosition, int blockX, int blockY, int blockZ) {
        double yVelocity = entityVelocity.getY();
        if (yVelocity == 0.0) {
            return (int)entityPosition.getY() == blockY;
        }
        double xVelocity = entityVelocity.getX();
        double zVelocity = entityVelocity.getZ();
        if (xVelocity == 0.0 && zVelocity == 0.0) {
            return yVelocity < 0.0 && blockY == (int)(entityPosition.getY() + yVelocity);
        }
        boolean underYX = !(xVelocity == 0.0) && this.computeHeight(yVelocity, xVelocity, entityPosition.getY(), entityPosition.getX(), blockX) >= (double)blockY;
        boolean underYZ = !(zVelocity == 0.0) && this.computeHeight(yVelocity, zVelocity, entityPosition.getY(), entityPosition.getZ(), blockZ) >= (double)blockY;
        return underYX && underYZ;
    }

    private final double computeHeight(double yVelocity, double velocity, double entityY, double pos, int blockPos) {
        double m = yVelocity / velocity;
        return m * ((double)blockPos - pos + (double)(m > 0.0 ? 1 : 0)) + entityY;
    }

    private final Vector[] calculateFaces(Vector queryVector, BoundingBox boundingBox) {
        int i;
        int queryX = (int)Math.signum(queryVector.getX());
        int queryY = (int)Math.signum(queryVector.getY());
        int queryZ = (int)Math.signum(queryVector.getZ());
        int ceilWidth = (int)Math.ceil(boundingBox.getWidthX());
        int ceilHeight = (int)Math.ceil(boundingBox.getHeight());
        int ceilDepth = (int)Math.ceil(boundingBox.getWidthZ());
        Vector[] facePoints = null;
        BlockCollision $this$calculateFaces_u24lambda_u240 = this;
        boolean bl = false;
        int ceilX = ceilWidth + 1;
        int ceilY = ceilHeight + 1;
        int ceilZ = ceilDepth + 1;
        int pointCount = 0;
        if (queryX != 0) {
            pointCount += ceilY * ceilZ;
        }
        if (queryY != 0) {
            pointCount += ceilX * ceilZ;
        }
        if (queryZ != 0) {
            pointCount += ceilX * ceilY;
        }
        if (queryX != 0 && queryY != 0 && queryZ != 0) {
            pointCount -= ceilX + ceilY + ceilZ;
            ++pointCount;
        } else if (queryX != 0 && queryY != 0) {
            pointCount -= ceilZ;
        } else if (queryY != 0 && queryZ != 0) {
            pointCount -= ceilX;
        } else if (queryX != 0 && queryZ != 0) {
            pointCount -= ceilY;
        }
        facePoints = new Vector[pointCount];
        int insertIndex = 0;
        if (queryX != 0) {
            int i2;
            int startIOffset = 0;
            int endIOffset = 0;
            int startJOffset = 0;
            int endJOffset = 0;
            if (queryY < 0) {
                startJOffset = 1;
            }
            if (queryY > 0) {
                endJOffset = 1;
            }
            if (queryZ < 0) {
                startIOffset = 1;
            }
            if (queryZ > 0) {
                endIOffset = 1;
            }
            if ((i2 = startIOffset) <= (pointCount = ceilDepth - endIOffset)) {
                while (true) {
                    int n;
                    int j;
                    if ((j = startJOffset) <= (n = ceilHeight - endJOffset)) {
                        while (true) {
                            double cellK;
                            double cellI = i2;
                            double cellJ = j;
                            double d = cellK = queryX < 0 ? 0.0 : boundingBox.getWidthX();
                            if ((double)i2 >= boundingBox.getWidthZ()) {
                                cellI = boundingBox.getWidthZ();
                            }
                            if ((double)j >= boundingBox.getHeight()) {
                                cellJ = boundingBox.getHeight();
                            }
                            facePoints[insertIndex++] = new Vector(cellK += boundingBox.getMinX(), cellJ += boundingBox.getMinY(), cellI += boundingBox.getMinZ());
                            if (j == n) break;
                            ++j;
                        }
                    }
                    if (i2 == pointCount) break;
                    ++i2;
                }
            }
        }
        if (queryY != 0) {
            int n;
            int i3;
            int startJOffset = 0;
            int endJOffset = 0;
            if (queryZ < 0) {
                startJOffset = 1;
            }
            if (queryZ > 0) {
                endJOffset = 1;
            }
            if ((i3 = startJOffset) <= (n = ceilDepth - endJOffset)) {
                while (true) {
                    int j;
                    if ((j = 0) <= ceilWidth) {
                        while (true) {
                            double cellK;
                            double cellI = i3;
                            double cellJ = j;
                            double d = cellK = queryY < 0 ? 0.0 : boundingBox.getHeight();
                            if ((double)i3 >= boundingBox.getWidthZ()) {
                                cellI = boundingBox.getWidthZ();
                            }
                            if ((double)j >= boundingBox.getWidthX()) {
                                cellJ = boundingBox.getWidthX();
                            }
                            facePoints[insertIndex++] = new Vector(cellJ += boundingBox.getMinX(), cellK += boundingBox.getMinY(), cellI += boundingBox.getMinZ());
                            if (j == ceilWidth) break;
                            ++j;
                        }
                    }
                    if (i3 == n) break;
                    ++i3;
                }
            }
        }
        if (queryZ != 0 && (i = 0) <= ceilHeight) {
            while (true) {
                int j;
                if ((j = 0) <= ceilWidth) {
                    while (true) {
                        double cellK;
                        double cellI = i;
                        double cellJ = j;
                        double d = cellK = queryZ < 0 ? 0.0 : boundingBox.getWidthZ();
                        if ((double)i >= boundingBox.getHeight()) {
                            cellI = boundingBox.getHeight();
                        }
                        if ((double)j >= boundingBox.getWidthX()) {
                            cellJ = boundingBox.getWidthX();
                        }
                        facePoints[insertIndex++] = new Vector(cellJ += boundingBox.getMinX(), cellI += boundingBox.getMinY(), cellK += boundingBox.getMinZ());
                        if (j == ceilWidth) break;
                        ++j;
                    }
                }
                if (i == ceilHeight) break;
                ++i;
            }
        }
        return facePoints;
    }
}

