/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Vector;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\rJ\t\u0010.\u001a\u00020\nH\u0096\u0002J\b\u0010/\u001a\u000200H\u0016J\r\u00101\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0096\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u0018\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/typewritermc/engine/paper/utils/BlockIterator;", "", "Lcom/typewritermc/core/utils/point/Point;", "start", "Lcom/typewritermc/core/utils/point/Vector;", "direction", "yOffset", "", "maxDistance", "smooth", "", "<init>", "(Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/core/utils/point/Vector;DDZ)V", "(Lcom/typewritermc/core/utils/point/Vector;Lcom/typewritermc/core/utils/point/Vector;DD)V", "signums", "", "end", "foundEnd", "sideDistX", "getSideDistX", "()D", "setSideDistX", "(D)V", "sideDistY", "getSideDistY", "setSideDistY", "sideDistZ", "getSideDistZ", "setSideDistZ", "deltaDistX", "deltaDistY", "deltaDistZ", "mapX", "", "getMapX", "()I", "setMapX", "(I)V", "mapY", "getMapY", "setMapY", "mapZ", "getMapZ", "setMapZ", "extraPoints", "Lkotlin/collections/ArrayDeque;", "hasNext", "remove", "", "next", "engine-paper"})
public final class BlockIterator
implements Iterator<Point<?>>,
KMutableIterator {
    @NotNull
    private final short[] signums;
    @Nullable
    private Vector end;
    private final boolean smooth;
    private boolean foundEnd;
    private double sideDistX;
    private double sideDistY;
    private double sideDistZ;
    private final double deltaDistX;
    private final double deltaDistY;
    private final double deltaDistZ;
    private int mapX;
    private int mapY;
    private int mapZ;
    @NotNull
    private final ArrayDeque<Point<?>> extraPoints;

    public BlockIterator(@NotNull Vector start, @NotNull Vector direction, double yOffset, double maxDistance, boolean smooth) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.signums = new short[3];
        this.extraPoints = new ArrayDeque();
        Vector start2 = start;
        start2 = start2.add(0.0, yOffset, 0.0);
        Vector vector = this.end = !(maxDistance == 0.0) ? (Vector)start2.add(direction.normalize().mul(maxDistance)) : null;
        if (direction.isZero()) {
            this.foundEnd = true;
        }
        this.smooth = smooth;
        Vector ray = direction.normalize();
        this.mapX = start2.getBlockX();
        this.mapY = start2.getBlockY();
        this.mapZ = start2.getBlockZ();
        this.signums[0] = (short)Math.signum(direction.getX());
        this.signums[1] = (short)Math.signum(direction.getY());
        this.signums[2] = (short)Math.signum(direction.getZ());
        this.deltaDistX = ray.getX() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.getX());
        this.deltaDistY = ray.getY() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.getY());
        double d = this.deltaDistZ = ray.getZ() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.getZ());
        double d2 = ray.getX() < 0.0 ? (start2.getX() - (double)this.mapX) * this.deltaDistX : (this.sideDistX = ray.getX() > 0.0 ? ((double)(this.mapX + this.signums[0]) - start2.getX()) * this.deltaDistX : Double.MAX_VALUE);
        double d3 = ray.getY() < 0.0 ? (start2.getY() - (double)this.mapY) * this.deltaDistY : (this.sideDistY = ray.getY() > 0.0 ? ((double)(this.mapY + this.signums[1]) - start2.getY()) * this.deltaDistY : Double.MAX_VALUE);
        this.sideDistZ = ray.getZ() < 0.0 ? (start2.getZ() - (double)this.mapZ) * this.deltaDistZ : (ray.getZ() > 0.0 ? ((double)(this.mapZ + this.signums[2]) - start2.getZ()) * this.deltaDistZ : Double.MAX_VALUE);
    }

    public final double getSideDistX() {
        return this.sideDistX;
    }

    public final void setSideDistX(double d) {
        this.sideDistX = d;
    }

    public final double getSideDistY() {
        return this.sideDistY;
    }

    public final void setSideDistY(double d) {
        this.sideDistY = d;
    }

    public final double getSideDistZ() {
        return this.sideDistZ;
    }

    public final void setSideDistZ(double d) {
        this.sideDistZ = d;
    }

    public final int getMapX() {
        return this.mapX;
    }

    public final void setMapX(int n) {
        this.mapX = n;
    }

    public final int getMapY() {
        return this.mapY;
    }

    public final void setMapY(int n) {
        this.mapY = n;
    }

    public final int getMapZ() {
        return this.mapZ;
    }

    public final void setMapZ(int n) {
        this.mapZ = n;
    }

    public BlockIterator(@NotNull Vector start, @NotNull Vector direction, double yOffset, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this(start, direction, yOffset, maxDistance, false);
    }

    @Override
    public boolean hasNext() {
        return !this.foundEnd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("[BlockIterator] doesn't support block removal");
    }

    @Override
    @NotNull
    public Point<?> next() {
        boolean needsZ;
        double closest;
        if (this.foundEnd) {
            throw new NoSuchElementException();
        }
        if (!this.extraPoints.isEmpty()) {
            Point res = (Point)this.extraPoints.removeFirst();
            if (this.end != null) {
                Vector vector = this.end;
                Intrinsics.checkNotNull((Object)vector);
                if (res.sameBlock(vector)) {
                    this.foundEnd = true;
                }
            }
            return res;
        }
        Vector current = new Vector(this.mapX, this.mapY, this.mapZ);
        if (this.end != null) {
            Vector vector = this.end;
            Intrinsics.checkNotNull((Object)vector);
            if (current.sameBlock(vector)) {
                this.foundEnd = true;
            }
        }
        boolean needsX = this.sideDistX - (closest = Math.min(this.sideDistX, Math.min(this.sideDistY, this.sideDistZ))) < 1.0E-10 && this.signums[0] != 0;
        boolean needsY = this.sideDistY - closest < 1.0E-10 && this.signums[1] != 0;
        boolean bl = needsZ = this.sideDistZ - closest < 1.0E-10 && this.signums[2] != 0;
        if (needsZ) {
            this.sideDistZ += this.deltaDistZ;
            this.mapZ += this.signums[2];
        }
        if (needsX) {
            this.sideDistX += this.deltaDistX;
            this.mapX += this.signums[0];
        }
        if (needsY) {
            this.sideDistY += this.deltaDistY;
            this.mapY += this.signums[1];
        }
        if (needsX && needsY && needsZ) {
            this.extraPoints.add((Object)new Vector((double)this.signums[0] + current.getX(), (double)this.signums[1] + current.getY(), current.getZ()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add((Object)new Vector(current.getX(), (double)this.signums[1] + current.getY(), (double)this.signums[2] + current.getZ()));
            this.extraPoints.add((Object)new Vector((double)this.signums[0] + current.getX(), current.getY(), (double)this.signums[2] + current.getZ()));
            this.extraPoints.add((Object)new Vector((double)this.signums[0] + current.getX(), current.getY(), current.getZ()));
            this.extraPoints.add((Object)new Vector(current.getX(), (double)this.signums[1] + current.getY(), current.getZ()));
            this.extraPoints.add((Object)new Vector(current.getX(), current.getY(), (double)this.signums[2] + current.getZ()));
        } else if (needsX && needsY) {
            this.extraPoints.add((Object)new Vector((double)this.signums[0] + current.getX(), current.getY(), current.getZ()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add((Object)new Vector(current.getX(), (double)this.signums[1] + current.getY(), current.getZ()));
        } else if (needsX && needsZ) {
            this.extraPoints.add((Object)new Vector((double)this.signums[0] + current.getX(), current.getY(), current.getZ()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add((Object)new Vector(current.getX(), current.getY(), (double)this.signums[2] + current.getZ()));
        } else if (needsY && needsZ) {
            this.extraPoints.add((Object)new Vector(current.getX(), (double)this.signums[1] + current.getY(), current.getZ()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add((Object)new Vector(current.getX(), current.getY(), (double)this.signums[2] + current.getZ()));
        }
        return current;
    }
}

