/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.engine.paper.utils.Shape;
import com.typewritermc.engine.paper.utils.SweepResult;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016JB\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u001d\u001a\u00020\u00162\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/typewritermc/engine/paper/utils/BukkitBlockShape;", "Lcom/typewritermc/engine/paper/utils/Shape;", "block", "Lorg/bukkit/block/Block;", "<init>", "(Lorg/bukkit/block/Block;)V", "getBlock", "()Lorg/bukkit/block/Block;", "collidedShape", "Lorg/bukkit/util/VoxelShape;", "Lorg/jetbrains/annotations/NotNull;", "getCollidedShape", "()Lorg/bukkit/util/VoxelShape;", "collidedShape$delegate", "Lkotlin/Lazy;", "intersectBoxSwept", "", "rayStart", "Lcom/typewritermc/core/utils/point/Point;", "rayDirection", "shapePos", "moving", "Lorg/bukkit/util/BoundingBox;", "finalResult", "Lcom/typewritermc/engine/paper/utils/SweepResult;", "boundingBoxes", "", "relativeEnd", "boundingBoxIntersectionCheck", "collidableStatic", "staticCollidableOffset", "epsilon", "", "value", "toString", "", "engine-paper"})
public final class BukkitBlockShape
implements Shape {
    @NotNull
    private final Block block;
    @NotNull
    private final Lazy collidedShape$delegate;

    public BukkitBlockShape(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.block = block;
        this.collidedShape$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> BukkitBlockShape.collidedShape_delegate$lambda$0(this));
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    private final VoxelShape getCollidedShape() {
        Lazy lazy = this.collidedShape$delegate;
        return (VoxelShape)lazy.getValue();
    }

    @Override
    public boolean intersectBoxSwept(@NotNull Point<?> rayStart, @NotNull Point<?> rayDirection, @NotNull Point<?> shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        Intrinsics.checkNotNullParameter(rayStart, (String)"rayStart");
        Intrinsics.checkNotNullParameter(rayDirection, (String)"rayDirection");
        Intrinsics.checkNotNullParameter(shapePos, (String)"shapePos");
        Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
        Intrinsics.checkNotNullParameter((Object)finalResult, (String)"finalResult");
        boolean hitBlock = false;
        for (BoundingBox blockSection : this.getCollidedShape().getBoundingBoxes()) {
            Intrinsics.checkNotNull((Object)blockSection);
            if (!this.boundingBoxIntersectionCheck(moving, rayStart, rayDirection, blockSection, shapePos, finalResult)) continue;
            finalResult.setCollidedShape(this);
            Object collidedPos = rayStart.add((Point<?>)rayDirection.mul(finalResult.getRes()));
            finalResult.setCollidedPos((Point<?>)collidedPos);
            Object relativePos = collidedPos.sub(shapePos);
            finalResult.setCollidedHeightDiff(blockSection.getMaxY() - relativePos.getY());
            hitBlock = true;
        }
        return hitBlock;
    }

    @Override
    @NotNull
    public Collection<BoundingBox> boundingBoxes() {
        Collection collection = this.getCollidedShape().getBoundingBoxes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBoundingBoxes(...)");
        return collection;
    }

    @Override
    @NotNull
    public Point<?> relativeEnd() {
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (BoundingBox bounding : this.getCollidedShape().getBoundingBoxes()) {
            maxX = Math.max(maxX, bounding.getMaxX());
            maxY = Math.max(maxY, bounding.getMaxY());
            maxZ = Math.max(maxZ, bounding.getMaxZ());
        }
        return new Vector(maxX, maxY, maxZ);
    }

    public final boolean boundingBoxIntersectionCheck(@NotNull BoundingBox moving, @NotNull Point<?> rayStart, @NotNull Point<?> rayDirection, @NotNull BoundingBox collidableStatic, @NotNull Point<?> staticCollidableOffset, @NotNull SweepResult finalResult) {
        double ziy;
        double xiy;
        double yFac;
        double yiz;
        double xiz;
        double zFac;
        double zix;
        double yix;
        double xFac;
        Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
        Intrinsics.checkNotNullParameter(rayStart, (String)"rayStart");
        Intrinsics.checkNotNullParameter(rayDirection, (String)"rayDirection");
        Intrinsics.checkNotNullParameter((Object)collidableStatic, (String)"collidableStatic");
        Intrinsics.checkNotNullParameter(staticCollidableOffset, (String)"staticCollidableOffset");
        Intrinsics.checkNotNullParameter((Object)finalResult, (String)"finalResult");
        Point bbCentre = new Vector(moving.getMinX() + moving.getWidthX() / (double)2, moving.getMinY() + moving.getHeight() / (double)2, moving.getMinZ() + moving.getWidthZ() / (double)2);
        Object rayCentre = rayStart.add(bbCentre);
        Vector bbOffMin = new Vector(collidableStatic.getMinX() - rayCentre.getX() + staticCollidableOffset.getX() - moving.getWidthX() / (double)2, collidableStatic.getMinY() - rayCentre.getY() + staticCollidableOffset.getY() - moving.getHeight() / (double)2, collidableStatic.getMinZ() - rayCentre.getZ() + staticCollidableOffset.getZ() - moving.getWidthZ() / (double)2);
        Vector bbOffMax = new Vector(collidableStatic.getMaxX() - rayCentre.getX() + staticCollidableOffset.getX() + moving.getWidthX() / (double)2, collidableStatic.getMaxY() - rayCentre.getY() + staticCollidableOffset.getY() + moving.getHeight() / (double)2, collidableStatic.getMaxZ() - rayCentre.getZ() + staticCollidableOffset.getZ() + moving.getWidthZ() / (double)2);
        double signumRayX = Math.signum(rayDirection.getX());
        double signumRayY = Math.signum(rayDirection.getY());
        double signumRayZ = Math.signum(rayDirection.getZ());
        boolean isHit = false;
        double percentage = Double.MAX_VALUE;
        int collisionFace = -1;
        if (rayDirection.getX() > 0.0 && (xFac = this.epsilon(bbOffMin.getX() / rayDirection.getX())) < percentage) {
            yix = rayDirection.getY() * xFac + rayCentre.getY();
            zix = rayDirection.getZ() * xFac + rayCentre.getZ();
            if ((yix - rayCentre.getY()) * signumRayY >= 0.0 && (zix - rayCentre.getZ()) * signumRayZ >= 0.0 && yix >= collidableStatic.getMinY() + staticCollidableOffset.getY() - moving.getHeight() / (double)2 && yix <= collidableStatic.getMaxY() + staticCollidableOffset.getY() + moving.getHeight() / (double)2 && zix >= collidableStatic.getMinZ() + staticCollidableOffset.getZ() - moving.getWidthZ() / (double)2 && zix <= collidableStatic.getMaxZ() + staticCollidableOffset.getZ() + moving.getWidthZ() / (double)2) {
                isHit = true;
                percentage = xFac;
                collisionFace = 0;
            }
        }
        if (rayDirection.getX() < 0.0 && (xFac = this.epsilon(bbOffMax.getX() / rayDirection.getX())) < percentage) {
            yix = rayDirection.getY() * xFac + rayCentre.getY();
            zix = rayDirection.getZ() * xFac + rayCentre.getZ();
            if ((yix - rayCentre.getY()) * signumRayY >= 0.0 && (zix - rayCentre.getZ()) * signumRayZ >= 0.0 && yix >= collidableStatic.getMinY() + staticCollidableOffset.getY() - moving.getHeight() / (double)2 && yix <= collidableStatic.getMaxY() + staticCollidableOffset.getY() + moving.getHeight() / (double)2 && zix >= collidableStatic.getMinZ() + staticCollidableOffset.getZ() - moving.getWidthZ() / (double)2 && zix <= collidableStatic.getMaxZ() + staticCollidableOffset.getZ() + moving.getWidthZ() / (double)2) {
                isHit = true;
                percentage = xFac;
                collisionFace = 0;
            }
        }
        if (rayDirection.getZ() > 0.0 && (zFac = this.epsilon(bbOffMin.getZ() / rayDirection.getZ())) < percentage) {
            xiz = rayDirection.getX() * zFac + rayCentre.getX();
            yiz = rayDirection.getY() * zFac + rayCentre.getY();
            if ((yiz - rayCentre.getY()) * signumRayY >= 0.0 && (xiz - rayCentre.getX()) * signumRayX >= 0.0 && xiz >= collidableStatic.getMinX() + staticCollidableOffset.getX() - moving.getWidthX() / (double)2 && xiz <= collidableStatic.getMaxX() + staticCollidableOffset.getX() + moving.getWidthX() / (double)2 && yiz >= collidableStatic.getMinY() + staticCollidableOffset.getY() - moving.getHeight() / (double)2 && yiz <= collidableStatic.getMaxY() + staticCollidableOffset.getY() + moving.getHeight() / (double)2) {
                isHit = true;
                percentage = zFac;
                collisionFace = 1;
            }
        }
        if (rayDirection.getZ() < 0.0 && (zFac = this.epsilon(bbOffMax.getZ() / rayDirection.getZ())) < percentage) {
            xiz = rayDirection.getX() * zFac + rayCentre.getX();
            yiz = rayDirection.getY() * zFac + rayCentre.getY();
            if ((yiz - rayCentre.getY()) * signumRayY >= 0.0 && (xiz - rayCentre.getX()) * signumRayX >= 0.0 && xiz >= collidableStatic.getMinX() + staticCollidableOffset.getX() - moving.getWidthX() / (double)2 && xiz <= collidableStatic.getMaxX() + staticCollidableOffset.getX() + moving.getWidthX() / (double)2 && yiz >= collidableStatic.getMinY() + staticCollidableOffset.getY() - moving.getHeight() / (double)2 && yiz <= collidableStatic.getMaxY() + staticCollidableOffset.getY() + moving.getHeight() / (double)2) {
                isHit = true;
                percentage = zFac;
                collisionFace = 1;
            }
        }
        if (rayDirection.getY() > 0.0 && (yFac = this.epsilon(bbOffMin.getY() / rayDirection.getY())) < percentage) {
            xiy = rayDirection.getX() * yFac + rayCentre.getX();
            ziy = rayDirection.getZ() * yFac + rayCentre.getZ();
            if ((ziy - rayCentre.getZ()) * signumRayZ >= 0.0 && (xiy - rayCentre.getX()) * signumRayX >= 0.0 && xiy >= collidableStatic.getMinX() + staticCollidableOffset.getX() - moving.getWidthX() / 0.0 && xiy <= collidableStatic.getMaxX() + staticCollidableOffset.getX() + moving.getWidthX() / (double)2 && ziy >= collidableStatic.getMinZ() + staticCollidableOffset.getZ() - moving.getWidthZ() / (double)2 && ziy <= collidableStatic.getMaxZ() + staticCollidableOffset.getZ() + moving.getWidthZ() / (double)2) {
                isHit = true;
                percentage = yFac;
                collisionFace = 2;
            }
        }
        if (rayDirection.getY() < 0.0 && (yFac = this.epsilon(bbOffMax.getY() / rayDirection.getY())) < percentage) {
            xiy = rayDirection.getX() * yFac + rayCentre.getX();
            ziy = rayDirection.getZ() * yFac + rayCentre.getZ();
            if ((ziy - rayCentre.getZ()) * signumRayZ >= 0.0 && (xiy - rayCentre.getX()) * signumRayX >= 0.0 && xiy >= collidableStatic.getMinX() + staticCollidableOffset.getX() - moving.getWidthX() / (double)2 && xiy <= collidableStatic.getMaxX() + staticCollidableOffset.getX() + moving.getWidthX() / (double)2 && ziy >= collidableStatic.getMinZ() + staticCollidableOffset.getZ() - moving.getWidthZ() / (double)2 && ziy <= collidableStatic.getMaxZ() + staticCollidableOffset.getZ() + moving.getWidthZ() / (double)2) {
                isHit = true;
                percentage = yFac;
                collisionFace = 2;
            }
        }
        percentage *= 0.99999;
        if (isHit && percentage >= 0.0 && percentage <= finalResult.getRes()) {
            finalResult.setRes(percentage);
            finalResult.setNormalX(0.0);
            finalResult.setNormalY(0.0);
            finalResult.setNormalZ(0.0);
            if (collisionFace == 0) {
                finalResult.setNormalX(1.0);
            }
            if (collisionFace == 1) {
                finalResult.setNormalZ(1.0);
            }
            if (collisionFace == 2) {
                finalResult.setNormalY(1.0);
            }
            return true;
        }
        return false;
    }

    private final double epsilon(double value) {
        return Math.abs(value) < 1.0E-6 ? 0.0 : value;
    }

    @NotNull
    public String toString() {
        return "BukkitBlockShape{block=" + this.block + "}";
    }

    private static final VoxelShape collidedShape_delegate$lambda$0(BukkitBlockShape this$0) {
        return this$0.block.getCollisionShape();
    }
}

