/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/typewritermc/engine/paper/utils/DurationParser;", "", "<init>", "()V", "durationRE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "millisecond", "", "second", "minute", "hour", "day", "week", "month", "year", "unitRatio", "str", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parse", "Lkotlin/time/Duration;", "string", "parse-5sfh64U", "(Ljava/lang/String;)J", "engine-paper"})
public final class DurationParser {
    @NotNull
    public static final DurationParser INSTANCE = new DurationParser();
    private static final Pattern durationRE = Pattern.compile("(-?(?:\\d+\\.?\\d*|\\d*\\.?\\d+)(?:e[-+]?\\d+)?)\\s*(\\p{L}*)", 2);
    private static final long millisecond = 1L;
    private static final long second = 1000L;
    private static final long minute = 60000L;
    private static final long hour = 3600000L;
    private static final long day = 86400000L;
    private static final long week = 604800000L;
    private static final long month = 2592000000L;
    private static final long year = 31536000000L;

    private DurationParser() {
    }

    private final Long unitRatio(String str) {
        return switch (str) {
            case "ms", "millisecond" -> 1L;
            case "second", "sec", "s" -> 1000L;
            case "m", "minute", "min" -> 60000L;
            case "h", "hr", "hour" -> 3600000L;
            case "d", "day" -> 86400000L;
            case "week", "wk", "w" -> 604800000L;
            case "b", "month" -> 2592000000L;
            case "year", "yr", "y" -> 31536000000L;
            default -> null;
        };
    }

    public final long parse-5sfh64U(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        long result = 0L;
        CharSequence charSequence = string;
        Regex regex = new Regex("(\\d)[,_](\\d)");
        String string2 = "$1$2";
        String parsable = regex.replace(charSequence, string2);
        Matcher matcher = durationRE.matcher(parsable);
        while (matcher.find()) {
            Long units;
            String n = matcher.group(1);
            String string3 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            Long l = this.unitRatio(string3);
            if (l == null) {
                String string4 = matcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                CharSequence charSequence2 = string4;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string5 = charSequence2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                charSequence2 = string5;
                Regex regex2 = new Regex("s$");
                String string6 = "";
                l = this.unitRatio(regex2.replace(charSequence2, string6));
            }
            if ((units = l) == null) continue;
            Intrinsics.checkNotNull((Object)n);
            result += Long.parseLong(n) * units;
        }
        return DurationKt.toDuration((long)result, (DurationUnit)DurationUnit.MILLISECONDS);
    }
}

