/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.retrooper.packetevents.protocol.color.Color;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002\u001a!\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t*\u0004\u0018\u0001H\t2\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000b\u001a\"\u0010\f\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t*\u00020\u00052\u0006\u0010\r\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\u001a\u0015\u0010\u0012\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u001a0\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001c\u001a\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u0014*\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 \u001a\r\u0010$\u001a\u00020\u0014*\u00020\u001fH\u0086\u0002\u001a\r\u0010%\u001a\u00020\u0014*\u00020\u001fH\u0086\u0002\u001a\r\u0010&\u001a\u00020\u0014*\u00020\u001fH\u0086\u0002\u001a\n\u0010'\u001a\u00020(*\u00020)\u001a\u0012\u0010*\u001a\u00020\u0014*\u00020\u00142\u0006\u0010+\u001a\u00020,\u001a\u0012\u0010*\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010+\u001a\u00020,\u001a\n\u0010B\u001a\u00020;*\u00020;\u001a\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0003H\u0002\u001a\u0012\u0010I\u001a\u00020\u0016*\u00020J2\u0006\u0010H\u001a\u00020\u0003\u001a\u0011\u0010K\u001a\u0004\u0018\u00010\u0014*\u00020\u0003\u00a2\u0006\u0002\u0010L\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010!\u001a\u00020\u001f*\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0015\u0010-\u001a\u00020,*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00100\u001a\u00020,*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\"-\u00103\u001a\b\u0012\u0004\u0012\u0002H\t04\"\b\b\u0000\u0010\t*\u000205*\n\u0012\u0004\u0012\u0002H\t\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"'\u00103\u001a\b\u0012\u0004\u0012\u0002H\t04\"\b\b\u0000\u0010\t*\u000205*\u0004\u0018\u0001H\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u00108\",\u0010:\u001a\u0004\u0018\u00010\u0003*\u00020;2\b\u00109\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\",\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020;2\b\u00109\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010=\"\u0004\bA\u0010?\"\u0016\u0010C\u001a\n E*\u0004\u0018\u00010D0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"get", "Ljava/io/File;", "name", "", "isLookable", "", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)Z", "logErrorIfNull", "T", "message", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "then", "t", "(ZLjava/lang/Object;)Ljava/lang/Object;", "toTicks", "", "Ljava/time/Duration;", "times", "other", "", "playSound", "", "Lnet/kyori/adventure/audience/Audience;", "sound", "source", "Lnet/kyori/adventure/sound/Sound$Source;", "volume", "", "pitch", "distanceSqrt", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;Lorg/bukkit/Location;)Ljava/lang/Double;", "up", "getUp", "(Lorg/bukkit/Location;)Lorg/bukkit/Location;", "component1", "component2", "component3", "toPacketColor", "Lcom/github/retrooper/packetevents/protocol/color/Color;", "Lorg/bukkit/Color;", "round", "decimals", "", "digits", "getDigits", "(I)I", "lineCount", "getLineCount", "(Ljava/lang/String;)I", "optional", "Ljava/util/Optional;", "", "getOptional", "(Ljava/util/Optional;)Ljava/util/Optional;", "(Ljava/lang/Object;)Ljava/util/Optional;", "value", "loreString", "Lorg/bukkit/inventory/meta/ItemMeta;", "getLoreString", "(Lorg/bukkit/inventory/meta/ItemMeta;)Ljava/lang/String;", "setLoreString", "(Lorg/bukkit/inventory/meta/ItemMeta;Ljava/lang/String;)V", "getName", "setName", "unClickable", "RANDOM_UUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getProfile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "url", "applySkinUrl", "Lorg/bukkit/inventory/meta/SkullMeta;", "parseDoubleFlexible", "(Ljava/lang/String;)Ljava/lang/Double;", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/typewritermc/engine/paper/utils/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1#2:205\n1104#3,3:206\n1104#3,3:213\n1104#3,3:216\n1563#4:209\n1634#4,3:210\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/typewritermc/engine/paper/utils/ExtensionsKt\n*L\n95#1:206,3\n168#1:213,3\n185#1:216,3\n103#1:209\n103#1:210,3\n*E\n"})
public final class ExtensionsKt {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    @NotNull
    public static final File get(@NotNull File $this$get, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File($this$get, name);
    }

    public static final boolean isLookable(@NotNull Player $this$isLookable) {
        Intrinsics.checkNotNullParameter((Object)$this$isLookable, (String)"<this>");
        return $this$isLookable.isValid() && $this$isLookable.getGameMode() != GameMode.SPECTATOR && !$this$isLookable.isInvisible();
    }

    @Nullable
    public static final <T> T logErrorIfNull(@Nullable T $this$logErrorIfNull, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if ($this$logErrorIfNull == null) {
            TypewriterPaperPluginKt.getLogger().severe(message);
        }
        return $this$logErrorIfNull;
    }

    @Nullable
    public static final <T> T then(boolean $this$then, T t) {
        return (T)($this$then ? t : null);
    }

    public static final long toTicks(@NotNull Duration $this$toTicks) {
        Intrinsics.checkNotNullParameter((Object)$this$toTicks, (String)"<this>");
        return $this$toTicks.toMillis() / ServerExtensionsKt.getTICK_MS();
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, double other) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Duration duration = Duration.ofMillis(MathKt.roundToLong((double)((double)$this$times.toMillis() * other)));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    public static final void playSound(@NotNull Audience $this$playSound, @NotNull String sound, @NotNull Sound.Source source, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)$this$playSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        $this$playSound.playSound(Sound.sound((Key)Key.key((String)sound), (Sound.Source)source, (float)volume, (float)pitch));
    }

    public static /* synthetic */ void playSound$default(Audience audience, String string, Sound.Source source, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            source = Sound.Source.MASTER;
        }
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        if ((n & 8) != 0) {
            f2 = 1.0f;
        }
        ExtensionsKt.playSound(audience, string, source, f, f2);
    }

    @Nullable
    public static final Double distanceSqrt(@NotNull Location $this$distanceSqrt, @NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceSqrt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)$this$distanceSqrt.getWorld(), (Object)other.getWorld())) {
            return null;
        }
        double dx = $this$distanceSqrt.getX() - other.getX();
        double dy = $this$distanceSqrt.getY() - other.getY();
        double dz = $this$distanceSqrt.getZ() - other.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    @NotNull
    public static final Location getUp(@NotNull Location $this$up) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)$this$up, (String)"<this>");
        Location location2 = $this$up.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        Location $this$_get_up__u24lambda_u240 = location = location2;
        boolean bl = false;
        $this$_get_up__u24lambda_u240.setY($this$_get_up__u24lambda_u240.getY() + 1.0);
        return location;
    }

    public static final double component1(@NotNull Location $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getX();
    }

    public static final double component2(@NotNull Location $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.getY();
    }

    public static final double component3(@NotNull Location $this$component3) {
        Intrinsics.checkNotNullParameter((Object)$this$component3, (String)"<this>");
        return $this$component3.getZ();
    }

    @NotNull
    public static final Color toPacketColor(@NotNull org.bukkit.Color $this$toPacketColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toPacketColor, (String)"<this>");
        return new Color($this$toPacketColor.getRed(), $this$toPacketColor.getGreen(), $this$toPacketColor.getBlue());
    }

    public static final double round(double $this$round, int decimals) {
        double multiplier = 0.0;
        multiplier = 1.0;
        int n = 0;
        while (n < decimals) {
            int it = n++;
            boolean bl = false;
            multiplier *= (double)10;
        }
        return Math.rint($this$round * multiplier) / multiplier;
    }

    public static final float round(float $this$round, int decimals) {
        double multiplier = 0.0;
        multiplier = 1.0;
        int n = 0;
        while (n < decimals) {
            int it = n++;
            boolean bl = false;
            multiplier *= (double)10;
        }
        return (float)(Math.rint((double)$this$round * multiplier) / multiplier);
    }

    public static final int getDigits(int $this$digits) {
        return $this$digits == 0 ? 1 : (int)Math.log10(Math.abs((double)$this$digits)) + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getLineCount(@NotNull String $this$lineCount) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$lineCount, (String)"<this>");
        CharSequence $this$count$iv = $this$lineCount;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return (int)(var3_3 + true);
    }

    @NotNull
    public static final <T> Optional<T> getOptional(@Nullable Optional<T> $this$optional) {
        Optional<Object> optional = $this$optional;
        Optional<Object> optional2 = Optional.ofNullable(optional != null ? optional.orElse(null) : null);
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
        return optional2;
    }

    @NotNull
    public static final <T> Optional<T> getOptional(@Nullable T $this$optional) {
        Optional<T> optional = Optional.ofNullable($this$optional);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @Nullable
    public static final String getLoreString(@NotNull ItemMeta $this$loreString) {
        Intrinsics.checkNotNullParameter((Object)$this$loreString, (String)"<this>");
        List list = $this$loreString.lore();
        return list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, ExtensionsKt::_get_loreString_$lambda$4, (int)30, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void setLoreString(@NotNull ItemMeta $this$loreString, @Nullable String value) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loreString, (String)"<this>");
        ItemMeta itemMeta = $this$loreString;
        Object object2 = value;
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(object = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = (Iterable)object2;
            ItemMeta itemMeta2 = itemMeta;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MiniMessagesKt.asMini("<!i><white>" + (String)it));
            }
            list = (List)destination$iv$iv;
            itemMeta = itemMeta2;
        } else {
            list = null;
        }
        itemMeta.lore(list);
    }

    @Nullable
    public static final String getName(@NotNull ItemMeta $this$name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        if ($this$name.hasDisplayName()) {
            Component component = $this$name.displayName();
            string = component != null ? MiniMessagesKt.asMini(component) : null;
        } else {
            string = null;
        }
        return string;
    }

    public static final void setName(@NotNull ItemMeta $this$name, @Nullable String value) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            component = MiniMessagesKt.asMini("<!i>" + value);
        } else {
            TextComponent textComponent = Component.text((String)" ");
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
            component = (Component)textComponent;
        }
        $this$name.displayName(component);
    }

    @NotNull
    public static final ItemMeta unClickable(@NotNull ItemMeta $this$unClickable) {
        Intrinsics.checkNotNullParameter((Object)$this$unClickable, (String)"<this>");
        $this$unClickable.addEnchant(Enchantment.BINDING_CURSE, 1, true);
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS};
        $this$unClickable.addItemFlags(itemFlagArray);
        return $this$unClickable;
    }

    /*
     * WARNING - void declaration
     */
    private static final PlayerProfile getProfile(String url) {
        URL uRL;
        PlayerTextures playerTextures;
        PlayerTextures textures;
        PlayerProfile playerProfile = ServerExtensionsKt.getServer().createProfile(RANDOM_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)playerProfile, (String)"createProfile(...)");
        PlayerProfile profile = playerProfile;
        PlayerTextures playerTextures2 = profile.getTextures();
        Intrinsics.checkNotNullExpressionValue((Object)playerTextures2, (String)"getTextures(...)");
        PlayerTextures playerTextures3 = textures = playerTextures2;
        try {
            playerTextures = playerTextures3;
            uRL = new URI(url).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            void exception;
            PlayerTextures playerTextures4 = playerTextures3;
            throw new RuntimeException("Invalid URL", (Throwable)exception);
        }
        playerTextures.setSkin(uRL);
        profile.setTextures(textures);
        return profile;
    }

    public static final void applySkinUrl(@NotNull SkullMeta $this$applySkinUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$applySkinUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        $this$applySkinUrl.setPlayerProfile(ExtensionsKt.getProfile(url));
    }

    @Nullable
    public static final Double parseDoubleFlexible(@NotNull String $this$parseDoubleFlexible) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$parseDoubleFlexible, (String)"<this>");
        String cleaned = ((Object)StringsKt.trim((CharSequence)$this$parseDoubleFlexible)).toString();
        if (((CharSequence)cleaned).length() == 0) {
            return null;
        }
        Double d = StringsKt.toDoubleOrNull((String)cleaned);
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            return it;
        }
        boolean hasDot = StringsKt.contains$default((CharSequence)cleaned, (char)'.', (boolean)false, (int)2, null);
        boolean hasComma = StringsKt.contains$default((CharSequence)cleaned, (char)',', (boolean)false, (int)2, null);
        if (!hasComma) {
            CharSequence $this$count$iv = cleaned;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '.')) continue;
                ++count$iv;
            }
            if (count$iv <= 1) {
                return null;
            }
        }
        if (hasDot && hasComma) {
            int lastCommaIndex;
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)cleaned, (char)'.', (int)0, (boolean)false, (int)6, null);
            string = lastDotIndex > (lastCommaIndex = StringsKt.lastIndexOf$default((CharSequence)cleaned, (char)',', (int)0, (boolean)false, (int)6, null)) ? StringsKt.replace$default((String)cleaned, (String)",", (String)"", (boolean)false, (int)4, null) : StringsKt.replace$default((String)StringsKt.replace$default((String)cleaned, (String)".", (String)"", (boolean)false, (int)4, null), (char)',', (char)'.', (boolean)false, (int)4, null);
        } else if (hasComma) {
            CharSequence $this$count$iv = cleaned;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == ',')) continue;
                ++count$iv;
            }
            string = count$iv > 1 ? StringsKt.replace$default((String)cleaned, (String)",", (String)"", (boolean)false, (int)4, null) : StringsKt.replace$default((String)cleaned, (char)',', (char)'.', (boolean)false, (int)4, null);
        } else if (hasDot) {
            string = StringsKt.replace$default((String)cleaned, (String)".", (String)"", (boolean)false, (int)4, null);
        } else {
            return null;
        }
        String normalized = string;
        return StringsKt.toDoubleOrNull((String)normalized);
    }

    private static final CharSequence _get_loreString_$lambda$4(Component it) {
        Intrinsics.checkNotNull((Object)it);
        return MiniMessagesKt.asMini(it);
    }
}

