/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/typewritermc/engine/paper/utils/ItemStackSerializer;", "Lcom/google/gson/JsonSerializer;", "Lorg/bukkit/inventory/ItemStack;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "engine-paper"})
public final class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    @NotNull
    public ItemStack deserialize(@NotNull JsonElement jsonElement, @Nullable Type type, @Nullable JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
        String data = jsonElement.getAsString();
        Intrinsics.checkNotNull((Object)data);
        if (((CharSequence)data).length() == 0) {
            return new ItemStack(Material.AIR, 0);
        }
        ItemStack itemStack = ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(data));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserializeBytes(...)");
        return itemStack;
    }

    @NotNull
    public JsonElement serialize(@NotNull ItemStack src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (src.getType() == Material.AIR) {
            return (JsonElement)new JsonPrimitive("");
        }
        return (JsonElement)new JsonPrimitive(Base64.getEncoder().encodeToString(src.serializeAsBytes()));
    }
}

