/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.typewritermc.core.utils.point.Coordinate;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.WorldHolder;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\n\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u0005\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\f\u001a3\u0010\u000f\u001a\u00020\u0010\"\"\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0005*\b\u0012\u0004\u0012\u0002H\u00110\u0012*\b\u0012\u0004\u0012\u0002H\u00110\u0013*\u0002H\u0011\u00a2\u0006\u0002\u0010\u0014\u001a?\u0010\u0015\u001a\u0004\u0018\u0001H\u0011\"\"\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0005*\b\u0012\u0004\u0012\u0002H\u00110\u0012*\b\u0012\u0004\u0012\u0002H\u00110\u0013*\u0002H\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a)\u0010\u0019\u001a\u00020\u001a\"\u0018\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u0005*\b\u0012\u0004\u0012\u0002H\u001b0\u0012*\u0002H\u001b\u00a2\u0006\u0002\u0010\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0010\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0010\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u0010\u001a1\u0010\u000f\u001a\u00020\u0010\"\u0018\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u0005*\b\u0012\u0004\u0012\u0002H\u001b0\u0012*\u0002H\u001b2\u0006\u0010!\u001a\u00020\f\u00a2\u0006\u0002\u0010\"\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u001a\u001aK\u0010'\u001a\u00020(\"\u000e\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0\u0005*\u0002H)2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u00172\b\b\u0002\u00100\u001a\u00020\u0017\u00a2\u0006\u0002\u00101\"\u0015\u0010#\u001a\u00020\u001e*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00062"}, d2={"toVector", "Lcom/typewritermc/core/utils/point/Vector;", "Lorg/bukkit/util/Vector;", "toPacketVector3f", "Lcom/github/retrooper/packetevents/util/Vector3f;", "Lcom/typewritermc/core/utils/point/Point;", "toPacketVector3d", "Lcom/github/retrooper/packetevents/util/Vector3d;", "toPacketVector3i", "Lcom/github/retrooper/packetevents/util/Vector3i;", "toBukkitVector", "toBukkitWorld", "Lorg/bukkit/World;", "Lcom/typewritermc/core/utils/point/World;", "toWorld", "toBukkitLocation", "Lorg/bukkit/Location;", "RWP", "Lcom/typewritermc/core/utils/point/Rotatable;", "Lcom/typewritermc/core/utils/point/WorldHolder;", "(Lcom/typewritermc/core/utils/point/Point;)Lorg/bukkit/Location;", "firstWalkableLocationBelow", "maxDepth", "", "(Lcom/typewritermc/core/utils/point/Point;I)Lcom/typewritermc/core/utils/point/Point;", "toPacketLocation", "Lcom/github/retrooper/packetevents/protocol/world/Location;", "RP", "(Lcom/typewritermc/core/utils/point/Point;)Lcom/github/retrooper/packetevents/protocol/world/Location;", "toPosition", "Lcom/typewritermc/core/utils/point/Position;", "toCoordinate", "Lcom/typewritermc/core/utils/point/Coordinate;", "bukkitWorld", "(Lcom/typewritermc/core/utils/point/Point;Lorg/bukkit/World;)Lorg/bukkit/Location;", "position", "Lorg/bukkit/entity/Player;", "getPosition", "(Lorg/bukkit/entity/Player;)Lcom/typewritermc/core/utils/point/Position;", "particleSphere", "", "P", "player", "radius", "", "color", "Lorg/bukkit/Color;", "phiDivisions", "thetaDivisions", "(Lcom/typewritermc/core/utils/point/Point;Lorg/bukkit/entity/Player;DLorg/bukkit/Color;II)V", "engine-paper"})
public final class PointKt {
    @NotNull
    public static final Vector toVector(@NotNull org.bukkit.util.Vector $this$toVector) {
        Intrinsics.checkNotNullParameter((Object)$this$toVector, (String)"<this>");
        return new Vector($this$toVector.getX(), $this$toVector.getY(), $this$toVector.getZ());
    }

    @NotNull
    public static final Vector3f toPacketVector3f(@NotNull Point<?> $this$toPacketVector3f) {
        Intrinsics.checkNotNullParameter($this$toPacketVector3f, (String)"<this>");
        return new Vector3f((float)$this$toPacketVector3f.getX(), (float)$this$toPacketVector3f.getY(), (float)$this$toPacketVector3f.getZ());
    }

    @NotNull
    public static final Vector3d toPacketVector3d(@NotNull Point<?> $this$toPacketVector3d) {
        Intrinsics.checkNotNullParameter($this$toPacketVector3d, (String)"<this>");
        return new Vector3d($this$toPacketVector3d.getX(), $this$toPacketVector3d.getY(), $this$toPacketVector3d.getZ());
    }

    @NotNull
    public static final Vector3i toPacketVector3i(@NotNull Point<?> $this$toPacketVector3i) {
        Intrinsics.checkNotNullParameter($this$toPacketVector3i, (String)"<this>");
        return new Vector3i($this$toPacketVector3i.getBlockX(), $this$toPacketVector3i.getBlockY(), $this$toPacketVector3i.getBlockZ());
    }

    @NotNull
    public static final org.bukkit.util.Vector toBukkitVector(@NotNull Point<?> $this$toBukkitVector) {
        Intrinsics.checkNotNullParameter($this$toBukkitVector, (String)"<this>");
        return new org.bukkit.util.Vector($this$toBukkitVector.getX(), $this$toBukkitVector.getY(), $this$toBukkitVector.getZ());
    }

    @NotNull
    public static final World toBukkitWorld(@NotNull com.typewritermc.core.utils.point.World $this$toBukkitWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$toBukkitWorld, (String)"<this>");
        World world = ServerExtensionsKt.getServer().getWorld(UUID.fromString($this$toBukkitWorld.getIdentifier()));
        if (world == null) {
            throw new IllegalArgumentException("Could not find world '" + $this$toBukkitWorld.getIdentifier() + "' for location, and no default world available.");
        }
        return world;
    }

    @NotNull
    public static final com.typewritermc.core.utils.point.World toWorld(@NotNull World $this$toWorld) {
        Intrinsics.checkNotNullParameter((Object)$this$toWorld, (String)"<this>");
        String string = $this$toWorld.getUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new com.typewritermc.core.utils.point.World(string);
    }

    @NotNull
    public static final <RWP extends Point<RWP> & Rotatable<RWP>> org.bukkit.Location toBukkitLocation(@NotNull RWP $this$toBukkitLocation) {
        Intrinsics.checkNotNullParameter($this$toBukkitLocation, (String)"<this>");
        return new org.bukkit.Location(PointKt.toBukkitWorld(((WorldHolder)$this$toBukkitLocation).getWorld()), $this$toBukkitLocation.getX(), $this$toBukkitLocation.getY(), $this$toBukkitLocation.getZ(), ((Rotatable<RWP>)$this$toBukkitLocation).getYaw(), ((Rotatable<RWP>)$this$toBukkitLocation).getPitch());
    }

    @Nullable
    public static final <RWP extends Point<RWP> & Rotatable<RWP>> RWP firstWalkableLocationBelow(@NotNull RWP $this$firstWalkableLocationBelow, int maxDepth) {
        Intrinsics.checkNotNullParameter($this$firstWalkableLocationBelow, (String)"<this>");
        org.bukkit.Location location = PointKt.toBukkitLocation($this$firstWalkableLocationBelow);
        int max = maxDepth;
        while (location.getBlock().isPassable() && max-- > 0) {
            double d = location.getY();
            location.setY(d + -1.0);
        }
        if (max == 0) {
            return null;
        }
        return $this$firstWalkableLocationBelow.withY(location.getY() + 1.0);
    }

    public static /* synthetic */ Point firstWalkableLocationBelow$default(Point point, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 7;
        }
        return PointKt.firstWalkableLocationBelow(point, n);
    }

    @NotNull
    public static final <RP extends Point<RP> & Rotatable<RP>> Location toPacketLocation(@NotNull RP $this$toPacketLocation) {
        Intrinsics.checkNotNullParameter($this$toPacketLocation, (String)"<this>");
        return new Location($this$toPacketLocation.getX(), $this$toPacketLocation.getY(), $this$toPacketLocation.getZ(), ((Rotatable<RP>)$this$toPacketLocation).getYaw(), ((Rotatable<RP>)$this$toPacketLocation).getPitch());
    }

    @NotNull
    public static final Position toPosition(@NotNull org.bukkit.Location $this$toPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$toPosition, (String)"<this>");
        String string = $this$toPosition.getWorld().getUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Position(new com.typewritermc.core.utils.point.World(string), $this$toPosition.getX(), $this$toPosition.getY(), $this$toPosition.getZ(), $this$toPosition.getYaw(), $this$toPosition.getPitch());
    }

    @NotNull
    public static final Location toPacketLocation(@NotNull org.bukkit.Location $this$toPacketLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$toPacketLocation, (String)"<this>");
        Location location = SpigotConversionUtil.fromBukkitLocation((org.bukkit.Location)$this$toPacketLocation);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"fromBukkitLocation(...)");
        return location;
    }

    @NotNull
    public static final Coordinate toCoordinate(@NotNull org.bukkit.Location $this$toCoordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$toCoordinate, (String)"<this>");
        return new Coordinate($this$toCoordinate.getX(), $this$toCoordinate.getY(), $this$toCoordinate.getZ(), $this$toCoordinate.getYaw(), $this$toCoordinate.getPitch());
    }

    @NotNull
    public static final <RP extends Point<RP> & Rotatable<RP>> org.bukkit.Location toBukkitLocation(@NotNull RP $this$toBukkitLocation, @NotNull World bukkitWorld) {
        Intrinsics.checkNotNullParameter($this$toBukkitLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bukkitWorld, (String)"bukkitWorld");
        return new org.bukkit.Location(bukkitWorld, $this$toBukkitLocation.getX(), $this$toBukkitLocation.getY(), $this$toBukkitLocation.getZ(), ((Rotatable<RP>)$this$toBukkitLocation).getYaw(), ((Rotatable<RP>)$this$toBukkitLocation).getPitch());
    }

    @NotNull
    public static final Coordinate toCoordinate(@NotNull Location $this$toCoordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$toCoordinate, (String)"<this>");
        return new Coordinate($this$toCoordinate.getX(), $this$toCoordinate.getY(), $this$toCoordinate.getZ(), $this$toCoordinate.getYaw(), $this$toCoordinate.getPitch());
    }

    @NotNull
    public static final Position getPosition(@NotNull Player $this$position) {
        Intrinsics.checkNotNullParameter((Object)$this$position, (String)"<this>");
        org.bukkit.Location location = $this$position.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return PointKt.toPosition(location);
    }

    public static final <P extends Point<P>> void particleSphere(@NotNull P $this$particleSphere, @NotNull Player player, double radius, @NotNull Color color, int phiDivisions, int thetaDivisions) {
        Intrinsics.checkNotNullParameter($this$particleSphere, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        double phi = 0.0;
        while (phi < Math.PI) {
            phi += Math.PI / (double)phiDivisions;
            double theta = 0.0;
            while (theta < Math.PI * 2) {
                double x = radius * Math.sin(phi) * Math.cos(theta += Math.PI / (double)thetaDivisions);
                double y = radius * Math.cos(phi);
                double z = radius * Math.sin(phi) * Math.sin(theta);
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerParticle(new Particle(ParticleTypes.DUST, (ParticleData)new ParticleDustData((float)Math.sqrt(radius / (double)3), ExtensionsKt.toPacketColor(color))), true, new Vector3d($this$particleSphere.getX() + x, $this$particleSphere.getY() + y, $this$particleSphere.getZ() + z), Vector3f.zero(), 0.0f, 1), player);
            }
        }
    }

    public static /* synthetic */ void particleSphere$default(Point point, Player player, double d, Color color, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 16;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 8;
        }
        PointKt.particleSphere(point, player, d, color, n, n2);
    }
}

