/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.StaticSound;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.typewritermc.core.entries.Query;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.extension.annotations.InnerMax;
import com.typewritermc.core.extension.annotations.InnerMin;
import com.typewritermc.core.extension.annotations.Max;
import com.typewritermc.core.extension.annotations.Min;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.SoundEmitter;
import com.typewritermc.engine.paper.entry.entries.SoundSourceEntry;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.EmitterSoundSource;
import com.typewritermc.engine.paper.utils.LocationSoundSource;
import com.typewritermc.engine.paper.utils.SelfSoundSource;
import com.typewritermc.engine.paper.utils.SoundId;
import com.typewritermc.engine.paper.utils.SoundSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003JG\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u001b\u0010\u0019R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lcom/typewritermc/engine/paper/utils/Sound;", "", "soundId", "Lcom/typewritermc/engine/paper/utils/SoundId;", "soundSource", "Lcom/typewritermc/engine/paper/utils/SoundSource;", "track", "Lnet/kyori/adventure/sound/Sound$Source;", "volume", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "pitch", "<init>", "(Lcom/typewritermc/engine/paper/utils/SoundId;Lcom/typewritermc/engine/paper/utils/SoundSource;Lnet/kyori/adventure/sound/Sound$Source;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "getSoundId", "()Lcom/typewritermc/engine/paper/utils/SoundId;", "getSoundSource$annotations", "()V", "getSoundSource", "()Lcom/typewritermc/engine/paper/utils/SoundSource;", "getTrack$annotations", "getTrack", "()Lnet/kyori/adventure/sound/Sound$Source;", "getVolume$annotations", "getVolume", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getPitch$annotations", "getPitch", "soundStop", "Lnet/kyori/adventure/sound/SoundStop;", "getSoundStop", "()Lnet/kyori/adventure/sound/SoundStop;", "play", "", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSound.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sound.kt\ncom/typewritermc/engine/paper/utils/Sound\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Query.kt\ncom/typewritermc/core/entries/Query$Companion\n*L\n1#1,112:1\n1#2:113\n187#3:114\n*S KotlinDebug\n*F\n+ 1 Sound.kt\ncom/typewritermc/engine/paper/utils/Sound\n*L\n53#1:114\n*E\n"})
public final class Sound {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SoundId soundId;
    @NotNull
    private final SoundSource soundSource;
    @NotNull
    private final Sound.Source track;
    @NotNull
    private final Var<Float> volume;
    @NotNull
    private final Var<Float> pitch;
    @NotNull
    private static final Sound EMPTY = new Sound(null, null, null, null, null, 31, null);

    public Sound(@NotNull SoundId soundId, @NotNull SoundSource soundSource, @NotNull Sound.Source track, @NotNull Var<Float> volume, @NotNull Var<Float> pitch) {
        Intrinsics.checkNotNullParameter((Object)soundId, (String)"soundId");
        Intrinsics.checkNotNullParameter((Object)soundSource, (String)"soundSource");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter(volume, (String)"volume");
        Intrinsics.checkNotNullParameter(pitch, (String)"pitch");
        this.soundId = soundId;
        this.soundSource = soundSource;
        this.track = track;
        this.volume = volume;
        this.pitch = pitch;
    }

    public /* synthetic */ Sound(SoundId soundId, SoundSource soundSource, Sound.Source source, Var var, Var var2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            soundId = SoundId.Companion.getEMPTY();
        }
        if ((n & 2) != 0) {
            soundSource = SelfSoundSource.INSTANCE;
        }
        if ((n & 4) != 0) {
            source = Sound.Source.MASTER;
        }
        if ((n & 8) != 0) {
            var = new ConstVar<Float>(Float.valueOf(1.0f));
        }
        if ((n & 0x10) != 0) {
            var2 = new ConstVar<Float>(Float.valueOf(1.0f));
        }
        this(soundId, soundSource, source, var, var2);
    }

    @NotNull
    public final SoundId getSoundId() {
        return this.soundId;
    }

    @NotNull
    public final SoundSource getSoundSource() {
        return this.soundSource;
    }

    @Help(text="The source of the location to play the sound from. (Defaults to player's location)")
    public static /* synthetic */ void getSoundSource$annotations() {
    }

    @NotNull
    public final Sound.Source getTrack() {
        return this.track;
    }

    @Help(text="Corresponds to the Minecraft sound category")
    public static /* synthetic */ void getTrack$annotations() {
    }

    @NotNull
    public final Var<Float> getVolume() {
        return this.volume;
    }

    @Help(text="A value of 1.0 is normal volume.")
    @InnerMin(annotation=@Min(value=0))
    @Default(json="1.0")
    public static /* synthetic */ void getVolume$annotations() {
    }

    @NotNull
    public final Var<Float> getPitch() {
        return this.pitch;
    }

    @Help(text="A value of 1.0 is normal pitch.")
    @InnerMin(annotation=@Min(value=0))
    @InnerMax(annotation=@Max(value=2))
    @Default(json="1.0")
    public static /* synthetic */ void getPitch$annotations() {
    }

    @Nullable
    public final SoundStop getSoundStop() {
        SoundStop soundStop;
        NamespacedKey namespacedKey = this.soundId.getNamespacedKey();
        if (namespacedKey != null) {
            NamespacedKey it = namespacedKey;
            boolean bl = false;
            soundStop = SoundStop.named((Key)((Key)it));
        } else {
            soundStop = null;
        }
        return soundStop;
    }

    /*
     * WARNING - void declaration
     */
    public final void play(@NotNull Player player, @Nullable InteractionContext context) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NamespacedKey namespacedKey = this.soundId.getNamespacedKey();
        if (namespacedKey == null) {
            return;
        }
        NamespacedKey key = namespacedKey;
        net.kyori.adventure.sound.Sound sound = net.kyori.adventure.sound.Sound.sound((Key)((Key)key), (Sound.Source)this.track, (float)((Number)this.volume.get(player, context)).floatValue(), (float)((Number)this.pitch.get(player, context)).floatValue());
        Intrinsics.checkNotNullExpressionValue((Object)sound, (String)"sound(...)");
        net.kyori.adventure.sound.Sound sound2 = sound;
        SoundSource soundSource = this.soundSource;
        if (soundSource instanceof SelfSoundSource) {
            player.playSound(sound2);
        } else if (soundSource instanceof EmitterSoundSource) {
            void this_$iv;
            String entryId = ((EmitterSoundSource)this.soundSource).getEntryId();
            Query.Companion companion = Query.Companion;
            String id$iv = entryId;
            boolean $i$f$findById = false;
            SoundSourceEntry entry2 = (SoundSourceEntry)this_$iv.findById(Reflection.getOrCreateKotlinClass(SoundSourceEntry.class), id$iv);
            if (entry2 == null) {
                TypewriterPaperPluginKt.getLogger().warning("Could not find sound source entry with id " + entryId);
                return;
            }
            SoundEmitter emitter = entry2.getEmitter(player);
            StaticSound packetSound = new StaticSound(new ResourceLocation(key.getNamespace(), key.getKey()), Float.valueOf(16.0f));
            SoundCategory category = SoundCategory.fromId((int)this.track.ordinal());
            PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerEntitySoundEffect((com.github.retrooper.packetevents.protocol.sound.Sound)packetSound, category, emitter.getEntityId(), sound2.volume(), sound2.pitch()), player);
        } else if (soundSource instanceof LocationSoundSource) {
            Position location = ((LocationSoundSource)this.soundSource).getPosition();
            player.playSound(sound2, location.getX(), location.getY(), location.getZ());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final SoundId component1() {
        return this.soundId;
    }

    @NotNull
    public final SoundSource component2() {
        return this.soundSource;
    }

    @NotNull
    public final Sound.Source component3() {
        return this.track;
    }

    @NotNull
    public final Var<Float> component4() {
        return this.volume;
    }

    @NotNull
    public final Var<Float> component5() {
        return this.pitch;
    }

    @NotNull
    public final Sound copy(@NotNull SoundId soundId, @NotNull SoundSource soundSource, @NotNull Sound.Source track, @NotNull Var<Float> volume, @NotNull Var<Float> pitch) {
        Intrinsics.checkNotNullParameter((Object)soundId, (String)"soundId");
        Intrinsics.checkNotNullParameter((Object)soundSource, (String)"soundSource");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter(volume, (String)"volume");
        Intrinsics.checkNotNullParameter(pitch, (String)"pitch");
        return new Sound(soundId, soundSource, track, volume, pitch);
    }

    public static /* synthetic */ Sound copy$default(Sound sound, SoundId soundId, SoundSource soundSource, Sound.Source source, Var var, Var var2, int n, Object object) {
        if ((n & 1) != 0) {
            soundId = sound.soundId;
        }
        if ((n & 2) != 0) {
            soundSource = sound.soundSource;
        }
        if ((n & 4) != 0) {
            source = sound.track;
        }
        if ((n & 8) != 0) {
            var = sound.volume;
        }
        if ((n & 0x10) != 0) {
            var2 = sound.pitch;
        }
        return sound.copy(soundId, soundSource, source, var, var2);
    }

    @NotNull
    public String toString() {
        return "Sound(soundId=" + this.soundId + ", soundSource=" + this.soundSource + ", track=" + this.track + ", volume=" + this.volume + ", pitch=" + this.pitch + ")";
    }

    public int hashCode() {
        int result = this.soundId.hashCode();
        result = result * 31 + this.soundSource.hashCode();
        result = result * 31 + this.track.hashCode();
        result = result * 31 + this.volume.hashCode();
        result = result * 31 + this.pitch.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Sound)) {
            return false;
        }
        Sound sound = (Sound)other;
        if (!Intrinsics.areEqual((Object)this.soundId, (Object)sound.soundId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.soundSource, (Object)sound.soundSource)) {
            return false;
        }
        if (this.track != sound.track) {
            return false;
        }
        if (!Intrinsics.areEqual(this.volume, sound.volume)) {
            return false;
        }
        return Intrinsics.areEqual(this.pitch, sound.pitch);
    }

    public Sound() {
        this(null, null, null, null, null, 31, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/engine/paper/utils/Sound$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/typewritermc/engine/paper/utils/Sound;", "getEMPTY", "()Lcom/typewritermc/engine/paper/utils/Sound;", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sound getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

