/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils.item;

import com.typewritermc.core.extension.annotations.AlgebraicTypeInfo;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.interaction.InteractionContext;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import com.typewritermc.engine.paper.utils.item.Item;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AlgebraicTypeInfo(name="serialized_item", color="#F57C00", icon="mingcute:file-code-fill")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u001c\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J&\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J&\u0010\u001d\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/engine/paper/utils/item/SerializedItem;", "Lcom/typewritermc/engine/paper/utils/item/Item;", "material", "Lorg/bukkit/Material;", "name", "", "amount", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "bytes", "<init>", "(Lorg/bukkit/Material;Ljava/lang/String;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/lang/String;)V", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/inventory/ItemStack;)V", "getAmount$annotations", "()V", "getItemStack", "()Lorg/bukkit/inventory/ItemStack;", "itemStack$delegate", "Lkotlin/Lazy;", "build", "player", "Lorg/bukkit/entity/Player;", "context", "Lcom/typewritermc/core/interaction/InteractionContext;", "isSameAs", "", "item", "exactMatch", "engine-paper"})
public final class SerializedItem
implements Item {
    @NotNull
    private final Material material;
    @NotNull
    private final String name;
    @NotNull
    private final Var<Integer> amount;
    @NotNull
    private final String bytes;
    @NotNull
    private final transient Lazy itemStack$delegate;

    public SerializedItem(@NotNull Material material, @NotNull String name, @NotNull Var<Integer> amount, @NotNull String bytes) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.material = material;
        this.name = name;
        this.amount = amount;
        this.bytes = bytes;
        this.itemStack$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SerializedItem.itemStack_delegate$lambda$0(this));
    }

    public /* synthetic */ SerializedItem(Material material, String string, Var var, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            material = Material.AIR;
        }
        if ((n & 2) != 0) {
            string = material.name();
        }
        if ((n & 4) != 0) {
            var = new ConstVar<Integer>(1);
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        this(material, string, var, string2);
    }

    @Default(json="1")
    private static /* synthetic */ void getAmount$annotations() {
    }

    public SerializedItem(@NotNull ItemStack itemStack) {
        String string;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Material material = itemStack.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Object object = itemStack.getItemMeta();
        if (object == null || (object = object.displayName()) == null || (object = MiniMessagesKt.plainText((Component)object)) == null) {
            object = itemStack.getType().name();
        }
        Var var = new ConstVar<Integer>(itemStack.getAmount());
        if (itemStack.getType() != Material.AIR) {
            Base64 base64 = (Base64)Base64.Default;
            byte[] byArray = itemStack.serializeAsBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serializeAsBytes(...)");
            string = Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
        } else {
            string = "";
        }
        this(material, (String)object, var, string);
    }

    private final ItemStack getItemStack() {
        Lazy lazy = this.itemStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    @Override
    @NotNull
    public ItemStack build(@Nullable Player player, @Nullable InteractionContext context) {
        ItemStack itemStack;
        ItemStack itemStack2 = this.getItemStack().clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        ItemStack $this$build_u24lambda_u241 = itemStack = itemStack2;
        boolean bl = false;
        Integer n = VariableEntryKt.get(this.amount, player, context);
        $this$build_u24lambda_u241.setAmount(n != null ? n : 1);
        return itemStack;
    }

    @Override
    public boolean isSameAs(@Nullable Player player, @Nullable ItemStack item, @Nullable InteractionContext context) {
        return this.getItemStack().isSimilar(item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exactMatch(@Nullable Player player, @Nullable ItemStack item, @Nullable InteractionContext context) {
        if (!this.getItemStack().isSimilar(item)) return false;
        if (item == null) return false;
        if (this.getItemStack().getAmount() != item.getAmount()) return false;
        return true;
    }

    private static final ItemStack itemStack_delegate$lambda$0(SerializedItem this$0) {
        byte[] bytes = Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)this$0.bytes, (int)0, (int)0, (int)6, null);
        if (bytes.length == 0) {
            return new ItemStack(Material.AIR);
        }
        ItemStack itemStack = ItemStack.deserializeBytes((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserializeBytes(...)");
        return itemStack;
    }

    public SerializedItem() {
        this(null, null, null, null, 15, null);
    }
}

